/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.generators;

import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;
import org.eclipse.titanium.error.ErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.GraphGenerator;

public class ModuleGraphGenerator
extends GraphGenerator {
    public ModuleGraphGenerator(IProject project, ErrorHandler eHandler) {
        super(project, eHandler);
        if (eHandler == null) {
            this.errorHandler.reportErrorMessage("The referenced error handler mustn't be null (source: ModuleGraphGenerator)");
        }
    }

    @Override
    protected void createGraph() {
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        if (sourceParser.getLastTimeChecked() == null) {
            WorkspaceJob job = sourceParser.analyzeAll();
            while (job == null) {
                try {
                    Thread.sleep(500L);
                    job = sourceParser.analyzeAll();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((String)"Error while waiting for analyzis result", (Throwable)e);
                }
            }
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while parsing the project", (Throwable)e);
            }
        }
        List visitedProjects = ProjectBasedBuilder.getProjectBasedBuilder((IProject)this.project).getAllReachableProjects();
        HashMap<String, Identifier> globalKnownModules = new HashMap<String, Identifier>();
        for (int i = 0; i < visitedProjects.size(); ++i) {
            NodeDescriptor actNode;
            IProject currentProject = (IProject)visitedProjects.get(i);
            ProjectStructureDataCollector collector = GlobalProjectStructureTracker.getDataCollector((IProject)currentProject);
            collector.evaulateMissingModules();
            for (Identifier moduleName : collector.knownModules.values()) {
                actNode = new NodeDescriptor(moduleName.getDisplayName(), moduleName.getName(), currentProject, false, moduleName.getLocation());
                globalKnownModules.put(moduleName.getName(), moduleName);
                if (this.graph.containsVertex((Object)actNode)) continue;
                this.graph.addVertex((Object)actNode);
                this.labels.put(actNode.getName(), actNode);
            }
            for (Identifier moduleName : collector.missingModules.values()) {
                if (globalKnownModules.containsKey(moduleName.getName()) || this.graph.containsVertex((Object)(actNode = new NodeDescriptor(moduleName.getDisplayName(), moduleName.getName(), currentProject, true, moduleName.getLocation())))) continue;
                this.graph.addVertex((Object)actNode);
                this.labels.put(actNode.getName(), actNode);
            }
            for (String from : collector.importations.keySet()) {
                for (String to : (List)collector.importations.get(from)) {
                    EdgeDescriptor edge = new EdgeDescriptor(from + "->" + to, Color.black);
                    this.graph.addEdge((Object)edge, this.labels.get(from), this.labels.get(to), EdgeType.DIRECTED);
                }
            }
        }
    }
}

