/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.visualization;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.graph.clustering.gui.ClusterTransformer;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.common.Layouts;
import org.eclipse.titanium.graph.gui.layouts.MetricLayout;
import org.eclipse.titanium.graph.gui.layouts.ReverseDAGLayout;
import org.eclipse.titanium.graph.gui.layouts.TitaniumDAGLayout;
import org.eclipse.titanium.graph.gui.layouts.TitaniumISOMLayout;
import org.eclipse.titanium.graph.gui.utils.LayoutEntry;
import org.eclipse.titanium.graph.gui.utils.MetricsLayoutEntry;
import org.eclipse.titanium.graph.visualization.BadLayoutException;
import org.eclipse.titanium.graph.visualization.ErrorType;

public class LayoutBuilder {
    private final DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> g;
    private final LayoutEntry layoutEntry;
    private final Dimension size;
    private Set<Set<NodeDescriptor>> clusters;
    private Transformer<NodeDescriptor, Point2D> pointTransformer;

    public LayoutBuilder(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph, LayoutEntry entry, Dimension size) {
        this.g = graph;
        this.layoutEntry = entry;
        this.size = size;
    }

    public LayoutBuilder clusters(Set<Set<NodeDescriptor>> clusters) {
        this.clusters = clusters;
        return this;
    }

    public LayoutBuilder transformer(Transformer<NodeDescriptor, Point2D> trf) {
        this.pointTransformer = trf;
        return this;
    }

    public Layout<NodeDescriptor, EdgeDescriptor> build() throws BadLayoutException {
        Object layout;
        String layoutCode = this.layoutEntry.getCode();
        if (layoutCode.equals(Layouts.LAYOUT_ISOM.getCode())) {
            layout = new TitaniumISOMLayout(this.g);
            layout.setMaxIterations(Activator.getDefault().getPreferenceStore().getInt("Graph_Layout_Iterations"));
        } else if (layoutCode.equals(Layouts.LAYOUT_KK.getCode())) {
            layout = new KKLayout(this.g);
            layout.setMaxIterations(Activator.getDefault().getPreferenceStore().getInt("Graph_Layout_Iterations"));
        } else if (layoutCode.equals(Layouts.LAYOUT_FR.getCode())) {
            layout = new FRLayout(this.g);
            ((FRLayout)layout).setAttractionMultiplier(0.6);
            ((FRLayout)layout).setRepulsionMultiplier(0.8);
            ((FRLayout)layout).setMaxIterations(Activator.getDefault().getPreferenceStore().getInt("Graph_Layout_Iterations"));
        } else if (layoutCode.equals(Layouts.LAYOUT_SPRING.getCode())) {
            layout = new SpringLayout(this.g);
        } else if (layoutCode.equals(Layouts.LAYOUT_CIRCLE.getCode())) {
            layout = new CircleLayout(this.g);
        } else if (layoutCode.equals(Layouts.LAYOUT_RTDAG.getCode())) {
            layout = new ReverseDAGLayout<NodeDescriptor, EdgeDescriptor>((Graph<NodeDescriptor, EdgeDescriptor>)this.g, this.size);
        } else if (layoutCode.equals(Layouts.LAYOUT_TDAG.getCode())) {
            layout = new TitaniumDAGLayout<NodeDescriptor, EdgeDescriptor>((Graph<NodeDescriptor, EdgeDescriptor>)this.g, this.size);
        } else if (layoutCode.equals("METRIC")) {
            if (!(this.layoutEntry instanceof MetricsLayoutEntry)) {
                throw new IllegalStateException("A metric must be chosen before using metric layout!");
            }
            layout = new MetricLayout<EdgeDescriptor>((Graph<NodeDescriptor, EdgeDescriptor>)this.g, this.size, ((MetricsLayoutEntry)this.layoutEntry).getMetric());
        } else if (layoutCode.equals("Cluster")) {
            if (this.clusters == null) {
                throw new IllegalStateException("A clustering must be set before using cluster layout!");
            }
            ClusterTransformer trf = new ClusterTransformer((Layout<NodeDescriptor, EdgeDescriptor>)new FRLayout(this.g), this.clusters, this.size);
            layout = new StaticLayout(this.g, (Transformer)trf);
        } else if ("STATIC".equals(layoutCode)) {
            if (this.pointTransformer == null) {
                throw new IllegalStateException("A point transformer must be set before using static layout!");
            }
            layout = new StaticLayout(this.g, this.pointTransformer);
        } else {
            throw new BadLayoutException("There is no such layout! (Layout=" + layoutCode + ")", ErrorType.NOT_EXISITING_LAYOUT);
        }
        layout.setSize(this.size);
        return layout;
    }
}

