/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BasePartRenderer<N, T, M>
extends BaseRenderer<MPart, WPart<N, T, M>> {
    public static final String VIEW_MENU_TAG = "ViewMenu";

    @PostConstruct
    void init(@NonNull IEventBroker eventBroker) {
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/iconURI/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/label/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/localizedLabel/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/UILabel/localizedTooltip/*");
        this.registerEventListener(eventBroker, "org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*");
        eventBroker.subscribe("org/eclipse/e4/ui/model/basic/Part/menus/*", new EventHandler(){

            public void handleEvent(Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                MUIElement parent = (MUIElement)changedObj;
                if (parent.getRenderer() == BasePartRenderer.this) {
                    if (UIEvents.isADD((Event)event)) {
                        BasePartRenderer.this.handleMenuAddition((MPart)parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BasePartRenderer.this.handleMenuRemove((MPart)parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/basic/Part/toolbar/*", new EventHandler(){

            public void handleEvent(Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                MUIElement parent = (MUIElement)changedObj;
                if (parent.getRenderer() == BasePartRenderer.this && UIEvents.isSET((Event)event)) {
                    Object newValue = event.getProperty("NewValue");
                    if (newValue != null) {
                        BasePartRenderer.this.handleToolbarAddition((MPart)parent, (MToolBar)newValue);
                    } else {
                        BasePartRenderer.this.handleToolbarRemove((MPart)parent, (MToolBar)event.getProperty("OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement parent;
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                if (changedObj.isToBeRendered() && (parent = (MUIElement)((EObject)changedObj).eContainer()) != null && BasePartRenderer.this == parent.getRenderer()) {
                    MPart part = (MPart)parent;
                    String eventType = (String)event.getProperty("EventType");
                    if ("SET".equals(eventType)) {
                        Boolean newValue = (Boolean)event.getProperty("NewValue");
                        if (newValue.booleanValue()) {
                            BasePartRenderer.this.childRendered(part, changedObj);
                        } else {
                            BasePartRenderer.this.hideChild(part, changedObj);
                        }
                    }
                }
            }
        });
    }

    void handleToolbarRemove(@NonNull MPart parent, @NonNull MToolBar toolbar) {
        WPart widget = (WPart)this.getWidget((MUIElement)parent);
        if (widget == null) {
            return;
        }
        if (widget.getToolbar() == toolbar.getWidget()) {
            widget.setToolbar(null);
        }
    }

    void handleToolbarAddition(@NonNull MPart parent, @NonNull MToolBar toolbar) {
        WPart widget = (WPart)this.getWidget((MUIElement)parent);
        if (widget == null) {
            return;
        }
        WToolBar wtoolbar = (WToolBar)this.getPresentationEngine().createGui((MUIElement)toolbar);
        widget.setToolbar(wtoolbar);
    }

    @Override
    protected void initWidget(final MPart element, final WPart<N, T, M> widget) {
        super.initWidget(element, widget);
        widget.registerActivationCallback(new WCallback<Boolean, Void>(){

            @Override
            public Void call(Boolean param) {
                if (param.booleanValue()) {
                    boolean requiresFocus = BasePartRenderer.this.requiresFocus(widget);
                    if (requiresFocus) {
                        BasePartRenderer.this.activate(element, true);
                    } else {
                        BasePartRenderer.this.activate(element, false);
                    }
                }
                return null;
            }
        });
    }

    protected abstract boolean requiresFocus(@NonNull WPart<N, T, M> var1);

    @Override
    public void doProcessContent(@NonNull MPart element) {
        WPart widget = (WPart)this.getWidget((MUIElement)element);
        if (widget == null) {
            this.getLogger().error("No widget found for '" + element + "'");
            return;
        }
        MToolBar mToolBar = element.getToolbar();
        if (mToolBar != null) {
            WToolBar toolbar = (WToolBar)this.engineCreateWidget(mToolBar);
            widget.setToolbar(toolbar);
        }
        for (MMenu m : element.getMenus()) {
            if (!m.getTags().contains(VIEW_MENU_TAG)) continue;
            WMenu menu = (WMenu)this.engineCreateWidget(m);
            widget.setMenu(menu);
            break;
        }
        Class<?> cl = widget.getWidget().getClass();
        do {
            element.getContext().set(cl.getName(), widget.getWidget());
        } while (!(cl = cl.getSuperclass()).getName().equals("java.lang.Object"));
        IContributionFactory contributionFactory = (IContributionFactory)element.getContext().get(IContributionFactory.class);
        Object newPart = contributionFactory.create(element.getContributionURI(), element.getContext());
        element.setObject(newPart);
    }

    void handleMenuAddition(@NonNull MPart parent, Collection<MMenu> elements) {
        WPart widget = (WPart)this.getWidget((MUIElement)parent);
        if (widget == null) {
            return;
        }
        for (MUIElement mUIElement : elements) {
            if (!mUIElement.getTags().contains(VIEW_MENU_TAG)) continue;
            if (widget.getMenu() != null) break;
            WMenu menu = (WMenu)this.getPresentationEngine().createGui(mUIElement);
            widget.setMenu(menu);
            break;
        }
    }

    void handleMenuRemove(@NonNull MPart parent, Collection<MMenu> elements) {
        WPart widget = (WPart)this.getWidget((MUIElement)parent);
        if (widget == null) {
            return;
        }
        for (MMenu e : elements) {
            if (!e.getTags().contains(VIEW_MENU_TAG) || widget.getMenu() != e.getWidget()) continue;
            widget.setMenu(null);
        }
    }

    public void childRendered(MPart parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !element.isVisible()) {
            return;
        }
        if (element instanceof MToolBar) {
            this.handleToolbarAddition(parentElement, (MToolBar)element);
        } else if (element instanceof MMenu) {
            this.handleMenuAddition(parentElement, Collections.singletonList((MMenu)element));
        }
    }

    public void hideChild(MPart container, MUIElement changedObj) {
        if (changedObj instanceof MToolBar) {
            this.handleToolbarRemove(container, (MToolBar)changedObj);
        } else if (changedObj instanceof MMenu) {
            this.handleMenuRemove(container, Collections.singletonList((MMenu)changedObj));
        }
    }
}

