/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.key;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.input.KeyCode;
import org.eclipse.fx.ui.keybindings.KeyLookup;
import org.osgi.framework.FrameworkUtil;

public final class FxKeyLookup
implements KeyLookup {
    private final Map<String, Integer> modifierKeyTable = new HashMap<String, Integer>();
    private final Map<Integer, String> nameTable = new HashMap<Integer, String>();
    private final Map<String, Integer> naturalKeyTable = new HashMap<String, Integer>();
    public static final int ALT = 65536;
    public static final int SHIFT = 131072;
    public static final int CTRL = 262144;
    public static final int COMMAND = 0x400000;
    public static final int MODIFIER_MASK = 0x470000;
    public static final int NO_KEY = 0;
    private static final boolean isMac = "macosx".equals(FrameworkUtil.getBundle(FxKeyLookup.class).getBundleContext().getProperty("osgi.os"));
    private static final String ZERO_LENGTH_STRING = "";

    public FxKeyLookup() {
        Integer alt = new Integer(65536);
        Integer command = new Integer(0x400000);
        Integer ctrl = new Integer(262144);
        Integer shift = new Integer(131072);
        this.modifierKeyTable.put("ALT", alt);
        this.nameTable.put(alt, "ALT");
        this.modifierKeyTable.put("COMMAND", command);
        this.nameTable.put(command, "COMMAND");
        this.modifierKeyTable.put("CTRL", ctrl);
        this.nameTable.put(ctrl, "CTRL");
        this.modifierKeyTable.put("SHIFT", shift);
        this.nameTable.put(shift, "SHIFT");
        this.modifierKeyTable.put("M1", isMac ? command : ctrl);
        this.modifierKeyTable.put("M2", shift);
        this.modifierKeyTable.put("M3", alt);
        this.modifierKeyTable.put("M4", isMac ? ctrl : command);
        Integer code = KeyCode.DOWN.impl_getCode();
        this.naturalKeyTable.put("ARROW_DOWN", code);
        this.nameTable.put(code, "ARROW_DOWN");
        code = KeyCode.LEFT.impl_getCode();
        this.naturalKeyTable.put("ARROW_LEFT", code);
        this.nameTable.put(code, "ARROW_LEFT");
        code = KeyCode.RIGHT.impl_getCode();
        this.naturalKeyTable.put("ARROW_RIGHT", code);
        this.nameTable.put(code, "ARROW_RIGHT");
        code = KeyCode.UP.impl_getCode();
        this.naturalKeyTable.put("ARROW_UP", code);
        this.nameTable.put(code, "ARROW_UP");
        code = KeyCode.BACK_SPACE.impl_getCode();
        this.naturalKeyTable.put("BS", code);
        this.nameTable.put(code, "BS");
        code = KeyCode.CAPS.impl_getCode();
        this.naturalKeyTable.put("CAPS_LOCK", code);
        this.nameTable.put(code, "CAPS_LOCK");
        code = KeyCode.ENTER.impl_getCode();
        this.naturalKeyTable.put("CR", code);
        this.nameTable.put(code, "CR");
        this.naturalKeyTable.put("ENTER", code);
        this.naturalKeyTable.put("RETURN", code);
        code = KeyCode.DELETE.impl_getCode();
        this.naturalKeyTable.put("DEL", code);
        this.nameTable.put(code, "DEL");
        code = KeyCode.END.impl_getCode();
        this.naturalKeyTable.put("END", code);
        this.nameTable.put(code, "END");
        code = KeyCode.ESCAPE.impl_getCode();
        this.naturalKeyTable.put("ESC", code);
        this.nameTable.put(code, "ESC");
        code = KeyCode.F1.impl_getCode();
        this.naturalKeyTable.put("F1", code);
        this.nameTable.put(code, "F1");
        code = KeyCode.F2.impl_getCode();
        this.naturalKeyTable.put("F2", code);
        this.nameTable.put(code, "F2");
        code = KeyCode.F3.impl_getCode();
        this.naturalKeyTable.put("F3", code);
        this.nameTable.put(code, "F3");
        code = KeyCode.F4.impl_getCode();
        this.naturalKeyTable.put("F4", code);
        this.nameTable.put(code, "F4");
        code = KeyCode.F5.impl_getCode();
        this.naturalKeyTable.put("F5", code);
        this.nameTable.put(code, "F5");
        code = KeyCode.F6.impl_getCode();
        this.naturalKeyTable.put("F6", code);
        this.nameTable.put(code, "F6");
        code = KeyCode.F7.impl_getCode();
        this.naturalKeyTable.put("F7", code);
        this.nameTable.put(code, "F7");
        code = KeyCode.F8.impl_getCode();
        this.naturalKeyTable.put("F8", code);
        this.nameTable.put(code, "F8");
        code = KeyCode.F9.impl_getCode();
        this.naturalKeyTable.put("F9", code);
        this.nameTable.put(code, "F9");
        code = KeyCode.F10.impl_getCode();
        this.naturalKeyTable.put("F10", code);
        this.nameTable.put(code, "F10");
        code = KeyCode.F11.impl_getCode();
        this.naturalKeyTable.put("F11", code);
        this.nameTable.put(code, "F11");
        code = KeyCode.F12.impl_getCode();
        this.naturalKeyTable.put("F12", code);
        this.nameTable.put(code, "F12");
        code = KeyCode.F13.impl_getCode();
        this.naturalKeyTable.put("F13", code);
        this.nameTable.put(code, "F13");
        code = KeyCode.F14.impl_getCode();
        this.naturalKeyTable.put("F14", code);
        this.nameTable.put(code, "F14");
        code = KeyCode.F15.impl_getCode();
        this.naturalKeyTable.put("F15", code);
        this.nameTable.put(code, "F15");
        code = KeyCode.F16.impl_getCode();
        this.naturalKeyTable.put("F16", code);
        this.nameTable.put(code, "F16");
        code = KeyCode.F17.impl_getCode();
        this.naturalKeyTable.put("F17", code);
        this.nameTable.put(code, "F17");
        code = KeyCode.F18.impl_getCode();
        this.naturalKeyTable.put("F18", code);
        this.nameTable.put(code, "F18");
        code = KeyCode.F19.impl_getCode();
        this.naturalKeyTable.put("F19", code);
        this.nameTable.put(code, "F19");
        code = KeyCode.F20.impl_getCode();
        this.naturalKeyTable.put("F20", code);
        this.nameTable.put(code, "F20");
        code = KeyCode.HOME.impl_getCode();
        this.naturalKeyTable.put("HOME", code);
        this.nameTable.put(code, "HOME");
        code = KeyCode.INSERT.impl_getCode();
        this.naturalKeyTable.put("INSERT", code);
        this.nameTable.put(code, "INSERT");
        code = KeyCode.NUM_LOCK.impl_getCode();
        this.naturalKeyTable.put("NUM_LOCK", code);
        this.nameTable.put(code, "NUM_LOCK");
        code = KeyCode.NUMPAD0.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_0", code);
        this.nameTable.put(code, "NUMPAD_0");
        code = KeyCode.NUMPAD1.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_1", code);
        this.nameTable.put(code, "NUMPAD_1");
        code = KeyCode.NUMPAD2.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_2", code);
        this.nameTable.put(code, "NUMPAD_2");
        code = KeyCode.NUMPAD3.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_3", code);
        this.nameTable.put(code, "NUMPAD_3");
        code = KeyCode.NUMPAD4.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_4", code);
        this.nameTable.put(code, "NUMPAD_4");
        code = KeyCode.NUMPAD5.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_5", code);
        this.nameTable.put(code, "NUMPAD_5");
        code = KeyCode.NUMPAD6.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_6", code);
        this.nameTable.put(code, "NUMPAD_6");
        code = KeyCode.NUMPAD7.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_7", code);
        this.nameTable.put(code, "NUMPAD_7");
        code = KeyCode.NUMPAD8.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_8", code);
        this.nameTable.put(code, "NUMPAD_8");
        code = KeyCode.NUMPAD9.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_9", code);
        this.nameTable.put(code, "NUMPAD_9");
        code = KeyCode.ADD.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_ADD", code);
        this.nameTable.put(code, "NUMPAD_ADD");
        code = KeyCode.DECIMAL.impl_getCode();
        this.naturalKeyTable.put("NUMPAD_DECIMAL", code);
        this.nameTable.put(code, "NUMPAD_DECIMAL");
        code = KeyCode.PAGE_DOWN.impl_getCode();
        this.naturalKeyTable.put("PAGE_DOWN", code);
        this.nameTable.put(code, "PAGE_DOWN");
        code = KeyCode.PAGE_UP.impl_getCode();
        this.naturalKeyTable.put("PAGE_UP", code);
        this.nameTable.put(code, "PAGE_UP");
        code = KeyCode.PAUSE.impl_getCode();
        this.naturalKeyTable.put("PAUSE", code);
        this.nameTable.put(code, "PAUSE");
        code = KeyCode.PRINTSCREEN.impl_getCode();
        this.naturalKeyTable.put("PRINT_SCREEN", code);
        this.nameTable.put(code, "PRINT_SCREEN");
        code = KeyCode.SCROLL_LOCK.impl_getCode();
        this.naturalKeyTable.put("SCROLL_LOCK", code);
        this.nameTable.put(code, "SCROLL_LOCK");
        code = KeyCode.SPACE.impl_getCode();
        this.naturalKeyTable.put("SPACE", code);
        this.nameTable.put(code, "SPACE");
        code = KeyCode.TAB.impl_getCode();
        this.naturalKeyTable.put("TAB", code);
        this.nameTable.put(code, "TAB");
    }

    public final String formalNameLookup(int key) {
        Integer keyObject = key;
        String value = this.nameTable.get(keyObject);
        if (value instanceof String) {
            return value;
        }
        return ZERO_LENGTH_STRING + (char)key;
    }

    public final int formalKeyLookup(String name) {
        Integer value = this.naturalKeyTable.get(name);
        if (value instanceof Integer) {
            return value;
        }
        return 0;
    }

    public final int formalModifierLookup(String name) {
        Integer value = this.modifierKeyTable.get(name);
        if (value instanceof Integer) {
            return value;
        }
        return 0;
    }

    public final int getAlt() {
        return 65536;
    }

    public final int getCommand() {
        return 0x400000;
    }

    public final int getCtrl() {
        return 262144;
    }

    public final int getShift() {
        return 131072;
    }
}

