/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class TokenUtil {
    @Inject
    protected IHiddenTokenHelper hiddenTokenHelper;

    public Pair<List<ILeafNode>, List<ILeafNode>> getLeadingAndTrailingHiddenTokens(INode node) {
        Pair result = Tuples.create((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        ArrayList leafNodes = Lists.newArrayList(node.getLeafNodes());
        int begin = 0;
        int end = leafNodes.size() - 1;
        while (begin <= end && ((ILeafNode)leafNodes.get(begin)).isHidden()) {
            ((List)result.getFirst()).add((ILeafNode)leafNodes.get(begin++));
        }
        while (begin <= end && ((ILeafNode)leafNodes.get(end)).isHidden()) {
            ((List)result.getSecond()).add(0, (ILeafNode)leafNodes.get(end--));
        }
        return result;
    }

    public EObject getTokenOwner(INode node) {
        if (node.hasDirectSemanticElement()) {
            return node.getSemanticElement();
        }
        if (node.getParent() != null) {
            if (node.getParent().hasDirectSemanticElement()) {
                return node.getParent().getSemanticElement();
            }
            EObject parentGrammarElement = node.getParent().getGrammarElement();
            boolean isParser = parentGrammarElement instanceof ParserRule || parentGrammarElement instanceof RuleCall && ((RuleCall)parentGrammarElement).getRule().getType().getClassifier() instanceof EClass;
            for (INode sibling : node.getParent().getChildren()) {
                if (!sibling.hasDirectSemanticElement() || !isParser && !(sibling.getGrammarElement() instanceof Action)) continue;
                return sibling.getSemanticElement();
            }
        }
        return node.getSemanticElement();
    }

    public AbstractRule getTokenRule(INode node) {
        if (node == null) {
            return null;
        }
        EObject element = node.getGrammarElement();
        if (element instanceof AbstractRule) {
            return (AbstractRule)element;
        }
        if (element instanceof CrossReference) {
            element = ((CrossReference)element).getTerminal();
        }
        if (element instanceof RuleCall) {
            return ((RuleCall)element).getRule();
        }
        return null;
    }

    public boolean isCommentNode(INode node) {
        if (node instanceof ILeafNode && ((ILeafNode)node).isHidden() && node.getGrammarElement() instanceof AbstractRule) {
            return this.hiddenTokenHelper.isComment((AbstractRule)node.getGrammarElement());
        }
        return false;
    }

    public boolean isToken(INode node) {
        if (node instanceof ILeafNode) {
            return !((ILeafNode)node).isHidden();
        }
        AbstractRule rule = node.getGrammarElement() instanceof AbstractRule ? (AbstractRule)node.getGrammarElement() : (node.getGrammarElement() instanceof RuleCall ? ((RuleCall)node.getGrammarElement()).getRule() : (node.getGrammarElement() instanceof CrossReference && ((CrossReference)node.getGrammarElement()).getTerminal() instanceof RuleCall ? ((RuleCall)((CrossReference)node.getGrammarElement()).getTerminal()).getRule() : null));
        if (rule instanceof ParserRule) {
            return GrammarUtil.isDatatypeRule((ParserRule)rule);
        }
        return rule instanceof EnumRule;
    }

    public boolean isWhitespaceNode(INode node) {
        if (node instanceof ILeafNode && ((ILeafNode)node).isHidden() && node.getGrammarElement() instanceof AbstractRule) {
            return this.hiddenTokenHelper.isWhitespace((AbstractRule)node.getGrammarElement());
        }
        return false;
    }

    public boolean isWhitespaceOrCommentNode(INode node) {
        return this.isWhitespaceNode(node) || this.isCommentNode(node);
    }

    public String serializeNode(INode node) {
        if (node instanceof ILeafNode) {
            return ((ILeafNode)node).getText();
        }
        ArrayList leafNodes = Lists.newArrayList(node.getLeafNodes());
        int begin = 0;
        int end = leafNodes.size() - 1;
        while (begin <= end && this.isWhitespaceOrCommentNode((INode)leafNodes.get(begin))) {
            ++begin;
        }
        while (begin <= end && this.isWhitespaceOrCommentNode((INode)leafNodes.get(end))) {
            --end;
        }
        if (begin == end) {
            return this.isWhitespaceOrCommentNode((INode)leafNodes.get(begin)) ? "" : ((ILeafNode)leafNodes.get(begin)).getText();
        }
        StringBuilder b = new StringBuilder();
        int i = begin;
        while (i <= end) {
            b.append(((ILeafNode)leafNodes.get(i)).getText());
            ++i;
        }
        return b.toString();
    }
}

