/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.typesystem.override.AbstractResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedOperationInHierarchy;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

public abstract class AbstractResolvedOperation
extends AbstractResolvedExecutable<JvmOperation>
implements IResolvedOperation {
    private List<IResolvedOperation> validOverrides;
    private List<JvmOperation> overrideCandidates;
    private LightweightTypeReference returnType;

    protected AbstractResolvedOperation(JvmOperation declaration, LightweightTypeReference contextType) {
        super(declaration, contextType);
    }

    @Override
    public List<IResolvedOperation> getOverriddenAndImplementedMethods() {
        if (this.validOverrides != null) {
            return this.validOverrides;
        }
        List<JvmOperation> candidates = this.getOverriddenAndImplementedMethodCandidates();
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)candidates.size());
        for (JvmOperation candidate : candidates) {
            IOverrideCheckResult checkResult = this.getOverrideTester().isSubsignature(this, candidate, false);
            if (!checkResult.isOverridingOrImplementing()) continue;
            result.add(this.createResolvedOperationInHierarchy(candidate, checkResult));
        }
        this.validOverrides = Collections.unmodifiableList(result);
        return this.validOverrides;
    }

    @Override
    public IResolvedOperation getOverriddenMethod() {
        if (!((JvmOperation)this.getDeclaration()).isAbstract() && ((JvmOperation)this.getDeclaration()).getVisibility() != JvmVisibility.PRIVATE) {
            List<IResolvedOperation> overriddenAndImplemented = this.getOverriddenAndImplementedMethods();
            for (IResolvedOperation candidate : overriddenAndImplemented) {
                if (candidate.getDeclaration().isAbstract()) continue;
                return candidate;
            }
        }
        return null;
    }

    @Override
    public List<LightweightTypeReference> getIllegallyDeclaredExceptions() {
        if (((JvmOperation)this.getDeclaration()).getExceptions().isEmpty()) {
            return Collections.emptyList();
        }
        List<IResolvedOperation> overriddenAndImplemented = this.getOverriddenAndImplementedMethods();
        if (overriddenAndImplemented.isEmpty()) {
            return Collections.emptyList();
        }
        List<LightweightTypeReference> exceptions = this.getResolvedExceptions();
        ArrayList result = Lists.newArrayListWithCapacity((int)exceptions.size());
        for (LightweightTypeReference exception : exceptions) {
            if (exception.isSubtypeOf(RuntimeException.class) || exception.isSubtypeOf(Error.class) || !this.isIllegallyDeclaredException(exception, overriddenAndImplemented)) continue;
            result.add(exception);
        }
        return result;
    }

    protected boolean isIllegallyDeclaredException(LightweightTypeReference exception, List<IResolvedOperation> overriddenAndImplemented) {
        for (IResolvedOperation operation : overriddenAndImplemented) {
            if (!operation.getOverrideCheckResult().getDetails().contains((Object)IOverrideCheckResult.OverrideCheckDetails.EXCEPTION_MISMATCH)) continue;
            List<LightweightTypeReference> inheritedExceptions = operation.getResolvedExceptions();
            if (inheritedExceptions.isEmpty()) {
                return true;
            }
            boolean isDeclared = false;
            for (LightweightTypeReference inheritedException : inheritedExceptions) {
                if (!inheritedException.isAssignableFrom(exception)) continue;
                isDeclared = true;
                break;
            }
            if (isDeclared) continue;
            return true;
        }
        return false;
    }

    protected ResolvedOperationInHierarchy createResolvedOperationInHierarchy(JvmOperation candidate, IOverrideCheckResult checkResult) {
        ResolvedOperationInHierarchy result = new ResolvedOperationInHierarchy(candidate, this.getBottom());
        result.setCheckResult(checkResult);
        return result;
    }

    @Override
    public List<JvmOperation> getOverriddenAndImplementedMethodCandidates() {
        if (this.overrideCandidates != null) {
            return this.overrideCandidates;
        }
        ParameterizedTypeReference currentDeclarator = this.getContextType().getOwner().newParameterizedTypeReference((JvmType)((JvmOperation)this.getDeclaration()).getDeclaringType());
        List<LightweightTypeReference> superTypes = currentDeclarator.getSuperTypes();
        ArrayList result = Lists.newArrayListWithCapacity((int)5);
        for (LightweightTypeReference superType : superTypes) {
            JvmDeclaredType declaredSuperType = (JvmDeclaredType)superType.getType();
            if (declaredSuperType == null) continue;
            Iterable equallyNamedFeatures = declaredSuperType.findAllFeaturesByName(((JvmOperation)this.getDeclaration()).getSimpleName());
            for (JvmFeature equallyNamedFeature : equallyNamedFeatures) {
                if (!(equallyNamedFeature instanceof JvmOperation)) continue;
                result.add((JvmOperation)equallyNamedFeature);
            }
        }
        this.overrideCandidates = Collections.unmodifiableList(result);
        return this.overrideCandidates;
    }

    @Override
    public IOverrideCheckResult isOverridingOrImplementing(JvmOperation operation) {
        return this.getOverrideTester().isSubsignature(this, operation, true);
    }

    @Override
    public List<JvmTypeParameter> getResolvedTypeParameters() {
        return this.getBottom().getTypeParameters();
    }

    @Override
    public List<LightweightTypeReference> getResolvedTypeParameterConstraints(int idx) throws IndexOutOfBoundsException {
        JvmTypeParameter typeParameter = this.getResolvedTypeParameters().get(idx);
        EList constraints = typeParameter.getConstraints();
        ArrayList constraintReferences = Lists.newArrayListWithCapacity((int)constraints.size());
        for (JvmTypeConstraint constraint : constraints) {
            constraintReferences.add(constraint.getTypeReference());
        }
        List<LightweightTypeReference> result = this.getResolvedReferences(constraintReferences);
        return result;
    }

    @Override
    public LightweightTypeReference getResolvedReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        this.returnType = this.getResolvedReference(((JvmOperation)this.getDeclaration()).getReturnType());
        return this.returnType;
    }

    @Override
    protected boolean isRawTypeInheritance() {
        if (((JvmOperation)this.getDeclaration()).isStatic()) {
            return false;
        }
        return super.isRawTypeInheritance();
    }

    @Override
    protected boolean isResolvedTypeParameter(JvmTypeParameter typeParameter) {
        if (this.getResolvedTypeParameters().contains(typeParameter)) {
            return true;
        }
        return super.isResolvedTypeParameter(typeParameter);
    }

    protected abstract BottomResolvedOperation getBottom();

    protected OverrideTester getOverrideTester() {
        return this.getBottom().getOverrideTester();
    }
}

