/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.skin;

import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledLabel;
import org.eclipse.fx.ui.controls.styledtext.StyledString;

public class StyledLabelSkin
extends SkinBase<StyledLabel> {
    private final Pane b = new HBox(10.0);
    private final Label l = new Label();

    public StyledLabelSkin(StyledLabel control) {
        super((Control)control);
        this.l.getStyleClass().clear();
        Bindings.bindContent((List)this.l.getStyleClass(), (ObservableList)control.getStyleClass());
        this.b.getChildren().add((Object)this.l);
        control.styledStringProperty().addListener(this::styleStringChanged);
        control.graphicProperty().addListener(this::graphicChanged);
        if (control.getGraphic() != null) {
            this.l.setGraphic(control.getGraphic());
        }
        this.getChildren().add((Object)this.b);
        this.rebuildControl();
    }

    private void styleStringChanged(ObservableValue<? extends StyledString> observable, StyledString oldValue, StyledString newValue) {
        if (oldValue != null) {
            oldValue.getSegmentList().removeListener(this::segmentsChanged);
        }
        if (newValue != null) {
            newValue.getSegmentList().addListener(this::segmentsChanged);
        }
    }

    private void graphicChanged(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
        this.l.setGraphic(newValue);
    }

    private void segmentsChanged(Observable o) {
        this.rebuildControl();
    }

    private void rebuildControl() {
        if (this.b.getChildren().size() > 1) {
            this.b.getChildren().set(1, (Object)Util.toNode(((StyledLabel)this.getSkinnable()).getStyleString()));
        } else {
            this.b.getChildren().add((Object)Util.toNode(((StyledLabel)this.getSkinnable()).getStyleString()));
        }
    }

    public void dispose() {
        ((StyledLabel)this.getSkinnable()).getStyleString().getSegmentList().removeListener(this::segmentsChanged);
        ((StyledLabel)this.getSkinnable()).styledStringProperty().removeListener(this::styleStringChanged);
        Bindings.unbindContent((Object)this.l.getStyleClass(), (Object)((StyledLabel)this.getSkinnable()).getStyleClass());
        super.dispose();
    }
}

