/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.perspective;

import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.controls.dialog.TitleAreaDialog;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.perspective.PerspectiveListView;

public class LwPerspectiveSwitcherDialog
extends TitleAreaDialog {
    private final MWindow window;
    private final EModelService modelService;
    private final GraphicsLoader graphicsLoader;
    private MPerspective perspectiveToOpen;
    private final EPartService partService;

    @Inject
    public LwPerspectiveSwitcherDialog(MWindow window, EModelService modelService, GraphicsLoader graphicsLoader, EPartService partService) {
        super("Switch perspective", "Switch perspective", "Select a perspective you want to switch to");
        this.window = window;
        this.modelService = modelService;
        this.graphicsLoader = graphicsLoader;
        this.partService = partService;
        this.setClientArea((Node)this.createClient());
        this.addDefaultButtons();
        this.getStyleClass().add((Object)"efx-perspective-switch-dialog");
    }

    private BorderPane createClient() {
        BorderPane parent = new BorderPane();
        PerspectiveListView view = new PerspectiveListView(this.window, this.modelService, this.graphicsLoader);
        view.setOpenConsumer(o -> {
            this.perspectiveToOpen = o;
            this.handleOk();
        });
        view.setSelectionConsumer(o -> {
            this.perspectiveToOpen = o;
        });
        view.init(parent);
        return parent;
    }

    protected void handleOk() {
        if (this.perspectiveToOpen != null) {
            super.handleOk();
            this.partService.switchPerspective(this.perspectiveToOpen);
        }
    }
}

