/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Property;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check
extends SyntaxElement {
    private final Identifier type;
    private boolean errorSeverity = true;
    private final Expression msg;
    private final Expression constraint;
    private final Expression guard;
    private final Identifier feature;

    public Check(Identifier type, Identifier f, Expression guard, boolean errorSeverity, Expression msg, Expression constraint) {
        this.type = type;
        this.feature = f;
        this.guard = guard;
        this.errorSeverity = errorSeverity;
        this.msg = msg;
        this.constraint = constraint;
    }

    public final void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ExecutionContext _ctx = ctx;
        try {
            String featureName;
            Property property;
            if (_ctx.getCallback() != null && !_ctx.getCallback().pre(this, _ctx)) {
                return;
            }
            String typeName = this.type.toString();
            Type toCheck = _ctx.getTypeForName(typeName);
            if (toCheck == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + typeName, this));
                return;
            }
            if (this.feature != null && (property = toCheck.getProperty(featureName = this.feature.toString())) == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "Couldn't find property '" + featureName + "' for type '" + typeName + "'", this));
                return;
            }
            _ctx = _ctx.cloneWithVariable(new Variable("this", toCheck));
            if (this.guard != null) {
                Type guardType = null;
                try {
                    guardType = this.guard.analyze(_ctx, issues);
                }
                catch (RuntimeException ex) {
                    _ctx.handleRuntimeException(ex, this, null);
                }
                if (guardType == null) {
                    return;
                }
                if (!guardType.equals(_ctx.getBooleanType())) {
                    issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Boolean expected! (is " + guardType.getName() + ")", this.guard));
                }
            }
            Type constraintType = null;
            try {
                constraintType = this.constraint.analyze(_ctx, issues);
            }
            catch (RuntimeException ex) {
                _ctx.handleRuntimeException(ex, this, null);
            }
            if (constraintType == null) {
                return;
            }
            if (!constraintType.equals(_ctx.getBooleanType())) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Boolean expected! (is " + constraintType.getName() + ")", this.constraint));
            }
            try {
                this.msg.analyze(_ctx, issues);
            }
            catch (RuntimeException ex) {
                _ctx.handleRuntimeException(ex, this, null);
            }
        }
        finally {
            if (_ctx.getCallback() != null) {
                _ctx.getCallback().post(this, _ctx, null);
            }
        }
    }

    public void validate(ExecutionContext ctx, Collection<?> colToCheck, Issues issues, boolean warnIfNothingChecked) {
        ExecutionContext _ctx = ctx;
        try {
            if (_ctx.getCallback() != null && !_ctx.getCallback().pre(this, _ctx)) {
                return;
            }
            String typeName = this.type.toString();
            Type typeToCheck = _ctx.getTypeForName(typeName);
            if (typeToCheck == null) {
                throw new EvaluationException("Type not found : " + typeName, (SyntaxElement)this, _ctx);
            }
            boolean someObjectFound = false;
            for (Object o : colToCheck) {
                if (!typeToCheck.isInstance(o)) continue;
                someObjectFound = true;
                try {
                    _ctx = _ctx.cloneWithVariable(new Variable("this", o));
                    if (!this.process(_ctx)) continue;
                    Object result = null;
                    try {
                        result = this.constraint.evaluate(_ctx);
                    }
                    catch (RuntimeException e) {
                        this.addIssueForException(issues, e, o);
                    }
                    if (result != null && !(result instanceof Boolean)) {
                        throw new EvaluationException("Boolean expected! ( was " + result.getClass().getName() + ")", (SyntaxElement)this, _ctx);
                    }
                    Boolean r = (Boolean)result;
                    if (!Boolean.FALSE.equals(r)) continue;
                    Object msgResult = null;
                    try {
                        msgResult = this.msg.evaluate(_ctx);
                    }
                    catch (RuntimeException e) {
                        this.addIssueForException(issues, e, o);
                    }
                    String stringResult = "Message evaluation returned null";
                    if (msgResult != null) {
                        stringResult = msgResult.toString();
                    }
                    String propertyName = null;
                    if (this.feature != null) {
                        String featureValue = this.feature.toString();
                        Property property = typeToCheck.getProperty(featureValue);
                        if (property == null) {
                            throw new EvaluationException("Property " + featureValue + " for Type " + typeToCheck + " not found!", (SyntaxElement)this, _ctx);
                        }
                        propertyName = property.getName();
                    }
                    if (this.errorSeverity) {
                        issues.addError(null, stringResult, o, propertyName, null, Collections.emptyList());
                        continue;
                    }
                    issues.addWarning(null, stringResult, o, propertyName, null, Collections.emptyList());
                }
                catch (NullPointerException npe) {
                    Object msgResult = this.msg.evaluate(_ctx);
                    String stringResult = "Message evaluation returned null";
                    if (msgResult != null) {
                        stringResult = msgResult.toString();
                    }
                    if (this.errorSeverity) {
                        issues.addError(String.valueOf(stringResult) + " (NPE in constraint evaluation)", o);
                        continue;
                    }
                    issues.addWarning(String.valueOf(stringResult) + " (NPE in constraint evaluation)", o);
                }
            }
            if (warnIfNothingChecked && !someObjectFound) {
                issues.addWarning("The constraint did not match any model elements. Context: " + this.type.toString() + ", message: " + this.msg);
            }
        }
        finally {
            if (_ctx.getCallback() != null) {
                _ctx.getCallback().post(this, _ctx, null);
            }
        }
    }

    protected void addIssueForException(Issues issues, Exception exception, Object element) {
        issues.addError(null, exception.getMessage(), element, (Throwable)exception, Collections.emptyList());
    }

    private boolean process(ExecutionContext ctx) {
        if (this.guard != null) {
            Object result = this.guard.evaluate(ctx);
            return result instanceof Boolean && (Boolean)result != false;
        }
        return true;
    }

    public String toString() {
        return this.type + " " + this.msg;
    }

    public boolean isErrorCheck() {
        return this.errorSeverity;
    }

    public Expression getConstraint() {
        return this.constraint;
    }

    public Expression getGuard() {
        return this.guard;
    }

    public Expression getMsg() {
        return this.msg;
    }

    public Identifier getType() {
        return this.type;
    }
}

