/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.dialogs;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class TaskProgressDialog<R>
extends Dialog<R> {
    private ObjectProperty<CancelledHandler<R>> cancelledHandler = new SimpleObjectProperty();
    private ObjectProperty<FailedHandler<R>> failedHandler = new SimpleObjectProperty();
    private BooleanProperty cancelable = new SimpleBooleanProperty();

    public TaskProgressDialog(Stage owner, Task<R> task) {
        this.initOwner((Window)owner);
        this.titleProperty().bind((ObservableValue)task.titleProperty());
        this.initTaskHandlers(task);
        this.getDialogPane().setContent(this.createContent(task));
        this.setOnShown(event -> this.startTask(task));
    }

    public Stage getStage() {
        return (Stage)this.getDialogPane().getScene().getWindow();
    }

    private void initTaskHandlers(Task<R> task) {
        task.setOnSucceeded(event -> {
            Object value = task.getValue();
            this.setResult(value);
            if (value == null) {
                this.getStage().close();
            }
        });
        task.setOnCancelled(event -> {
            if (this.cancelledHandler.get() == null) {
                this.setResult(null);
            } else {
                this.setResult(((CancelledHandler)this.cancelledHandler.get()).cancelled());
            }
            this.getStage().close();
        });
        task.setOnFailed(event -> {
            if (this.failedHandler.get() == null) {
                this.setResult(null);
            } else {
                this.setResult(((FailedHandler)this.failedHandler.get()).failedWithException(task.getException()));
            }
            this.getStage().close();
        });
    }

    private Node createContent(Task<R> task) {
        VBox progressPane = new VBox(6.0);
        progressPane.setMaxWidth(Double.MAX_VALUE);
        progressPane.setAlignment(Pos.CENTER_LEFT);
        Label messageLabel = new Label(task.getMessage());
        messageLabel.setPadding(new Insets(14.0, 0.0, 0.0, 0.0));
        messageLabel.setMaxWidth(Double.MAX_VALUE);
        messageLabel.setPrefSize(420.0, 56.0);
        messageLabel.setWrapText(true);
        messageLabel.setAlignment(Pos.TOP_LEFT);
        progressPane.getChildren().add((Object)messageLabel);
        HBox hbox = new HBox(3.0);
        hbox.setAlignment(Pos.CENTER_LEFT);
        progressPane.getChildren().add((Object)hbox);
        ProgressBar progressBar = new ProgressBar();
        progressBar.setMaxWidth(Double.MAX_VALUE);
        progressBar.setMaxHeight(Double.MAX_VALUE);
        hbox.getChildren().add((Object)progressBar);
        HBox.setHgrow((Node)progressBar, (Priority)Priority.ALWAYS);
        Button cancelButton = new Button();
        cancelButton.setGraphic((Node)new ImageView(new Image(TaskProgressDialog.class.getResourceAsStream("cancel.png"))));
        cancelButton.setCancelButton(true);
        cancelButton.setOnAction(event -> task.cancel());
        if (this.cancelable.get()) {
            hbox.getChildren().add((Object)cancelButton);
        }
        this.cancelable.addListener((o, oV, nV) -> {
            if (nV.booleanValue()) {
                hbox.getChildren().add((Object)cancelButton);
            } else if (hbox.getChildren().contains((Object)cancelButton)) {
                hbox.getChildren().remove((Object)cancelButton);
            }
        });
        messageLabel.textProperty().bind((ObservableValue)task.messageProperty());
        progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        return progressPane;
    }

    private void startTask(Task<R> task) {
        Thread th = new Thread((Runnable)task);
        th.setName(task.getTitle());
        th.setDaemon(true);
        th.start();
    }

    public final BooleanProperty cancelableProperty() {
        return this.cancelable;
    }

    public final boolean isCancelable() {
        return this.cancelableProperty().get();
    }

    public final void setCancelable(boolean cancelable) {
        this.cancelableProperty().set(cancelable);
    }

    public final ObjectProperty<CancelledHandler<R>> cancelledHandlerProperty() {
        return this.cancelledHandler;
    }

    public final CancelledHandler<R> getCancelledHandler() {
        return (CancelledHandler)this.cancelledHandlerProperty().get();
    }

    public final void setCancelledHandler(CancelledHandler<R> cancelledHandler) {
        this.cancelledHandlerProperty().set(cancelledHandler);
    }

    public final ObjectProperty<FailedHandler<R>> failedHandlerProperty() {
        return this.failedHandler;
    }

    public final FailedHandler<R> getFailedHandler() {
        return (FailedHandler)this.failedHandlerProperty().get();
    }

    public final void setFailedHandler(FailedHandler<R> failedHandler) {
        this.failedHandlerProperty().set(failedHandler);
    }

    @FunctionalInterface
    public static interface CancelledHandler<T> {
        public T cancelled();
    }

    @FunctionalInterface
    public static interface FailedHandler<T> {
        public T failedWithException(Throwable var1);
    }
}

