/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.bindings.FXBindings;

public abstract class BaseBidiPropertyBinding
extends ObjectBinding<Status>
implements FXBindings.StatusBinding {
    private Observable source;
    private Observable target;
    private Status curStatus;
    private boolean inUpdate = false;
    private InvalidationListener onInvalidate = this::onInvalidate;

    public BaseBidiPropertyBinding(Observable target, Observable source) {
        this.source = source;
        this.target = target;
        target.addListener(this.onInvalidate);
        source.addListener(this.onInvalidate);
        this._doSourceToTarget();
    }

    private void onInvalidate(Observable o) {
        if (o == this.source) {
            this._doSourceToTarget();
        } else if (o == this.target) {
            this.doTargetToSource();
        }
    }

    protected abstract void syncTarget();

    private void _doSourceToTarget() {
        if (this.inUpdate) {
            return;
        }
        this.inUpdate = true;
        try {
            try {
                this.syncTarget();
                this.setStatus(Status.ok());
            }
            catch (Throwable t) {
                this.setStatus(Status.status(Status.State.ERROR, 0, "sourceToTarget failure", t));
                this.inUpdate = false;
            }
        }
        finally {
            this.inUpdate = false;
        }
    }

    protected abstract void syncSource();

    private void doTargetToSource() {
        if (this.inUpdate) {
            return;
        }
        this.inUpdate = true;
        try {
            try {
                this.syncSource();
                this.setStatus(Status.ok());
            }
            catch (Throwable t) {
                this.setStatus(Status.status(Status.State.ERROR, 0, "targetToSource failure", t));
                this.inUpdate = false;
            }
        }
        finally {
            this.inUpdate = false;
        }
    }

    public void dispose() {
        this.source.removeListener(this.onInvalidate);
        this.target.removeListener(this.onInvalidate);
        super.dispose();
    }

    private void setStatus(Status s) {
        this.curStatus = s;
        this.invalidate();
    }

    protected Status computeValue() {
        return this.curStatus;
    }
}

