/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.NullEvaluationContext;

public class DefaultEvaluationContext
implements IEvaluationContext {
    private IEvaluationContext parent;
    private Map<QualifiedName, Object> values;

    public DefaultEvaluationContext() {
        this(new NullEvaluationContext());
    }

    public DefaultEvaluationContext(IEvaluationContext parent) {
        this.parent = parent;
    }

    @Override
    public Object getValue(QualifiedName qualifiedName) {
        if (this.values != null && this.values.containsKey(qualifiedName)) {
            return this.values.get(qualifiedName);
        }
        return this.parent.getValue(qualifiedName);
    }

    @Override
    public void newValue(QualifiedName qualifiedName, Object value) {
        if (this.values == null) {
            this.values = Maps.newHashMap();
        }
        if (this.values.containsKey(qualifiedName)) {
            throw new IllegalStateException("Cannot create a duplicate value '" + qualifiedName + "'.");
        }
        this.values.put(qualifiedName, value);
    }

    @Override
    public void assignValue(QualifiedName qualifiedName, Object value) {
        if (this.values == null || !this.values.containsKey(qualifiedName)) {
            this.parent.assignValue(qualifiedName, value);
        } else {
            this.values.put(qualifiedName, value);
        }
    }

    @Override
    public IEvaluationContext fork() {
        return new DefaultEvaluationContext(this);
    }
}

