/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.stage;

import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.StyleableDoubleProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.stage.Frame;
import org.eclipse.fx.ui.controls.stage.FrameEvent;

public abstract class ResizeableFramePane
extends StackPane
implements Frame {
    private static final CssMetaData<ResizeableFramePane, Number> RESIZE_HANDLE_SIZE = new CssMetaData<ResizeableFramePane, Number>("-efx-resize-handle-size", StyleConverter.getSizeConverter(), (Number)5.0){

        public boolean isSettable(ResizeableFramePane n) {
            return n.resizeHandleSize == null || !n.resizeHandleSize.isBound();
        }

        public StyleableDoubleProperty getStyleableProperty(ResizeableFramePane n) {
            return (StyleableDoubleProperty)n.resizeHandleSize;
        }
    };
    private Rectangle2D backupWindowBounds;
    private double mouseDragDeltaX;
    private double mouseDragDeltaY;
    private Node resizeLeft;
    private Node resizeRight;
    private Node resizeBottom;
    private Node resizeTop;
    private Node resizeCornerRightBottom;
    private Node resizeCornerRightTop;
    private Node resizeCornerLeftBottom;
    private Node resizeCornerLeftTop;
    private BooleanProperty minimizable = new SimpleBooleanProperty((Object)this, "minimizable", true);
    private BooleanProperty maximizable = new SimpleBooleanProperty((Object)this, "maximizable", true);
    private BooleanProperty resizeable = new SimpleBooleanProperty((Object)this, "resizeable", true);
    private ReadOnlyBooleanWrapper lightweight = new ReadOnlyBooleanWrapper((Object)this, "lightweight", false);
    private ReadOnlyBooleanWrapper maximized = new ReadOnlyBooleanWrapper((Object)this, "maximized", false);
    DoubleProperty resizeHandleSize = new SimpleStyleableDoubleProperty(RESIZE_HANDLE_SIZE, (Object)this, "resizeHandleSize", Double.valueOf(5.0));
    private ObservableValue<Window> windowProperty;

    public ResizeableFramePane() {
        this(false);
    }

    public ResizeableFramePane(boolean lighweight) {
        this.lightweight.set(lighweight);
        Node windowNode = this.createWindowArea();
        this.getChildren().add((Object)windowNode);
        this.initResize();
        if (!lighweight) {
            this.windowProperty = Util.windowProperty((Node)this);
            this.windowProperty.addListener((o, oldV, newV) -> {
                if (oldV != null) {
                    oldV.widthProperty().removeListener(this::handleStageChange);
                    oldV.heightProperty().removeListener(this::handleStageChange);
                    oldV.xProperty().removeListener(this::handleStageChange);
                    oldV.yProperty().removeListener(this::handleStageChange);
                }
                if (newV != null) {
                    newV.widthProperty().addListener(this::handleStageChange);
                    newV.heightProperty().addListener(this::handleStageChange);
                    newV.xProperty().addListener(this::handleStageChange);
                    newV.yProperty().addListener(this::handleStageChange);
                }
            });
        }
    }

    private void handleStageChange(Observable o, Number oldVal, Number newVal) {
        this.getStyleClass().remove((Object)"window-maximized");
        this.maximized.set(false);
    }

    private void initResize() {
        this.initResizeLeft();
        this.initResizeRight();
        this.initResizeTop();
        this.initResizeBottom();
        this.initResizeCornerRightBottom();
        this.initResizeCornerRightTop();
        this.initResizeCornerLeftBottom();
        this.initResizeCornerLeftTop();
    }

    private void initResizeBottom() {
        this.resizeBottom = ResizeableFramePane.createBottomResize();
        this.resizeBottom.setManaged(false);
        this.getChildren().add((Object)this.resizeBottom);
        ResizeHandler resizeHandler = new ResizeHandler(Location.BOTTOM);
        this.resizeBottom.setOnMousePressed((EventHandler)resizeHandler);
        this.resizeBottom.setOnMouseDragged((EventHandler)resizeHandler);
        this.resizeBottom.setOnMouseReleased((EventHandler)resizeHandler);
    }

    private void initResizeTop() {
        this.resizeTop = ResizeableFramePane.createTopResize();
        this.resizeTop.setManaged(false);
        this.getChildren().add((Object)this.resizeTop);
        ResizeHandler h = new ResizeHandler(Location.TOP);
        this.resizeTop.setOnMousePressed((EventHandler)h);
        this.resizeTop.setOnMouseDragged((EventHandler)h);
        this.resizeTop.setOnMouseReleased((EventHandler)h);
    }

    private void initResizeLeft() {
        this.resizeLeft = ResizeableFramePane.createLeftResize();
        this.resizeLeft.setManaged(false);
        this.getChildren().add((Object)this.resizeLeft);
        ResizeHandler h = new ResizeHandler(Location.LEFT);
        this.resizeLeft.setOnMousePressed((EventHandler)h);
        this.resizeLeft.setOnMouseDragged((EventHandler)h);
        this.resizeLeft.setOnMouseReleased((EventHandler)h);
    }

    private void initResizeRight() {
        this.resizeRight = ResizeableFramePane.createRightResize();
        this.resizeRight.setManaged(false);
        this.getChildren().add((Object)this.resizeRight);
        ResizeHandler h = new ResizeHandler(Location.RIGHT);
        this.resizeRight.setOnMousePressed((EventHandler)h);
        this.resizeRight.setOnMouseDragged((EventHandler)h);
        this.resizeRight.setOnMouseReleased((EventHandler)h);
    }

    private void initResizeCornerRightBottom() {
        this.resizeCornerRightBottom = ResizeableFramePane.createResizeCornerRightBottom();
        this.resizeCornerRightBottom.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerRightBottom);
        ResizeHandler h = new ResizeHandler(Location.BOTTOM, Location.RIGHT);
        this.resizeCornerRightBottom.setOnMousePressed((EventHandler)h);
        this.resizeCornerRightBottom.setOnMouseDragged((EventHandler)h);
        this.resizeCornerRightBottom.setOnMouseReleased((EventHandler)h);
    }

    private void initResizeCornerRightTop() {
        this.resizeCornerRightTop = ResizeableFramePane.createResizeCornerRightTop();
        this.resizeCornerRightTop.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerRightTop);
        ResizeHandler h = new ResizeHandler(Location.TOP, Location.RIGHT);
        this.resizeCornerRightTop.setOnMousePressed((EventHandler)h);
        this.resizeCornerRightTop.setOnMouseDragged((EventHandler)h);
        this.resizeCornerRightTop.setOnMouseReleased((EventHandler)h);
    }

    private void initResizeCornerLeftBottom() {
        this.resizeCornerLeftBottom = ResizeableFramePane.createResizeCornerLeftBottom();
        this.resizeCornerLeftBottom.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerLeftBottom);
        ResizeHandler h = new ResizeHandler(Location.BOTTOM, Location.LEFT);
        this.resizeCornerLeftBottom.setOnMousePressed((EventHandler)h);
        this.resizeCornerLeftBottom.setOnMouseDragged((EventHandler)h);
        this.resizeCornerLeftBottom.setOnMouseReleased((EventHandler)h);
    }

    private void initResizeCornerLeftTop() {
        this.resizeCornerLeftTop = ResizeableFramePane.createResizeCornerLeftTop();
        this.resizeCornerLeftTop.setManaged(false);
        this.getChildren().add((Object)this.resizeCornerLeftTop);
        ResizeHandler h = new ResizeHandler(Location.TOP, Location.LEFT);
        this.resizeCornerLeftTop.setOnMousePressed((EventHandler)h);
        this.resizeCornerLeftTop.setOnMouseDragged((EventHandler)h);
        this.resizeCornerLeftTop.setOnMouseReleased((EventHandler)h);
    }

    protected void registerTitleBar(Node node) {
        node.setOnMousePressed(event -> {
            this.mouseDragDeltaX = event.getSceneX();
            this.mouseDragDeltaY = event.getSceneY();
        });
        node.setOnMouseDragged(event -> {
            this.getStage().setX(event.getScreenX() - this.mouseDragDeltaX);
            this.getStage().setY(event.getScreenY() - this.mouseDragDeltaY);
        });
        node.setOnMouseClicked(e -> {
            if (e.getClickCount() > 1) {
                if (this.maximized.get()) {
                    this.restore();
                } else {
                    this.maximize();
                }
            }
        });
    }

    protected abstract Node createWindowArea();

    protected Stage getStage() {
        return (Stage)this.getScene().getWindow();
    }

    private static Node createResizeCornerRightBottom() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-right-bottom");
        return resizeCorner;
    }

    private static Node createResizeCornerRightTop() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-right-top");
        return resizeCorner;
    }

    private static Node createResizeCornerLeftBottom() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-left-bottom");
        return resizeCorner;
    }

    private static Node createResizeCornerLeftTop() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-corner-left-top");
        return resizeCorner;
    }

    private static Node createLeftResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-left");
        return resizeCorner;
    }

    private static Node createRightResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-right");
        return resizeCorner;
    }

    private static Node createTopResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-top");
        return resizeCorner;
    }

    private static Node createBottomResize() {
        Pane resizeCorner = new Pane();
        resizeCorner.getStyleClass().add((Object)"window-resize-bottom");
        return resizeCorner;
    }

    public final void setContent(Node content) {
        this.contentProperty().set((Object)content);
    }

    public final Node getContent() {
        return (Node)this.contentProperty().get();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.impl_contentProperty();
    }

    protected abstract ObjectProperty<Node> impl_contentProperty();

    @Override
    public final void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final StringProperty titleProperty() {
        return this.impl_titleProperty();
    }

    protected abstract StringProperty impl_titleProperty();

    @Override
    public final void setClientArea(Node node) {
        this.clientAreaProperty().set((Object)node);
    }

    public final Node getClientArea() {
        return (Node)this.clientAreaProperty().get();
    }

    public final ObjectProperty<Node> clientAreaProperty() {
        return this.impl_clientAreaProperty();
    }

    protected abstract ObjectProperty<Node> impl_clientAreaProperty();

    protected void maximize() {
        if (!this.isLightweight()) {
            Stage stage = this.getStage();
            double stageY = stage.getY();
            Screen screen = (Screen)Screen.getScreensForRectangle((double)stage.getX(), (double)stageY, (double)1.0, (double)1.0).get(0);
            this.backupWindowBounds = new Rectangle2D(stage.getX(), stage.getY(), stage.getWidth(), stage.getHeight());
            double newStageY = screen.getVisualBounds().getMinY();
            stage.setX(screen.getVisualBounds().getMinX());
            stage.setY(newStageY);
            stage.setWidth(screen.getVisualBounds().getWidth());
            stage.setHeight(screen.getVisualBounds().getHeight());
            this.getStyleClass().add((Object)"window-maximized");
            this.maximized.set(true);
        }
    }

    protected void restore() {
        if (!this.isLightweight() && this.backupWindowBounds != null) {
            Stage stage = this.getStage();
            stage.setX(this.backupWindowBounds.getMinX());
            stage.setY(this.backupWindowBounds.getMinY());
            stage.setWidth(this.backupWindowBounds.getWidth());
            stage.setHeight(this.backupWindowBounds.getHeight());
            stage.setMaximized(false);
            this.backupWindowBounds = null;
        }
    }

    protected ReadOnlyBooleanProperty maximizedProperty() {
        return this.maximized.getReadOnlyProperty();
    }

    @Override
    public void close() {
        this.close(false);
    }

    protected void close(boolean uiInteraction) {
        if (this.isLightweight()) {
            if (uiInteraction) {
                FrameEvent evt = new FrameEvent(this, FrameEvent.CLOSING);
                Event.fireEvent((EventTarget)this, (Event)evt);
                if (!evt.isConsumed()) {
                    Event.fireEvent((EventTarget)this, (Event)new FrameEvent(this, FrameEvent.CLOSED));
                }
            } else {
                Event.fireEvent((EventTarget)this, (Event)new FrameEvent(this, FrameEvent.CLOSED));
            }
        } else if (uiInteraction) {
            WindowEvent event = new WindowEvent((Window)this.getStage(), WindowEvent.WINDOW_CLOSE_REQUEST);
            Event.fireEvent((EventTarget)this.getStage(), (Event)event);
            if (!event.isConsumed()) {
                this.getStage().close();
            }
        } else {
            this.getStage().close();
        }
    }

    protected void minimize() {
        if (!this.isLightweight()) {
            this.getStage().setIconified(true);
        }
    }

    @Override
    public final void setMaximizable(boolean maximizeable) {
        this.maximizable.set(maximizeable);
    }

    public final BooleanProperty maximizableProperty() {
        return this.maximizable;
    }

    public final boolean isMaximizable() {
        return this.maximizable.get();
    }

    @Override
    public final void setMinimizable(boolean minimizable) {
        this.minimizable.set(minimizable);
    }

    public final BooleanProperty minimizableProperty() {
        return this.minimizable;
    }

    public final boolean isMinimizable() {
        return this.minimizable.get();
    }

    @Override
    public final void setResizeable(boolean resizable) {
        this.resizeable.set(resizable);
    }

    public double getResizeHandleSize() {
        return this.resizeHandleSize.get();
    }

    public void setResizeHandleSize(double size) {
        this.resizeHandleSize.set(size);
    }

    public DoubleProperty resizeHandleSize() {
        return this.resizeHandleSize;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (this.resizeLeft != null) {
            this.resizeLeft.resizeRelocate(0.0, this.getResizeHandleSize(), this.getResizeHandleSize(), this.getHeight() - 2.0 * this.getResizeHandleSize());
            this.resizeLeft.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeRight != null) {
            this.resizeRight.resizeRelocate(this.getWidth() - this.getResizeHandleSize(), this.getResizeHandleSize(), this.getResizeHandleSize(), this.getHeight() - 2.0 * this.getResizeHandleSize());
            this.resizeRight.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeTop != null) {
            this.resizeTop.resizeRelocate(this.getResizeHandleSize(), 0.0, this.getWidth() - this.getResizeHandleSize(), this.getResizeHandleSize());
            this.resizeTop.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeBottom != null) {
            this.resizeBottom.resizeRelocate(this.getResizeHandleSize(), this.getHeight() - this.getResizeHandleSize(), this.getWidth() - this.getResizeHandleSize(), this.getResizeHandleSize());
            this.resizeBottom.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerRightBottom != null) {
            this.resizeCornerRightBottom.resizeRelocate(this.getWidth() - this.getResizeHandleSize(), this.getHeight() - this.getResizeHandleSize(), this.getResizeHandleSize(), this.getResizeHandleSize());
            this.resizeCornerRightBottom.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerRightTop != null) {
            this.resizeCornerRightTop.resizeRelocate(this.getWidth() - this.getResizeHandleSize(), 0.0, this.getResizeHandleSize(), this.getResizeHandleSize());
            this.resizeCornerRightTop.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerLeftBottom != null) {
            this.resizeCornerLeftBottom.resizeRelocate(0.0, this.getHeight() - this.getResizeHandleSize(), this.getResizeHandleSize(), this.getResizeHandleSize());
            this.resizeCornerLeftBottom.visibleProperty().bind((ObservableValue)this.resizeable);
        }
        if (this.resizeCornerLeftTop != null) {
            this.resizeCornerLeftTop.resizeRelocate(0.0, 0.0, this.getResizeHandleSize(), this.getResizeHandleSize());
            this.resizeCornerLeftTop.visibleProperty().bind((ObservableValue)this.resizeable);
        }
    }

    public final ReadOnlyBooleanProperty lightweightProperty() {
        return this.lightweight.getReadOnlyProperty();
    }

    public final boolean isLightweight() {
        return this.lightweightProperty().get();
    }

    static enum Location {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;

    }

    class ResizeHandler
    implements EventHandler<MouseEvent> {
        private double width;
        private double height;
        private double x;
        private double y;
        private Point2D dragAnchor;
        private Location[] locations;

        public ResizeHandler(Location ... locations) {
            this.locations = locations;
        }

        public void handle(MouseEvent event) {
            EventType type = event.getEventType();
            if (type == MouseEvent.MOUSE_RELEASED) {
                this.dragAnchor = null;
            } else if (type == MouseEvent.MOUSE_PRESSED) {
                this.x = ResizeableFramePane.this.getStage().getX();
                this.y = ResizeableFramePane.this.getStage().getY();
                this.width = ResizeableFramePane.this.getStage().getWidth();
                this.height = ResizeableFramePane.this.getStage().getHeight();
                this.dragAnchor = new Point2D(event.getScreenX(), event.getScreenY());
            } else if (type == MouseEvent.MOUSE_DRAGGED && this.dragAnchor != null && !ResizeableFramePane.this.isLightweight()) {
                double deltaX = event.getScreenX() - this.dragAnchor.getX();
                double deltaY = event.getScreenY() - this.dragAnchor.getY();
                Location[] locationArray = this.locations;
                int n = this.locations.length;
                int n2 = 0;
                while (n2 < n) {
                    Location l = locationArray[n2];
                    switch (l) {
                        case TOP: {
                            ResizeableFramePane.this.getStage().setY(this.y + (double)((int)deltaY));
                            ResizeableFramePane.this.getStage().setHeight(this.height + (double)(-1 * (int)deltaY));
                            break;
                        }
                        case BOTTOM: {
                            ResizeableFramePane.this.getStage().setHeight(this.height + deltaY);
                            break;
                        }
                        case LEFT: {
                            ResizeableFramePane.this.getStage().setX(this.x + (double)((int)deltaX));
                            ResizeableFramePane.this.getStage().setWidth(this.width + (double)(-1 * (int)deltaX));
                            break;
                        }
                        case RIGHT: {
                            ResizeableFramePane.this.getStage().setWidth(this.width + deltaX);
                            break;
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

