/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.css.cssext.parser;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ide.css.cssDsl.ColorTok;
import org.eclipse.fx.ide.css.cssDsl.CssTok;
import org.eclipse.fx.ide.css.cssDsl.FuncTok;
import org.eclipse.fx.ide.css.cssDsl.IdentifierTok;
import org.eclipse.fx.ide.css.cssDsl.NumberTok;
import org.eclipse.fx.ide.css.cssDsl.SymbolTok;
import org.eclipse.fx.ide.css.cssDsl.UrlTok;
import org.eclipse.fx.ide.css.cssDsl.WSTok;
import org.eclipse.fx.ide.css.cssext.ICssExtManager;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRangedDoubleType;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRangedIntType;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRule;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleBracket;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleConcat;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleConcatWithoutSpace;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleFunc;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleLiteral;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleOr;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRulePostfix;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleRef;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleRegex;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleSymbol;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSRuleXor;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.CSSType;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.Definition;
import org.eclipse.fx.ide.css.cssext.cssExtDsl.PropertyDefinition;
import org.eclipse.fx.ide.css.cssext.parser.ParserInput;
import org.eclipse.fx.ide.css.cssext.parser.ParserInputCursor;
import org.eclipse.fx.ide.css.cssext.parser.result.NodeType;
import org.eclipse.fx.ide.css.cssext.parser.result.ResultNode;
import org.eclipse.fx.ide.css.cssext.parser.result.State;
import org.eclipse.fx.ide.css.extapi.MultiProposal;
import org.eclipse.fx.ide.css.extapi.Proposal;
import org.eclipse.fx.ide.css.extapi.SimpleProposal;
import org.eclipse.fx.ide.css.extapi.ValidationResult;
import org.eclipse.fx.ide.css.util.TokUtil;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class CssExtParser {
    @Inject
    private ICssExtManager manager;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Log(value="cssext.parser")
    private Logger logger;
    private Set<ParseResultListener> resultListener = new HashSet<ParseResultListener>();

    private ResultNode parse(IFile f, EObject context, ParserInputCursor input, CSSRule rule, ConsumeWS consumeWS) {
        Assert.isNotNull((Object)rule, (String)"rule must not be null");
        Assert.isNotNull((Object)input, (String)"input must not be null");
        ResultNode result = null;
        switch (rule.eClass().getClassifierID()) {
            case 24: {
                result = this.parseBracket(f, context, input, (CSSRuleBracket)rule, consumeWS);
                break;
            }
            case 9: {
                result = this.parseRef(f, context, input, (CSSRuleRef)rule, consumeWS);
                break;
            }
            case 19: {
                result = this.parseOr(f, context, input, (CSSRuleOr)rule, consumeWS);
                break;
            }
            case 20: {
                result = this.parseConcatOr(f, context, input, (CSSRuleXor)rule, consumeWS);
                break;
            }
            case 21: {
                result = this.parseConcat(f, context, input, (CSSRuleConcat)rule, consumeWS);
                break;
            }
            case 22: {
                result = this.parseConcatWithoutSpace(f, context, input, (CSSRuleConcatWithoutSpace)rule, consumeWS);
                break;
            }
            case 27: {
                result = this.parseLiteral(input, (CSSRuleLiteral)rule, consumeWS);
                break;
            }
            case 28: {
                result = this.parseSymbol(input, (CSSRuleSymbol)rule, consumeWS);
                break;
            }
            case 23: {
                result = this.parsePostfix(f, context, input, (CSSRulePostfix)rule, consumeWS);
                break;
            }
            case 26: {
                result = this.parseRegex(input, (CSSRuleRegex)rule, consumeWS);
                break;
            }
            case 5: 
            case 14: 
            case 15: {
                result = this.parseType(input, (CSSType)rule, consumeWS);
                break;
            }
            case 18: {
                result = this.parseFunction(input, (CSSRuleFunc)rule, consumeWS);
                break;
            }
            default: {
                this.logger.warning(rule + " not implemented! (classifierID=" + rule.eClass().getClassifierID() + ")");
            }
        }
        return result;
    }

    private ResultNode parseOr(IFile f, EObject context, ParserInputCursor input, CSSRuleOr or, ConsumeWS consumeWS) {
        ResultNode orResult = new ResultNode(NodeType.OR);
        orResult.remainingInput = input.copy();
        orResult.status = State.FORWARD;
        for (CSSRule rule : or.getOrs()) {
            ResultNode result = this.parse(f, context, input.copy(), rule, consumeWS);
            orResult.next.add(result);
        }
        return orResult;
    }

    private ResultNode parseConcat(IFile f, EObject context, ParserInputCursor l, CSSRuleConcat r, ConsumeWS consumeWS) {
        ResultNode concatResult = new ResultNode(NodeType.CONCAT);
        concatResult.remainingInput = l.copy();
        concatResult.status = State.FORWARD;
        for (CSSRule rule : r.getConc()) {
            boolean isFirstRule = r.getConc().indexOf((Object)rule) == 0;
            for (ResultNode last : concatResult.findLast()) {
                if (!last.isValid()) continue;
                last.next.add(this.parse(f, context, last.remainingInput, rule, isFirstRule ? consumeWS : ConsumeWS.MUST_CONSUME));
            }
        }
        return concatResult;
    }

    private ResultNode parseConcatWithoutSpace(IFile f, EObject context, ParserInputCursor l, CSSRuleConcatWithoutSpace r, ConsumeWS consumeWS) {
        ResultNode concatResult = new ResultNode(NodeType.CONCAT_WITHOUT_SPACE);
        concatResult.remainingInput = l.copy();
        concatResult.status = State.FORWARD;
        for (CSSRule rule : r.getConc()) {
            boolean isFirstRule = r.getConc().indexOf((Object)rule) == 0;
            for (ResultNode last : concatResult.findLast()) {
                if (last.isValid()) {
                    last.next.add(this.parse(f, context, last.remainingInput, rule, isFirstRule ? consumeWS : ConsumeWS.NO_CONSUME));
                    continue;
                }
                if (isFirstRule || last.status != State.PROPOSE) continue;
                ResultNode node = this.parse(f, context, ParserInputCursor.emptyParserInputCursor(), rule, ConsumeWS.NO_CONSUME);
                node.findByState(State.PROPOSE);
                for (ResultNode n : node.findLast()) {
                    n.proposal = this.wrapMultiProposal(last.proposal, n.proposal);
                }
                last.next.add(node);
            }
        }
        return concatResult;
    }

    private ResultNode parseBracket(IFile f, EObject context, ParserInputCursor in, CSSRuleBracket rule, ConsumeWS consumeWS) {
        return this.parse(f, context, in, rule.getInner(), consumeWS);
    }

    private ResultNode parsePostfix(IFile f, EObject context, ParserInputCursor in, CSSRulePostfix r, ConsumeWS consumeWS) {
        ResultNode result = null;
        if (r.getCardinality() != null && !r.getCardinality().isEmpty()) {
            switch (r.getCardinality().charAt(0)) {
                case '?': {
                    result = this.parseOptional(f, context, in, r.getRule(), consumeWS);
                    break;
                }
                case '*': {
                    result = this.parseStar(f, context, in, r.getRule(), consumeWS);
                    break;
                }
                case '+': {
                    result = this.parsePlus(f, context, in, r.getRule(), consumeWS);
                }
            }
        }
        return result;
    }

    private ResultNode parseOptional(IFile f, EObject context, ParserInputCursor in, CSSRule rule, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.OPTIONAL);
        result.remainingInput = in.copy();
        result.status = State.FORWARD;
        result.next.add(ResultNode.createSkipNode(result));
        result.next.add(this.parse(f, context, in.copy(), rule, consumeWS));
        return result;
    }

    private ResultNode parseStar(IFile f, EObject context, ParserInputCursor in, CSSRule rule, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.STAR);
        result.status = State.FORWARD;
        result.remainingInput = in.copy();
        LinkedList<ResultNode> last = new LinkedList<ResultNode>();
        last.addAll(result.findLast());
        boolean first = true;
        while (!last.isEmpty()) {
            ResultNode cur = (ResultNode)last.poll();
            if (!cur.isValid()) continue;
            ResultNode n = this.parse(f, context, cur.remainingInput.copy(), rule, consumeWS);
            last.addAll(n.findLast());
            if (first) {
                cur.next.add(n);
                ResultNode skipStarNode = new ResultNode(NodeType.STAR);
                skipStarNode.status = State.SKIP;
                skipStarNode.remainingInput = cur.remainingInput.copy();
                cur.next.add(skipStarNode);
                first = false;
                continue;
            }
            ResultNode starNode = new ResultNode(NodeType.STAR);
            starNode.status = State.FORWARD;
            starNode.remainingInput = cur.remainingInput.copy();
            starNode.next.add(n);
            cur.next.add(starNode);
            ResultNode skipStarNode = new ResultNode(NodeType.STAR);
            skipStarNode.status = State.SKIP;
            skipStarNode.remainingInput = cur.remainingInput.copy();
            starNode.next.add(skipStarNode);
        }
        return result;
    }

    private ResultNode parsePlus(IFile f, EObject context, ParserInputCursor in, CSSRule rule, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.PLUS);
        result.status = State.FORWARD;
        result.remainingInput = in.copy();
        LinkedList<ResultNode> last = new LinkedList<ResultNode>();
        last.addAll(result.findLast());
        int iteration = 0;
        while (!last.isEmpty()) {
            ResultNode cur = (ResultNode)last.poll();
            if (!cur.isValid()) continue;
            ResultNode n = this.parse(f, context, cur.remainingInput.copy(), rule, consumeWS);
            cur.next.add(n);
            if (iteration >= 1) {
                cur.next.add(ResultNode.createSkipNode(cur));
            }
            ++iteration;
        }
        return result;
    }

    private ResultNode parseType(ParserInputCursor l, CSSType type, ConsumeWS consumeWS) {
        ResultNode result = null;
        if ("@NUM".equals(type.getType())) {
            result = this.parseNUMType(l, type, consumeWS);
        } else if ("@INT".equals(type.getType())) {
            result = this.parseINTType(l, type, consumeWS);
        } else if ("@URL".equals(type.getType())) {
            result = this.parseURLType(l, type, consumeWS);
        } else {
            this.logger.error("type " + type + " not supported");
            throw new UnsupportedOperationException("type " + type + " not supported");
        }
        return result;
    }

    private ResultNode parseRegex(ParserInputCursor l, CSSRuleRegex r, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.REGEX);
        String regex = r.getRegex().replaceAll("\\$", "");
        ParserInputCursor localInput = l.copy();
        CssTok tok = localInput.pollNextToken();
        int wsConsumed = 0;
        if (consumeWS == ConsumeWS.MAY_CONSUME) {
            while (tok instanceof WSTok) {
                tok = localInput.pollNextToken();
                ++wsConsumed;
            }
        }
        if (consumeWS == ConsumeWS.MUST_CONSUME && wsConsumed <= 0) {
            result.status = State.INVALID;
            return result;
        }
        this.logger.debug("REGEX1 -> " + regex + " / / " + tok);
        if (tok instanceof ColorTok) {
            String s = ((ColorTok)tok).getValue();
            this.logger.debug("REGEX2 -> " + regex + " / / " + s);
            if (s.matches(regex)) {
                result.status = State.MATCH;
                result.matched = tok;
                result.remainingInput = localInput;
            } else {
                result.status = State.INVALID;
                result.remainingInput = localInput;
            }
        } else {
            result.status = State.INVALID;
            result.message = "expected color token";
        }
        return result;
    }

    private ResultNode parseRef(IFile f, EObject context, ParserInputCursor l, CSSRuleRef r, ConsumeWS consumeWS) {
        this.logger.debug("Entered with: " + r);
        CSSRule rule = this.manager.resolveReference(f, context, r);
        this.logger.debug("Resolved to: " + rule);
        if (rule == null) {
            this.logger.debug("resolving rule ref " + r.getRef().getName() + " returned null (maybe a function?) !!!!!");
            ResultNode inv = new ResultNode(NodeType.REF);
            inv.status = State.INVALID;
            return inv;
        }
        ResultNode rv = this.parse(f, context, l, rule, consumeWS);
        Definition ref = r.getRef();
        QualifiedName fqn = this.nameProvider.getFullyQualifiedName((EObject)ref);
        if (l.isConsumedOrOnlyWSLeft()) {
            List<Proposal> contributedProposalsForRule = this.manager.getContributedProposalsForRule(f, fqn.toString());
            for (Proposal c : contributedProposalsForRule) {
                ResultNode e = new ResultNode(NodeType.REF);
                e.status = State.PROPOSE;
                e.proposal = c;
                rv.next.add(e);
            }
        }
        return rv;
    }

    private ResultNode parseConcatOr(IFile f, EObject context, ParserInputCursor l, CSSRuleXor r, ConsumeWS consumeWS) {
        ResultNode concatOrResult = new ResultNode(NodeType.CONCAT_OR);
        concatOrResult.remainingInput = l.copy();
        concatOrResult.status = State.FORWARD;
        LinkedList<CSSRule> rulesLeft = new LinkedList<CSSRule>((Collection<CSSRule>)r.getXors());
        int maxTests = rulesLeft.size();
        int testNo = 1;
        while (!rulesLeft.isEmpty() && testNo <= maxTests) {
            CSSRule rule = (CSSRule)rulesLeft.poll();
            boolean match = false;
            for (ResultNode last : concatOrResult.findLast()) {
                if (!last.isValid()) continue;
                ResultNode path = this.parse(f, context, last.remainingInput, rule, consumeWS);
                for (ResultNode pathEnd : path.findLast()) {
                    if (!pathEnd.isValid()) continue;
                    match = true;
                }
                last.next.add(path);
                if (rulesLeft.isEmpty()) continue;
                ResultNode skippy = new ResultNode(NodeType.CONCAT_OR);
                skippy.status = State.SKIP;
                skippy.remainingInput = last.remainingInput.copy();
                last.next.add(skippy);
            }
            if (!match) {
                rulesLeft.offer(rule);
                ++testNo;
                continue;
            }
            testNo = 1;
            maxTests = rulesLeft.size();
        }
        return concatOrResult;
    }

    private Proposal createProposal(final String proposal) {
        return new Proposal(){

            public String getProposal() {
                return proposal;
            }

            public int getPriority() {
                return 0;
            }

            public String getLabel() {
                return proposal;
            }

            public String getImageUrl() {
                return null;
            }

            public Object getAdditionalInfo() {
                return null;
            }

            public Proposal.Type getType() {
                return Proposal.Type.Value;
            }

            public String toString() {
                return proposal;
            }
        };
    }

    private Proposal wrapMultiProposal(final Proposal previous, final Proposal proposal) {
        return new MultiProposal(){

            public Proposal.Type getType() {
                return proposal.getType();
            }

            public String getProposal() {
                return String.valueOf(previous.getProposal()) + proposal.getProposal();
            }

            public int getPriority() {
                return proposal.getPriority();
            }

            public String getLabel() {
                return String.valueOf(previous.getLabel()) + proposal.getLabel();
            }

            public String getImageUrl() {
                return proposal.getImageUrl();
            }

            public Object getAdditionalInfo() {
                return proposal.getAdditionalInfo();
            }

            public Proposal getPrevious() {
                return previous;
            }

            public String toString() {
                return String.valueOf(previous.toString()) + " + " + proposal.toString();
            }
        };
    }

    private ResultNode parseFunction(ParserInputCursor in, CSSRuleFunc ruleFunc, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.FUNCTION);
        ParserInputCursor local = in.copy();
        try {
            CssTok tok = this.consumeWS(local, consumeWS);
            if (tok == null) {
                result.status = State.PROPOSE;
                result.proposal = this.createProposal(String.valueOf(ruleFunc.getName()) + "()");
            } else if (tok instanceof FuncTok) {
                FuncTok fTok = (FuncTok)tok;
                String funcName = fTok.getName().getName();
                if (funcName.equals(ruleFunc.getName())) {
                    result.status = State.MATCH;
                    result.matched = tok;
                } else {
                    result.message = "expected " + ruleFunc.getName();
                    result.status = State.INVALID;
                }
            } else {
                result.status = State.INVALID;
                result.message = "expected function";
            }
        }
        catch (Exception e) {
            result.status = State.INVALID;
            result.message = "expected WS";
        }
        result.remainingInput = local.copy();
        return result;
    }

    private ResultNode parseURLType(ParserInputCursor input, CSSType rule, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.TYPE_URL);
        ParserInputCursor local = input.copy();
        try {
            CssTok tok = this.consumeWS(local, consumeWS);
            if (tok != null) {
                if (tok instanceof UrlTok) {
                    result.status = State.MATCH;
                    result.matched = tok;
                    result.remainingInput = local.copy();
                } else {
                    result.status = State.INVALID;
                    result.message = "expected url";
                }
            } else {
                result.status = State.PROPOSE;
                result.proposal = this.createProposal("url(http://efxclipse.org/)");
            }
        }
        catch (Exception e) {
            result.status = State.INVALID;
            result.message = "expected WS";
        }
        return result;
    }

    private ResultNode parseINTType(ParserInputCursor l, CSSType rule, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.TYPE_INT);
        ParserInputCursor local = l.copy();
        try {
            CssTok tok = this.consumeWS(local, consumeWS);
            if (tok != null) {
                if (tok instanceof NumberTok) {
                    NumberTok numberTok = (NumberTok)tok;
                    double number = numberTok.getVal();
                    if (rule instanceof CSSRangedIntType) {
                        CSSRangedIntType ranged = (CSSRangedIntType)rule;
                        int min = ranged.getFrom();
                        int max = ranged.getTo();
                        if ((double)min <= number && number <= (double)max) {
                            result.remainingInput = local;
                            result.status = State.MATCH;
                            result.matched = tok;
                        } else {
                            result.status = State.INVALID;
                            result.message = "invalid range";
                        }
                    } else {
                        result.remainingInput = local;
                        result.status = State.MATCH;
                        result.matched = tok;
                    }
                } else {
                    result.status = State.INVALID;
                }
            } else {
                result.status = State.PROPOSE;
                result.proposal = this.createProposal("0");
            }
        }
        catch (Exception e) {
            result.status = State.INVALID;
            result.message = e.getMessage();
        }
        return result;
    }

    private ResultNode parseNUMType(ParserInputCursor l, CSSType rule, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.TYPE_NUM);
        ParserInputCursor local = l.copy();
        try {
            CssTok tok = this.consumeWS(local, consumeWS);
            if (tok != null) {
                if (tok instanceof NumberTok) {
                    NumberTok numberTok = (NumberTok)tok;
                    double number = numberTok.getVal();
                    if (rule instanceof CSSRangedDoubleType) {
                        CSSRangedDoubleType ranged = (CSSRangedDoubleType)rule;
                        double min = ranged.getFrom();
                        double max = ranged.getTo();
                        if (min <= number && number <= max) {
                            result.remainingInput = local;
                            result.status = State.MATCH;
                            result.matched = tok;
                        } else {
                            result.status = State.INVALID;
                            result.message = "invalid range";
                        }
                    } else {
                        result.remainingInput = local;
                        result.status = State.MATCH;
                        result.matched = tok;
                    }
                } else {
                    result.status = State.INVALID;
                }
            } else {
                result.status = State.PROPOSE;
                result.proposal = this.createProposal("0.0");
            }
        }
        catch (Exception e) {
            result.status = State.INVALID;
            result.message = e.getMessage();
        }
        return result;
    }

    private CssTok consumeWS(ParserInputCursor input, ConsumeWS consumeWS) throws Exception {
        CssTok tok = input.pollNextToken();
        int wsConsumed = 0;
        if (consumeWS == ConsumeWS.MAY_CONSUME || consumeWS == ConsumeWS.MUST_CONSUME) {
            while (tok instanceof WSTok) {
                tok = input.pollNextToken();
                ++wsConsumed;
            }
        }
        if (consumeWS == ConsumeWS.MUST_CONSUME && wsConsumed <= 0) {
            throw new Exception("expected whitespace");
        }
        return tok;
    }

    private ResultNode parseLiteral(ParserInputCursor input, CSSRuleLiteral r, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.LITERAL);
        ParserInputCursor local = input.copy();
        try {
            CssTok tok = this.consumeWS(local, consumeWS);
            if (tok != null) {
                String literal = r.getValue();
                if (this.matchCssTok(tok, literal)) {
                    result.status = State.MATCH;
                    result.matched = tok;
                    result.remainingInput = local.copy();
                } else {
                    result.status = State.INVALID;
                    result.message = "expected " + literal;
                }
            } else {
                result.status = State.PROPOSE;
                result.proposal = this.createProposal(r.getValue());
            }
        }
        catch (Exception e) {
            result.status = State.INVALID;
            result.message = e.getMessage();
        }
        return result;
    }

    private ResultNode parseSymbol(ParserInputCursor l, CSSRuleSymbol r, ConsumeWS consumeWS) {
        ResultNode result = new ResultNode(NodeType.SYMBOL);
        if (consumeWS == ConsumeWS.MUST_CONSUME) {
            consumeWS = ConsumeWS.MAY_CONSUME;
        }
        ParserInputCursor local = l.copy();
        try {
            CssTok tok = this.consumeWS(local, consumeWS);
            if (tok != null) {
                String symbol = r.getSymbol();
                if (this.matchCssTok(tok, symbol)) {
                    result.status = State.MATCH;
                    result.matched = tok;
                    result.remainingInput = local.copy();
                } else {
                    result.status = State.INVALID;
                    result.message = "expected " + symbol;
                }
            } else {
                result.status = State.PROPOSE;
                result.proposal = this.createProposal(r.getSymbol());
            }
        }
        catch (Exception e) {
            result.status = State.INVALID;
            result.message = e.getMessage();
        }
        return result;
    }

    private boolean matchCssTok(CssTok tok, String literal) {
        if (tok instanceof IdentifierTok) {
            return literal.equals(((IdentifierTok)tok).getName());
        }
        if (tok instanceof SymbolTok) {
            return literal.equals(((SymbolTok)tok).getSymbol());
        }
        return false;
    }

    public List<Proposal> findProposals(IFile f, EObject context, String element, String propertyName, List<CssTok> prefixToks, String prefix) {
        this.logger.debugf("findProposals( %s, %s, %s )", new Object[]{element, propertyName, prefix});
        this.logger.debugf("prefixString: '%s'", new Object[]{prefix});
        if (prefixToks.isEmpty()) {
            this.logger.debug("prefixToks: none");
        } else {
            this.logger.debugf("prefixToks:", new Object[0]);
            Iterator<CssTok> iterator = prefixToks.iterator();
            while (iterator.hasNext()) {
                this.logger.debugf(" * %s", new Object[]{TokUtil.toString((CssTok)iterator.next())});
            }
        }
        ArrayList<Proposal> result = new ArrayList<Proposal>();
        PropertyDefinition def = this.manager.findPropertyByName(f, context, propertyName);
        if (def != null) {
            ParserInput input = new ParserInput(prefixToks);
            ParserInputCursor cursor = input.createCursor();
            this.logger.debugf("starting with input: %s", new Object[]{cursor});
            long parseBegin = System.nanoTime();
            ResultNode res = this.parse(f, context, cursor, def.getRule(), ConsumeWS.MAY_CONSUME);
            long parseDuration = System.nanoTime() - parseBegin;
            this.logger.debugf("parse needed %2.3fms returnd with %s", new Object[]{(double)parseDuration * 1.0E-5, res});
            for (ParseResultListener l : this.resultListener) {
                l.parseFinished(res);
            }
            for (ResultNode x : res.findByState(State.MATCH)) {
                if (!x.remainingInput.isConsumedOrOnlyWSLeft()) continue;
                result.add((Proposal)new SimpleProposal(";"));
                break;
            }
            result.addAll(this.mapProposals(res));
        } else {
            result.add(this.createProposal("> no rule for " + propertyName + " found!"));
        }
        this.logger.debugf("-> returning %s", new Object[]{result});
        return result;
    }

    private List<Proposal> mapProposals(ResultNode result) {
        ArrayList<Proposal> proposals = new ArrayList<Proposal>();
        ArrayList<Proposal> drop = new ArrayList<Proposal>();
        for (ResultNode r : result.findByState(State.PROPOSE)) {
            if (!r.next.isEmpty()) {
                ResultNode cur = r;
                List<ResultNode> allSubPropose = cur.findByState(State.PROPOSE);
                allSubPropose.remove(cur);
                for (ResultNode n : allSubPropose) {
                    if (n.proposal instanceof MultiProposal) continue;
                    drop.add(n.proposal);
                }
            }
            proposals.add(r.proposal);
        }
        this.logger.debugf("Dropping %s", new Object[]{drop});
        proposals.removeAll(drop);
        return proposals;
    }

    public List<ValidationResult> validateProperty(IFile f, EObject context, String element, String propertyName, List<CssTok> tokens) {
        this.logger.debugf("validateProperty( %s, %s )", new Object[]{element, propertyName});
        if (tokens.isEmpty()) {
            this.logger.debugf("tokens: none", new Object[0]);
        } else {
            this.logger.debug("tokens:");
            Iterator<CssTok> iterator = tokens.iterator();
            while (iterator.hasNext()) {
                this.logger.debugf(" * %s", new Object[]{TokUtil.toString((CssTok)iterator.next())});
            }
        }
        PropertyDefinition def = this.manager.findPropertyByName(f, context, propertyName);
        if (def != null) {
            boolean valid = false;
            Object lastToken = null;
            this.logger.debug("valid = " + valid);
            this.logger.debug("lastToken = " + lastToken);
            ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
            return results;
        }
        return null;
    }

    public void addParseResultListener(ParseResultListener l) {
        this.resultListener.add(l);
    }

    private static enum ConsumeWS {
        MAY_CONSUME,
        MUST_CONSUME,
        NO_CONSUME;

    }

    public static interface ParseResultListener {
        public void parseFinished(ResultNode var1);
    }
}

