/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.fx.ide.fxgraph.ui.internal.FXGraphActivator;
import org.eclipse.fx.ide.fxgraph.ui.wizards.template.FXGraphElement;
import org.eclipse.fx.ide.ui.wizards.AbstractJDTElementPage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FXGraphWizardPage
extends AbstractJDTElementPage<FXGraphElement> {
    private IType customSelection;

    protected FXGraphWizardPage(IPackageFragmentRoot froot, IPackageFragment fragment, IWorkspaceRoot fWorkspaceRoot) {
        super("fxgraph", "FXGraph File", "Create a new FXGraph File", froot, fragment, fWorkspaceRoot);
    }

    protected ImageDescriptor getTitleAreaImage(Display display) {
        return FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.FXGraph", (String)"/icons/title_banner.png");
    }

    protected void createFields(Composite parent, DataBindingContext dbc) {
        Label l = new Label(parent, 0);
        l.setText("Root Element");
        final ComboViewer viewer = new ComboViewer(parent);
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IType t = (IType)element;
                return t.getElementName() + " - " + t.getPackageFragment().getElementName();
            }
        });
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        List<IType> types = this.getTypes();
        viewer.setInput(types);
        viewer.getControl().setLayoutData((Object)new GridData(768));
        Button button = new Button(parent, 8);
        button.setText("Browse ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType type = FXGraphWizardPage.this.findContainerType();
                if (type != null) {
                    FXGraphWizardPage.this.customSelection = type;
                    viewer.setInput(FXGraphWizardPage.this.getTypes());
                    viewer.setSelection((ISelection)new StructuredSelection((Object)type));
                }
            }
        });
        FXGraphElement element = (FXGraphElement)this.getClazz();
        element.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("fragmentRoot".equals(evt.getPropertyName())) {
                    viewer.setInput(FXGraphWizardPage.this.getTypes());
                }
            }
        });
        dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)viewer), BeanProperties.value((String)"rootElement").observe((Object)this.getClazz()));
        if (types.size() > 0) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)types.get(0)));
        }
        l = new Label(parent, 0);
        l.setText("Dynamic Root (fx:root)");
        Button b = new Button(parent, 32);
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)b), BeanProperties.value((String)"dynamic").observe((Object)this.getClazz()));
    }

    IType findContainerType() {
        if (((FXGraphElement)this.getClazz()).getFragmentRoot() != null) {
            IJavaProject project = ((FXGraphElement)this.getClazz()).getFragmentRoot().getJavaProject();
            try {
                IType superType = project.findType("javafx.scene.Parent");
                if (superType != null) {
                    IJavaSearchScope searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)project, (IType)superType, (boolean)true, (boolean)false, null);
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)searchScope, (int)2, (boolean)false, (String)"");
                    dialog.setTitle("Find Preloader");
                    if (dialog.open() == 0) {
                        IType type = (IType)dialog.getResult()[0];
                        return type;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void revalidate() {
        if (((FXGraphElement)this.getClazz()).getName() == null || ((FXGraphElement)this.getClazz()).getName().trim().length() == 0) {
            this.setPageComplete(false);
            this.setMessage("Enter a name", 3);
        } else if (Character.isLowerCase(((FXGraphElement)this.getClazz()).getName().charAt(0))) {
            this.setPageComplete(true);
            this.setMessage("An FXGraph file should start with an uppercase", 2);
        } else {
            this.setPageComplete(true);
            this.setMessage(null);
        }
    }

    private List<IType> getTypes() {
        ArrayList<IType> list = new ArrayList<IType>();
        if (((FXGraphElement)this.getClazz()).getFragmentRoot() != null) {
            IType t;
            String s;
            int n;
            int n2;
            String[] stringArray;
            IJavaProject jp = ((FXGraphElement)this.getClazz()).getFragmentRoot().getJavaProject();
            if (this.customSelection != null) {
                try {
                    IType t2 = jp.findType(this.customSelection.getFullyQualifiedName());
                    if (t2 != null && !list.contains(t2)) {
                        list.add(t2);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            if (this.getDialogSettings() != null && this.getDialogSettings().getArray("KEY_LAST_SELECTIONS") != null) {
                stringArray = this.getDialogSettings().getArray("KEY_LAST_SELECTIONS");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    s = stringArray[n];
                    try {
                        t = jp.findType(s);
                        if (t != null && !list.contains(t)) {
                            list.add(t);
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    ++n;
                }
            }
            stringArray = new String[]{"javafx.scene.layout.AnchorPane", "javafx.scene.layout.BorderPane", "javafx.scene.layout.FlowPane", "javafx.scene.layout.GridPane", "javafx.scene.layout.HBox", "javafx.scene.layout.Region", "javafx.scene.layout.StackPane", "javafx.scene.layout.TilePane", "javafx.scene.layout.VBox", "javafx.scene.Scene"};
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                try {
                    t = jp.findType(s);
                    if (t != null && !list.contains(t)) {
                        list.add(t);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                ++n;
            }
        }
        return list;
    }

    protected FXGraphElement createInstance() {
        return new FXGraphElement();
    }
}

