/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

public class CommentAnnotationManager
extends AnnotationModel {
    public void addAnnotation(Annotation annotation, Position position) {
        Iterator it = this.getAnnotationIterator(position.getOffset(), position.getLength(), true, true);
        if (!it.hasNext()) {
            super.addAnnotation(annotation, position);
            return;
        }
        Annotation an = (Annotation)it.next();
        Position existingPosition = this.getPosition(an);
        if (existingPosition.getOffset() == position.getOffset()) {
            this.removeAnnotation(an);
            super.addAnnotation(an, new Position(existingPosition.getOffset() + position.getLength() + this.getDefaultLineDelimiterSize(), existingPosition.length - (position.length + this.getDefaultLineDelimiterSize())));
            super.addAnnotation(annotation, position);
        }
    }

    private int getDefaultLineDelimiterSize() {
        if (this.fDocument instanceof IDocumentExtension4) {
            return ((IDocumentExtension4)this.fDocument).getDefaultLineDelimiter().length();
        }
        return this.getDefaultLineDelimiter().length();
    }

    private String getDefaultLineDelimiter() {
        String lineDelimiter = null;
        try {
            lineDelimiter = this.fDocument.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        String sysLineDelimiter = System.getProperty("line.separator");
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        Assert.isTrue((delimiters.length > 0 ? 1 : 0) != 0);
        String[] stringArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String delimiter = stringArray[n2];
            if (delimiter.equals(sysLineDelimiter)) {
                lineDelimiter = sysLineDelimiter;
                break;
            }
            ++n2;
        }
        if (lineDelimiter == null) {
            lineDelimiter = delimiters[0];
        }
        return lineDelimiter;
    }
}

