/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.domain.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainEPackage;
import org.eclipse.egf.model.domain.DomainPackage;
import org.eclipse.egf.model.domain.DomainURI;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.TypeDomainEPackage;
import org.eclipse.egf.model.domain.TypeDomainURI;
import org.eclipse.egf.model.types.util.TypesValidator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainValidator
extends EObjectValidator {
    public static final DomainValidator INSTANCE = new DomainValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.domain";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator;
    protected TypesValidator typesValidator = TypesValidator.INSTANCE;

    public DomainValidator() {
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return DomainPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDomainViewpoint((DomainViewpoint)value, diagnostics, context);
            }
            case 1: {
                return this.validateDomain((Domain)value, diagnostics, context);
            }
            case 2: {
                return this.validateDomainEPackage((DomainEPackage)value, diagnostics, context);
            }
            case 3: {
                return this.validateTypeDomainEPackage((TypeDomainEPackage)value, diagnostics, context);
            }
            case 4: {
                return this.validateDomainURI((DomainURI)value, diagnostics, context);
            }
            case 5: {
                return this.validateTypeDomainURI((TypeDomainURI)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDomainViewpoint(DomainViewpoint domainViewpoint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(domainViewpoint, diagnostics, context);
    }

    public boolean validateDomain(Domain domain, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(domain, diagnostics, context);
    }

    public boolean validateDomainEPackage(DomainEPackage domainEPackage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(domainEPackage, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(domainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(domainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(domainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(domainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(domainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(domainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDomainEPackage_ValidPackage(domainEPackage, diagnostics, context);
        }
        return result;
    }

    public boolean validateDomainEPackage_ValidPackage(DomainEPackage domainEPackage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (domainEPackage.getEPackage() == null) {
            return true;
        }
        if (EPackage.Registry.INSTANCE.get((Object)domainEPackage.getEPackage().getNsURI()) == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidPackage", DomainValidator.getObjectLabel((EObject)domainEPackage, context), "Unknown EPackage in EPackage.Registry"}, new Object[]{domainEPackage}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeDomainEPackage(TypeDomainEPackage typeDomainEPackage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(typeDomainEPackage, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeDomainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeDomainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeDomainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeDomainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeDomainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeDomainEPackage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeObject_ValidValue(typeDomainEPackage, diagnostics, context);
        }
        return result;
    }

    public boolean validateDomainURI(DomainURI domainURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(domainURI, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(domainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(domainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(domainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(domainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(domainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(domainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateDomainURI_ValidURI(domainURI, diagnostics, context);
        }
        return result;
    }

    public boolean validateDomainURI_ValidURI(DomainURI domainURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean valid = true;
        if (!valid) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ValidURI", DomainValidator.getObjectLabel((EObject)domainURI, context)}, new Object[]{domainURI}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeDomainURI(TypeDomainURI typeDomainURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(typeDomainURI, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.typesValidator.validateTypeObject_ValidValue(typeDomainURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeDomainURI_ValidDomainURI(typeDomainURI, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeDomainURI_ValidDomainURI(TypeDomainURI typeDomainURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeDomainURI.eResource() == null || typeDomainURI.getDomain() == null) {
            return true;
        }
        boolean found = false;
        TreeIterator iterator = EcoreUtil.getAllProperContents((Resource)typeDomainURI.eResource(), (boolean)false);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof DomainURI) || eObject != typeDomainURI.getDomain()) continue;
            found = true;
            break;
        }
        if (!found) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidDomainURI", DomainValidator.getObjectLabel((EObject)typeDomainURI, context), "Unknown Domain URI in this resource"}, new Object[]{typeDomainURI}, context));
            }
            return false;
        }
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

