/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.common.java.AbstractJavaEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.java.Messages;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyContentProvider;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyHelper;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class JavaEngine
extends AbstractJavaEngine {
    public JavaEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        JavaAssemblyHelper helper = new JavaAssemblyHelper(pattern, new JavaAssemblyContentProvider(pattern));
        String templatecontent = helper.visit();
        if (this.getPattern().getSuperPattern() != null || !this.getPattern().getAllParameters().isEmpty()) {
            Document document = new Document(templatecontent);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(8);
            parser.setSource(document.get().toCharArray());
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            cu.recordModifications();
            if ((cu.getFlags() & 1) == 0) {
                TypeDeclaration type = (TypeDeclaration)cu.types().get(0);
                if (this.getPattern().getSuperPattern() != null) {
                    String parentClassName = JavaNatureHelper.getClassName(this.getPattern().getSuperPattern());
                    AST ast = type.getAST();
                    SimpleType newSimpleType = ast.newSimpleType(ast.newName(parentClassName));
                    type.setSuperclassType((Type)newSimpleType);
                }
                for (PatternParameter param : this.getPattern().getParameters()) {
                    AST ast = type.getAST();
                    String typeValue = ParameterTypeHelper.INSTANCE.getTypeLiteral(param.getType());
                    VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
                    fragment.setName(ast.newSimpleName(param.getName()));
                    FieldDeclaration field = ast.newFieldDeclaration(fragment);
                    field.modifiers().addAll(ast.newModifiers(2));
                    field.setType((Type)ast.newSimpleType(ast.newName(typeValue)));
                    type.bodyDeclarations().add(field);
                    MethodDeclaration setter = ast.newMethodDeclaration();
                    setter.modifiers().addAll(ast.newModifiers(1));
                    setter.setName(ast.newSimpleName(JavaMethodGenerationHelper.getSetterMethod((PatternParameter)param)));
                    SingleVariableDeclaration variableDeclaration = ast.newSingleVariableDeclaration();
                    variableDeclaration.setType((Type)ast.newSimpleType(ast.newName(typeValue)));
                    variableDeclaration.setName(ast.newSimpleName(param.getName()));
                    setter.parameters().add(variableDeclaration);
                    Block body = ast.newBlock();
                    Assignment assignment = ast.newAssignment();
                    FieldAccess fieldAccess = ast.newFieldAccess();
                    fieldAccess.setName(ast.newSimpleName(param.getName()));
                    fieldAccess.setExpression((Expression)ast.newThisExpression());
                    assignment.setLeftHandSide((Expression)fieldAccess);
                    assignment.setOperator(Assignment.Operator.ASSIGN);
                    assignment.setRightHandSide((Expression)ast.newSimpleName(param.getName()));
                    body.statements().add(ast.newExpressionStatement((Expression)assignment));
                    setter.setBody(body);
                    type.bodyDeclarations().add(setter);
                }
            }
            TextEdit rewrite = cu.rewrite((IDocument)document, null);
            try {
                rewrite.apply((IDocument)document);
            }
            catch (BadLocationException e1) {
                throw new PatternException((Throwable)e1);
            }
            templatecontent = document.get();
        }
        try {
            IPlatformFcore platformFactoryComponent = PatternHelper.getPlatformFcore((PatternElement)pattern);
            if (platformFactoryComponent == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error4, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            IProject project = platformFactoryComponent.getPlatformBundle().getProject();
            if (project == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            String classname = JavaNatureHelper.getClassName(pattern);
            IPath outputPath = this.computeFilePath(classname);
            FileHelper.setContent((IFile)project.getFile(outputPath), (String)templatecontent);
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    protected String getPatternClassname() throws PatternException {
        return JavaNatureHelper.getClassName(this.getPattern());
    }
}

