/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.ui.helper.EditorHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.EGFResourceLoadedListener;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.contributor.ListenerContributor;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.adapter.PatternBundleAdapter;
import org.eclipse.egf.model.editor.adapter.TaskBundleAdapter;
import org.eclipse.egf.model.editor.provider.FcoreContentProvider;
import org.eclipse.egf.model.editor.provider.FcorePropertySheetPage;
import org.eclipse.egf.model.fcore.provider.FcoreCustomItemProviderAdapterFactory;
import org.eclipse.egf.model.fcore.provider.FcoreResourceItemProviderAdapterFactory;
import org.eclipse.egf.model.fprod.provider.FprodCustomItemProviderAdapterFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreEditor
extends MultiPageEditorPart
implements EGFResourceLoadedListener.ResourceUser,
EGFResourceLoadedListener.ResourceListener,
IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ObjectUndoContext undoContext;
    protected Resource resource;
    protected ComposedAdapterFactory adapterFactory;
    protected ComposedAdapterFactory propertyAdapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected AdapterFactoryContentProvider.ViewerRefresh viewerRefresh;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == FcoreEditor.this.contentOutlinePage) {
                    FcoreEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)FcoreEditor.this);
                    FcoreEditor.this.setCurrentViewer((Viewer)FcoreEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == FcoreEditor.this.propertySheetPage) {
                    FcoreEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)FcoreEditor.this);
                    FcoreEditor.this.handleActivate();
                }
            } else if (p == FcoreEditor.this) {
                FcoreEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
            switch (event.getEventType()) {
                case 4: {
                    if (!affectedResources.contains(FcoreEditor.this.getResource())) break;
                    final IUndoableOperation operation = event.getOperation();
                    operation.removeContext(((IWorkspaceCommandStack)FcoreEditor.this.getEditingDomain().getCommandStack()).getDefaultUndoContext());
                    operation.addContext((IUndoContext)FcoreEditor.this.getUndoContext());
                    FcoreEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Command command;
                            FcoreEditor.this.firePropertyChange(257);
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
                                FcoreEditor.this.setSelectionToViewer(command.getAffectedObjects());
                            }
                            if ((this).FcoreEditor.this.propertySheetPage != null) {
                                (this).FcoreEditor.this.propertySheetPage.refresh();
                            }
                        }
                    });
                    break;
                }
                case 9: 
                case 10: {
                    if (!affectedResources.contains(FcoreEditor.this.getResource())) break;
                    final IUndoableOperation operation = event.getOperation();
                    FcoreEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Command command;
                            FcoreEditor.this.firePropertyChange(257);
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
                                FcoreEditor.this.setSelectionToViewer(command.getAffectedObjects());
                            }
                            if ((this).FcoreEditor.this.propertySheetPage != null) {
                                (this).FcoreEditor.this.propertySheetPage.refresh();
                            }
                        }
                    });
                }
            }
        }
    };
    protected boolean resourceHasBeenRemoved;
    protected boolean resourceHasBeenExternallyChanged;
    protected boolean userHasSavedResource;
    protected Map<URI, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<URI, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected List<EContentAdapter> egfAdapters = new UniqueEList();
    private boolean tabFolderGuard = false;
    protected EContentAdapter editorResourceAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            block12: {
                block11: {
                    if (!(notification.getNotifier() instanceof Resource)) break block11;
                    switch (notification.getFeatureID(Resource.class)) {
                        case 4: 
                        case 6: 
                        case 7: {
                            Resource innerResource = (Resource)notification.getNotifier();
                            if (innerResource == FcoreEditor.this.getResource() || ResourceHelper.hasURIProxyReferences((Resource)FcoreEditor.this.getResource(), (URI)innerResource.getURI())) {
                                List owners;
                                Diagnostic diagnostic = ResourceHelper.analyzeResourceProblems((Resource)innerResource, null, (String)EGFCorePlugin.FCORE_EDITOR_ID);
                                if (diagnostic.getSeverity() != 0) {
                                    FcoreEditor.this.resourceToDiagnosticMap.put(innerResource.getURI(), diagnostic);
                                } else {
                                    FcoreEditor.this.resourceToDiagnosticMap.remove(innerResource.getURI());
                                }
                                if (!(innerResource == FcoreEditor.this.getResource() || FcoreEditor.this.selectionViewer == null || FcoreEditor.this.selectionViewer.getControl() == null || FcoreEditor.this.selectionViewer.getControl().isDisposed() || FcoreEditor.this.selectionViewer.isBusy() || (owners = ResourceHelper.getURIProxyReferenceOwners((Resource)FcoreEditor.this.getResource(), (URI)innerResource.getURI())) == null || owners.isEmpty())) {
                                    if (FcoreEditor.this.viewerRefresh == null) {
                                        FcoreEditor.this.viewerRefresh = new AdapterFactoryContentProvider.ViewerRefresh((Viewer)FcoreEditor.this.selectionViewer);
                                    }
                                    for (EObject eObject : owners) {
                                        ENotificationImpl ownerNotification = new ENotificationImpl((InternalEObject)eObject, 9, null, (Object)eObject, (Object)eObject);
                                        FcoreEditor.this.viewerRefresh.addNotification((IViewerNotification)new ViewerNotification((Notification)ownerNotification, ownerNotification.getNotifier(), true, true));
                                    }
                                    FcoreEditor.this.selectionViewer.getControl().getDisplay().asyncExec((Runnable)FcoreEditor.this.viewerRefresh);
                                }
                                if (FcoreEditor.this.updateProblemIndication) {
                                    FcoreEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            FcoreEditor.this.updateProblemIndication();
                                        }
                                    });
                                    break;
                                }
                            }
                            break block12;
                        }
                        case 1: 
                        case 2: {
                            FcoreEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    FcoreEditor.this.firePropertyChange(257);
                                }
                            });
                        }
                    }
                    break block12;
                }
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource innerTarget) {
            this.basicSetTarget((Notifier)innerTarget);
        }

        protected void unsetTarget(Resource innerTarget) {
            this.basicUnsetTarget((Notifier)innerTarget);
        }
    };

    public ObjectUndoContext getUndoContext() {
        return this.undoContext;
    }

    protected void handleActivate() {
        this.setCurrentViewer((Viewer)this.selectionViewer);
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (this.resourceHasBeenRemoved) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!FcoreEditor.this.isDirty() || FcoreEditor.this.handleDirtyConflict()) {
                        FcoreEditor.this.getSite().getPage().closeEditor((IEditorPart)FcoreEditor.this, false);
                    }
                }
            });
        } else if (this.resourceHasBeenExternallyChanged) {
            this.handleChangedResource();
        }
    }

    public void resourceMoved(Resource movedResource, URI oldURI) {
        if (movedResource == this.getResource()) {
            this.resourceHasBeenExternallyChanged = false;
            this.resourceHasBeenRemoved = false;
            this.userHasSavedResource = false;
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AdapterFactoryEditingDomain.isStale((Object)FcoreEditor.this.editorSelection)) {
                        FcoreEditor.this.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                    FcoreEditor.this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)FcoreEditor.this.getResource()), true);
                    if (FcoreEditor.this.currentViewerPane != null) {
                        FcoreEditor.this.currentViewerPane.setTitle((Object)FcoreEditor.this.getResource());
                    }
                    FcoreEditor.this.setTitleToolTip(FcoreEditor.this.getResource().toString());
                }
            });
        }
    }

    public void resourceDeleted(Resource deletedResource) {
        if (deletedResource == this.getResource()) {
            if (!this.isDirty()) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        FcoreEditor.this.getSite().getPage().closeEditor((IEditorPart)FcoreEditor.this, false);
                    }
                });
                return;
            }
            this.resourceHasBeenRemoved = true;
        }
    }

    public void resourceReloaded(Resource reloadedResource) {
        if (reloadedResource == this.getResource()) {
            this.resourceHasBeenExternallyChanged = false;
            this.resourceHasBeenRemoved = false;
            this.userHasSavedResource = false;
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AdapterFactoryEditingDomain.isStale((Object)FcoreEditor.this.editorSelection)) {
                        FcoreEditor.this.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                    FcoreEditor.this.getOperationHistory().dispose((IUndoContext)FcoreEditor.this.undoContext, true, true, true);
                    FcoreEditor.this.selectionViewer.setInput((Object)FcoreEditor.this.getResource());
                    FcoreEditor.this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)FcoreEditor.this.getResource()), true);
                    FcoreEditor.this.currentViewerPane.setTitle((Object)FcoreEditor.this.getResource());
                    FcoreEditor.this.updateProblemIndication = true;
                }
            });
        }
    }

    public boolean userHasSavedResource() {
        return this.userHasSavedResource;
    }

    public boolean resourceHasBeenExternallyChanged() {
        return this.resourceHasBeenExternallyChanged;
    }

    public void externalUpdate(Resource changedResource) {
        if (changedResource == this.getResource()) {
            this.resourceHasBeenExternallyChanged = true;
        }
    }

    public void internalUpdate(Resource changedResource) {
        if (changedResource == this.getResource()) {
            this.resourceHasBeenExternallyChanged = false;
            this.resourceHasBeenRemoved = false;
            this.userHasSavedResource = false;
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                FcoreEditor.this.firePropertyChange(257);
            }
        });
    }

    protected void handleChangedResource() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            EGFResourceLoadedListener.RESOURCE_MANAGER.reloadResource(this.getResource());
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, EGFCorePlugin.FCORE_EDITOR_ID, 0, null, new Object[]{this.getResource()});
            for (URI uri : this.resourceToDiagnosticMap.keySet()) {
                Diagnostic childDiagnostic = this.resourceToDiagnosticMap.get(uri);
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                } else {
                    this.removePage(lastEditorPage);
                    this.setActivePage(0);
                    if (!this.tabFolderGuard) {
                        this.tabFolderGuard = true;
                        this.hideTabs();
                        this.tabFolderGuard = false;
                    }
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    EGFModelEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            for (URI uri : this.resourceToDiagnosticMap.keySet()) {
                Diagnostic childDiagnostic = this.resourceToDiagnosticMap.get(uri);
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)this.getResource())) {
                this.markerHelper.deleteMarkers((Object)this.getResource());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        EGFModelEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)FcoreEditor.getString("_UI_FileConflict_label"), (String)FcoreEditor.getString("_WARN_FileConflict"));
    }

    public FcoreEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.propertyAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.propertyAdapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this.propertyAdapterFactory.addAdapterFactory((AdapterFactory)new FprodCustomItemProviderAdapterFactory());
        this.propertyAdapterFactory.addAdapterFactory((AdapterFactory)new FcoreCustomItemProviderAdapterFactory());
        this.propertyAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = (AdapterFactoryEditingDomain)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        this.undoContext = new ObjectUndoContext((Object)this, EGFModelEditorPlugin.getPlugin().getString("_UI_FcoreEditor_label"));
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        UniqueEList theSelection = new UniqueEList(collection.size());
        for (Object object : collection) {
            if (!(object instanceof EObject)) continue;
            URI uri = null;
            try {
                uri = EcoreUtil.getURI((EObject)((EObject)object));
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject == null) continue;
                theSelection.add(eObject);
            }
            catch (Throwable t) {
                if (uri != null) {
                    EGFModelEditorPlugin.getPlugin().logError(uri.toString(), t);
                    continue;
                }
                EGFModelEditorPlugin.getPlugin().logError(object.toString(), t);
            }
        }
        Runnable runnable = new Runnable((Collection)theSelection){
            private final /* synthetic */ Collection val$theSelection;
            {
                this.val$theSelection = collection;
            }

            public void run() {
                if (FcoreEditor.this.currentViewer != null) {
                    FcoreEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(this.val$theSelection.toArray()), true);
                }
            }
        };
        this.getSite().getShell().getDisplay().asyncExec(runnable);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return (TransactionalEditingDomain)this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        FcoreEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 3;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.getEditingDomain(), (Viewer)viewer));
    }

    public void createModel() {
        URI uri = EditorHelper.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        this.resource = null;
        try {
            this.resource = this.editingDomain.getResourceSet().getResource(uri, true);
        }
        catch (Exception e) {
            exception = e;
            this.resource = this.editingDomain.getResourceSet().getResource(uri, false);
        }
        this.resourceHasBeenExternallyChanged = EGFResourceLoadedListener.RESOURCE_MANAGER.resourceHasBeenExternallyChanged(this.resource);
        Diagnostic diagnostic = ResourceHelper.analyzeResourceProblems((Resource)this.resource, (Exception)exception, (String)EGFCorePlugin.FCORE_EDITOR_ID);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(this.resource.getURI(), diagnostic);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.editorResourceAdapter);
        this.egfAdapters.add(new PatternBundleAdapter(this.resource, this.getSite()));
        this.egfAdapters.add(new TaskBundleAdapter(this.resource, this.getSite()));
        this.getEditingDomain().getResourceSet().eAdapters().addAll(this.egfAdapters);
    }

    public EGFResourceLoadedListener.ResourceListener getListener() {
        return this;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void createPages() {
        if (this.getResource() != null) {
            ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    Tree tree = new Tree(composite, 2);
                    TreeViewer newTreeViewer = new TreeViewer(tree);
                    return newTreeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                    FcoreEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.selectionViewer = (TreeViewer)viewerPane.getViewer();
            this.selectionViewer.setContentProvider((IContentProvider)new FcoreContentProvider(this.getEditingDomain(), (AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new TransactionalAdapterFactoryLabelProvider(this.getEditingDomain(), (AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.getResource());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)this.getResource()), true);
            viewerPane.setTitle((Object)this.getResource());
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.egf.core.ui.editor.listener.contributor");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ListenerContributor contributor = (ListenerContributor)element.createExecutableExtension("class");
                    contributor.addListeners(this.getEditorSite().getPage(), (StructuredViewer)this.selectionViewer);
                }
                catch (CoreException e) {
                    EGFCoreUIPlugin.getDefault().logError((Throwable)e);
                }
                ++n2;
            }
            int pageIndex = this.addPage(viewerPane.getControl());
            this.setPageText(pageIndex, FcoreEditor.getString("_UI_SelectionPage_label"));
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                if (!FcoreEditor.this.tabFolderGuard) {
                    FcoreEditor.this.tabFolderGuard = true;
                    FcoreEditor.this.hideTabs();
                    FcoreEditor.this.tabFolderGuard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                FcoreEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, FcoreEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        if (key.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    FcoreEditor.this.contentOutlineViewer = this.getTreeViewer();
                    FcoreEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    FcoreEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new FcoreContentProvider(FcoreEditor.this.getEditingDomain(), (AdapterFactory)FcoreEditor.this.adapterFactory));
                    FcoreEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new TransactionalAdapterFactoryLabelProvider(FcoreEditor.this.getEditingDomain(), (AdapterFactory)FcoreEditor.this.adapterFactory));
                    FcoreEditor.this.contentOutlineViewer.setInput((Object)FcoreEditor.this.getResource());
                    FcoreEditor.this.createContextMenuFor((StructuredViewer)FcoreEditor.this.contentOutlineViewer);
                    if (!FcoreEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ArrayList<Resource> selection = new ArrayList<Resource>();
                        selection.add(FcoreEditor.this.getResource());
                        FcoreEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    FcoreEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    FcoreEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FcoreEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new FcorePropertySheetPage((AdapterFactoryEditingDomain)this.getEditingDomain()){

                public void setSelectionToViewer(List<?> selection) {
                    FcoreEditor.this.setSelectionToViewer(selection);
                    FcoreEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    FcoreEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }

                public void dispose() {
                    super.dispose();
                    FcoreEditor.this.propertySheetPage = null;
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new FcoreContentProvider(this.getEditingDomain(), (AdapterFactory)this.propertyAdapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        if (this.getResource() == null) {
            return false;
        }
        return this.getResource().isModified();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    FcoreEditor.this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            Resource resourceToSave = FcoreEditor.this.getResource();
                            try {
                                long timeStamp = resourceToSave.getTimeStamp();
                                resourceToSave.save(Collections.EMPTY_MAP);
                                if (resourceToSave.getTimeStamp() != timeStamp) {
                                    (this).FcoreEditor.this.userHasSavedResource = true;
                                }
                            }
                            catch (Exception exception) {
                                (this).FcoreEditor.this.resourceToDiagnosticMap.put((this).FcoreEditor.this.resource.getURI(), ResourceHelper.analyzeResourceProblems((Resource)(this).FcoreEditor.this.resource, (Exception)exception, (String)EGFCorePlugin.FCORE_EDITOR_ID));
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)t);
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            this.firePropertyChange(257);
        }
        catch (Throwable t) {
            ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)t);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource innerResource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(innerResource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(final URI uri, final IEditorInput editorInput) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    FcoreEditor.this.getResource().setURI(uri);
                    FcoreEditor.this.setInputWithNotify(editorInput);
                    FcoreEditor.this.setPartName(editorInput.getName());
                }
            });
        }
        catch (InterruptedException ie) {
            EGFModelEditorPlugin.getPlugin().logError(ie);
            return;
        }
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        public void run() {
                            URI uri = URI.createURI((String)uriAttribute);
                            EObject eObject = FcoreEditor.this.editingDomain.getResourceSet().getEObject(uri, true);
                            if (eObject != null) {
                                FcoreEditor.this.setSelectionToViewer(Collections.singleton(FcoreEditor.this.editingDomain.getWrapper((Object)eObject)));
                            }
                        }
                    });
                }
                catch (InterruptedException ie) {
                    EGFModelEditorPlugin.getPlugin().logError(ie);
                }
            }
        }
        catch (CoreException ce) {
            EGFModelEditorPlugin.getPlugin().logError(ce);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.createModel();
        EGFResourceLoadedListener.RESOURCE_MANAGER.addObserver((EGFResourceLoadedListener.ResourceUser)this);
        EGFResourceLoadedListener.RESOURCE_MANAGER.populateUndoContext(this.getOperationHistory(), this.undoContext, this.getResource());
    }

    public void setFocus() {
        this.selectionViewer.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(FcoreEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(FcoreEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(FcoreEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return EGFModelEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return EGFModelEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public void dispose() {
        this.updateProblemIndication = false;
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.getOperationHistory().dispose((IUndoContext)this.getUndoContext(), true, true, true);
        EGFResourceLoadedListener.RESOURCE_MANAGER.removeObserver((EGFResourceLoadedListener.ResourceUser)this);
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.editorResourceAdapter);
        for (EContentAdapter adapter : this.egfAdapters) {
            this.editingDomain.getResourceSet().eAdapters().remove((Object)adapter);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public class ReverseAdapterFactoryContentProvider
    extends TransactionalAdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(FcoreEditor.this.getEditingDomain(), adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

