/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ftask.tasks;

import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.TypePatternList;
import org.eclipse.egf.pattern.collector.PatternCollector;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.ftask.tasks.AbstractPatternTask;
import org.eclipse.emf.ecore.EObject;

public class PatternTask
extends AbstractPatternTask {
    private final LinkedHashSet<Pattern> patterns = new LinkedHashSet();

    public void preExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        TypePatternList patternList = (TypePatternList)context.getInputValue((Object)"pattern.id", TypePatternList.class);
        PatternCollector.INSTANCE.collect((EObject[])patternList.getElements().toArray((Object[])new PatternElement[patternList.getElements().size()]), this.patterns);
    }

    public void doExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        try {
            PatternContext ctx = this.createPatternContext(context);
            this.readContext(context, ctx);
            for (Pattern pattern : this.patterns) {
                PatternExtension extension = ExtensionHelper.getExtension((PatternNature)pattern.getNature());
                String reason = extension.canExecute(pattern);
                if (reason == null) {
                    extension.createEngine(pattern).execute(ctx);
                    continue;
                }
                throw new InvocationException(reason);
            }
            this.writeContext(context, ctx);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new InvocationException((Throwable)e);
        }
        catch (PatternException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        super.postExecute(context, monitor);
        this.patterns.clear();
    }
}

