/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.helper.JavaHelper;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerContentProvider
implements ITreeContentProvider {
    private Map<IProject, List<IFolder>> _sourceOrOutputFolders = new HashMap<IProject, List<IFolder>>();

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspace) {
            ArrayList<IProject> accessibleProjects = new ArrayList<IProject>();
            IProject[] iProjectArray = ((IWorkspace)element).getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    try {
                        this._sourceOrOutputFolders.put(project, JavaHelper.getSourceAndOutputFolders((IJavaProject)JavaCore.create((IProject)project)));
                        accessibleProjects.add(project);
                    }
                    catch (CoreException ce) {
                        EGFCoreUIPlugin.getDefault().logError(ce);
                    }
                }
                ++n2;
            }
            return accessibleProjects.toArray();
        }
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            List<IFolder> folders = this._sourceOrOutputFolders.get(container.getProject());
            if (container.isAccessible() && !this.belongToFolders(folders, (IResource)container)) {
                try {
                    ArrayList<IResource> children = new ArrayList<IResource>();
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IResource member = iResourceArray[n3];
                        if (member.getType() != 1 && !this.belongToFolders(folders, member)) {
                            children.add(member);
                        }
                        ++n3;
                    }
                    return children.toArray();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return new Object[0];
    }

    private boolean belongToFolders(List<IFolder> folders, IResource resource) {
        if (folders == null || folders.size() == 0) {
            return false;
        }
        for (IFolder folder : folders) {
            if (!resource.getFullPath().toOSString().startsWith(folder.getFullPath().toOSString())) continue;
            return true;
        }
        return false;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

