/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.test.common.observerbus;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.A;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.AImpl;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.B;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.BImpl;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.C;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.CImpl;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.DImpl;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.IAppendItem;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.P;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.PImpl;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.QImpl;
import org.eclipse.emf.emfstore.internal.client.test.common.observerbus.assets.RImpl;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverBus;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverCall;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverExceptionListener;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObserverBusTest {
    private ObserverBus observerBus;

    @Test
    public void testUnregister() {
        C observer = new C(){

            public String fourtyTwo() {
                return "42";
            }
        };
        this.getObserverBus().register((ESObserver)observer);
        Assert.assertEquals((Object)"42", (Object)((C)this.getObserverBus().notify(C.class)).fourtyTwo());
        this.getObserverBus().unregister((ESObserver)observer);
        Assert.assertFalse((boolean)"42".equals(((C)this.getObserverBus().notify(C.class)).fourtyTwo()));
    }

    @Test
    public void testSuperUnregister() {
        DImpl d = new DImpl();
        this.getObserverBus().register((ESObserver)d, new Class[]{C.class});
        Assert.assertEquals((Object)"42", (Object)((C)this.getObserverBus().notify(C.class)).fourtyTwo());
        this.getObserverBus().unregister((ESObserver)d);
        Assert.assertFalse((boolean)"42".equals(((C)this.getObserverBus().notify(C.class)).fourtyTwo()));
    }

    @Before
    public void reset() {
        this.observerBus = new ObserverBus();
    }

    private ObserverBus getObserverBus() {
        return this.observerBus;
    }

    @Test
    public void simpleObserverTest() {
        this.getObserverBus().register((ESObserver)new AImpl());
        Assert.assertEquals((long)((A)this.getObserverBus().notify(A.class)).returnTwo(), (long)2L);
    }

    @Test
    public void simpleNoObserverTest() {
        Assert.assertEquals((long)((A)this.getObserverBus().notify(A.class)).returnTwo(), (long)0L);
    }

    @Test
    public void simpleVoidObserverTest() {
        this.getObserverBus().register((ESObserver)new BImpl());
        CImpl tester = new CImpl();
        ((B)this.getObserverBus().notify(B.class)).setMSGToFoo(tester);
        Assert.assertEquals((Object)tester.getMsg(), (Object)"foo");
    }

    @Test
    public void simpleWithTwoObserverTest() {
        this.getObserverBus().register((ESObserver)new AImpl());
        this.getObserverBus().register((ESObserver)new AImpl());
        A observerProxy = (A)this.getObserverBus().notify(A.class);
        Assert.assertEquals((long)observerProxy.returnTwo(), (long)2L);
        List callResults = ((ObserverCall)observerProxy).getObserverCallResults();
        Assert.assertEquals((long)callResults.size(), (long)2L);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(0)).getResult(), (Object)2);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(1)).getResult(), (Object)2);
    }

    @Test
    public void simpleObserverInheritanceTest() {
        this.getObserverBus().register((ESObserver)new AImpl());
        this.getObserverBus().register((ESObserver)new BImpl());
        A observerProxy = (A)this.getObserverBus().notify(A.class);
        Assert.assertEquals((long)observerProxy.returnTwo(), (long)2L);
        List callResults = ((ObserverCall)observerProxy).getObserverCallResults();
        Assert.assertEquals((long)callResults.size(), (long)2L);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(0)).getResult(), (Object)2);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(1)).getResult(), (Object)2);
    }

    @Test
    public void simpleObserverInheritanceAndUnRegAllTest() {
        this.getObserverBus().register((ESObserver)new AImpl());
        BImpl b = new BImpl();
        this.getObserverBus().register((ESObserver)b);
        this.getObserverBus().unregister((ESObserver)b);
        A observerProxy = (A)this.getObserverBus().notify(A.class);
        Assert.assertEquals((long)observerProxy.returnTwo(), (long)2L);
        List callResults = ((ObserverCall)observerProxy).getObserverCallResults();
        Assert.assertEquals((long)callResults.size(), (long)1L);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(0)).getResult(), (Object)2);
    }

    @Test
    public void simpleObserverInheritanceAndUnRegSubTest() {
        this.getObserverBus().register((ESObserver)new AImpl());
        BImpl b = new BImpl();
        this.getObserverBus().register((ESObserver)b);
        this.getObserverBus().unregister((ESObserver)b, new Class[]{B.class});
        A observerProxy = (A)this.getObserverBus().notify(A.class);
        Assert.assertEquals((long)observerProxy.returnTwo(), (long)2L);
        List callResults = ((ObserverCall)observerProxy).getObserverCallResults();
        Assert.assertEquals((long)callResults.size(), (long)2L);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(0)).getResult(), (Object)2);
        Assert.assertEquals((Object)((ObserverCall.Result)callResults.get(1)).getResult(), (Object)2);
    }

    @Test
    public void callObserverException() {
        this.getObserverBus().register((ESObserver)new AImpl());
        this.getObserverBus().register((ESObserver)new BImpl());
        A proxy = (A)this.getObserverBus().notify(A.class);
        proxy.returnFoobarOrException();
        List results = ((ObserverCall)proxy).getObserverCallResults();
        Assert.assertEquals((long)results.size(), (long)2L);
        Assert.assertFalse((boolean)((ObserverCall.Result)results.get(0)).exceptionOccurred());
        Assert.assertTrue((boolean)((ObserverCall.Result)results.get(1)).exceptionOccurred());
    }

    @Test
    public void observerExceptionListener() {
        final LinkedHashMap throwables = new LinkedHashMap();
        this.getObserverBus().registerExceptionListener(new ObserverExceptionListener(){

            public void onException(ESObserver observer, Throwable throwable) {
                if (!throwables.containsKey(observer)) {
                    throwables.put(observer, new ArrayList());
                }
                ((List)throwables.get(observer)).add(throwable);
            }
        });
        this.getObserverBus().register((ESObserver)new AImpl());
        BImpl bImpl = new BImpl();
        this.getObserverBus().register((ESObserver)bImpl);
        A proxy = (A)this.getObserverBus().notify(A.class);
        proxy.returnFoobarOrException();
        List results = ((ObserverCall)proxy).getObserverCallResults();
        Assert.assertEquals((long)results.size(), (long)2L);
        Assert.assertFalse((boolean)((ObserverCall.Result)results.get(0)).exceptionOccurred());
        Assert.assertTrue((boolean)((ObserverCall.Result)results.get(1)).exceptionOccurred());
        Assert.assertEquals((long)1L, (long)throwables.size());
        Assert.assertTrue((boolean)throwables.containsKey(bImpl));
        Assert.assertEquals((long)1L, (long)((List)throwables.get(bImpl)).size());
    }

    @Test
    public void registerMultipleCallOne() {
        this.getObserverBus().register((ESObserver)new AImpl());
        this.getObserverBus().register((ESObserver)new BImpl());
        this.getObserverBus().register((ESObserver)new CImpl());
        ((C)this.getObserverBus().notify(C.class)).fourtyTwo();
    }

    @Test
    public void registerForOneInterfaceTest() {
        this.getObserverBus().register((ESObserver)new BImpl(), new Class[]{B.class});
        A a = (A)this.getObserverBus().notify(A.class);
        B b = (B)this.getObserverBus().notify(B.class);
        a.returnTwo();
        Assert.assertTrue((((ObserverCall)a).getObserverCallResults().size() == 0 ? 1 : 0) != 0);
        b.returnTwo();
        Assert.assertTrue((((ObserverCall)b).getObserverCallResults().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void prioritizedNotify() {
        PImpl p = new PImpl();
        QImpl q = new QImpl();
        this.getObserverBus().register((ESObserver)p);
        this.getObserverBus().register((ESObserver)q);
        ArrayList<String> items = new ArrayList<String>();
        ((P)this.getObserverBus().notify(P.class, true)).appendItem(items);
        Assert.assertEquals(items.get(0), (Object)"P");
        Assert.assertEquals(items.get(1), (Object)"Q");
    }

    @Test
    public void prioritizedNotifyWithMixedObserver() {
        PImpl p = new PImpl();
        QImpl q = new QImpl();
        RImpl r = new RImpl();
        this.getObserverBus().register((ESObserver)p);
        this.getObserverBus().register((ESObserver)q);
        this.getObserverBus().register((ESObserver)r);
        ArrayList<String> items = new ArrayList<String>();
        ((IAppendItem)this.getObserverBus().notify(IAppendItem.class, true)).appendItem(items);
        Assert.assertEquals(items.get(0), (Object)"P");
        Assert.assertEquals(items.get(1), (Object)"Q");
        Assert.assertEquals(items.get(2), (Object)"R");
    }

    public String fourtyTwo() {
        return "42";
    }
}

