/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager;

import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.sessionprovider.ESAbstractSessionProvider;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.BasicSessionProvider;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerCallImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESUsersessionImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.ESRunnableWrapperProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.internal.server.exceptions.UnknownSessionException;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager {
    private static final String CLASS = "class";
    private static final String PRIORITY = "priority";
    private static final String ORG_ECLIPSE_EMF_EMFSTORE_CLIENT_USERSESSION_PROVIDER = "org.eclipse.emf.emfstore.client.usersessionProvider";
    private static final String USERSESSION_MUST_NOT_BE_NULL = "Usersession must not be null.";
    private ESAbstractSessionProvider provider;

    public SessionManager() {
        this.initSessionProvider();
    }

    public <T> void execute(ServerCall<T> serverCall) throws ESException {
        ESUsersessionImpl session = (ESUsersessionImpl)this.getSessionProvider().provideUsersession(new ESServerCallImpl<T>(serverCall));
        serverCall.setUsersession((Usersession)session.toInternalAPI());
        Usersession loggedInSession = this.loginUsersession((Usersession)session.toInternalAPI(), false);
        this.executeCall(serverCall, loggedInSession, true);
    }

    private Usersession loginUsersession(final Usersession usersession, boolean forceLogin) throws ESException {
        if (usersession == null) {
            throw new RuntimeException(USERSESSION_MUST_NOT_BE_NULL);
        }
        if (!this.isLoggedIn(usersession) || forceLogin) {
            if (usersession.getUsername() != null && !usersession.getUsername().equals("") && usersession.getPassword() != null) {
                try {
                    RunESCommand.WithException.run(ESException.class, new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            usersession.logIn();
                            return null;
                        }
                    });
                    return usersession;
                }
                catch (ESException eSException) {}
            }
            ESUsersession session = RunESCommand.WithException.runWithResult(ESException.class, new Callable<ESUsersession>(){

                @Override
                public ESUsersession call() throws Exception {
                    return SessionManager.this.getSessionProvider().login((ESUsersession)usersession.toAPI());
                }
            });
            return (Usersession)((ESUsersessionImpl)session).toInternalAPI();
        }
        ESRunnableWrapperProvider.getInstance().embedInContext(new Runnable(){

            public void run() {
                RunESCommand.run(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            usersession.logIn();
                        }
                        catch (AccessControlException ex) {
                            WorkspaceUtil.logException(ex.getMessage(), (Exception)((Object)ex));
                        }
                        catch (ESException ex) {
                            WorkspaceUtil.logException(ex.getMessage(), (Exception)((Object)ex));
                        }
                        return null;
                    }
                });
            }
        }).run();
        return usersession;
    }

    private boolean isLoggedIn(Usersession usersession) {
        ConnectionManager connectionManager = ESWorkspaceProviderImpl.getInstance().getConnectionManager();
        return usersession.isLoggedIn() && connectionManager.isLoggedIn(usersession.getSessionId());
    }

    private void executeCall(ServerCall<?> serverCall, Usersession usersession, boolean retry) throws ESException {
        try {
            serverCall.run(usersession.getSessionId());
        }
        catch (ESException e) {
            if (retry && (e instanceof SessionTimedOutException || e instanceof UnknownSessionException)) {
                Usersession loginUsersession = this.loginUsersession(usersession, true);
                this.executeCall(serverCall, loginUsersession, false);
            }
            throw e;
        }
    }

    public void setSessionProvider(ESAbstractSessionProvider sessionProvider) {
        this.provider = sessionProvider;
    }

    public ESAbstractSessionProvider getSessionProvider() {
        return this.provider;
    }

    private void initSessionProvider() {
        ESExtensionPoint extensionPoint = new ESExtensionPoint(ORG_ECLIPSE_EMF_EMFSTORE_CLIENT_USERSESSION_PROVIDER);
        if (extensionPoint.getExtensionElements().size() > 0) {
            ESExtensionElement highestExtension = SessionManager.analyseUsersessionExtensionPoint(extensionPoint);
            ESAbstractSessionProvider sessionProvider = (ESAbstractSessionProvider)highestExtension.getClass(CLASS, ESAbstractSessionProvider.class);
            if (sessionProvider != null) {
                this.provider = sessionProvider;
            }
        } else {
            this.provider = new BasicSessionProvider();
        }
    }

    public static ESExtensionElement analyseUsersessionExtensionPoint(ESExtensionPoint extensionPoint) {
        int highestPrio = -1;
        ESExtensionElement highestExtension = null;
        for (ESExtensionElement esExtensionElement : extensionPoint.getExtensionElements()) {
            Integer prio = esExtensionElement.getInteger(PRIORITY);
            if (prio == null) {
                prio = 0;
            }
            if (prio <= highestPrio) continue;
            highestPrio = prio;
            highestExtension = esExtensionElement;
        }
        return highestExtension;
    }
}

