/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.startup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.startup.ProjectAndChangePackageRule;
import org.eclipse.emf.emfstore.internal.client.startup.ProjectSpaceRule;
import org.eclipse.emf.emfstore.internal.client.startup.UsersessionRule;
import org.eclipse.emf.emfstore.internal.client.startup.WorkspaceRule;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.startup.ServerHrefMigrator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientHrefMigrator
extends ServerHrefMigrator {
    private File backup;

    public boolean migrate() {
        String sEMFStoreClient = Configuration.getFileInfo().getWorkspaceDirectory();
        if (this.isMigrationNeeded(String.valueOf(sEMFStoreClient) + "workspace.ucw")) {
            if (this.backup != null) {
                return false;
            }
            try {
                this.backup = this.createBackup(Configuration.getFileInfo().getWorkspaceDirectory(), String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + "../backup" + System.currentTimeMillis());
            }
            catch (IOException ex) {
                ModelUtil.logException((String)"Error during the backup creation.", (Throwable)ex);
                return false;
            }
            try {
                this.doMigrate(sEMFStoreClient);
                return true;
            }
            catch (InvocationTargetException ex) {
                ModelUtil.logException((String)"Error during the migration process.", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private boolean isMigrationNeeded(String pathToFile) {
        String toMatch;
        block7: {
            toMatch = this.getHrefAttribute(pathToFile, "projectSpaces");
            if (toMatch != null) break block7;
            return false;
        }
        try {
            return toMatch.contains("projectspace.esp");
        }
        catch (ParserConfigurationException ex) {
            ModelUtil.logException((String)"Cannot determine whether migration is needed. Migration will be skipped, backup will be created.", (Throwable)ex);
        }
        catch (SAXException ex) {
            ModelUtil.logException((String)"Cannot determine whether migration is needed. Migration will be skipped, backup will be created.", (Throwable)ex);
        }
        catch (IOException ex) {
            ModelUtil.logException((String)"Cannot determine whether migration is needed. Migration will be skipped, backup will be created.", (Throwable)ex);
        }
        try {
            this.backup = this.createBackup(Configuration.getFileInfo().getWorkspaceDirectory(), String.valueOf(Configuration.getFileInfo().getWorkspaceDirectory()) + "../backup" + System.currentTimeMillis());
        }
        catch (IOException ex) {
            this.backup = new File("");
            ModelUtil.logException((String)"Creating the backup failed.", (Throwable)ex);
        }
        return true;
    }

    private void doMigrate(String sEMFStoreClient) throws InvocationTargetException {
        File[] projectSpaces;
        this.migrateContainmentHRefs(String.valueOf(sEMFStoreClient) + "workspace.ucw", "projectSpaces", new ProjectSpaceRule());
        File fEMFStoreClient = new File(sEMFStoreClient);
        File[] fileArray = projectSpaces = fEMFStoreClient.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("ps-");
            }
        });
        int n = projectSpaces.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String pS = String.valueOf(f.getAbsolutePath()) + "/projectspace.esp";
            this.migrateContainmentHRefs(pS, "project", new ProjectAndChangePackageRule());
            this.migrateContainmentHRefs(pS, "localChangePackage", new ProjectAndChangePackageRule());
            this.migrateNonContainment(pS, "workspace", new WorkspaceRule());
            this.migrateNonContainment(pS, "usersession", new UsersessionRule());
            ++n2;
        }
    }

    private String getHrefAttribute(String pathToFile, String tagName) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(pathToFile).toURI().toString());
        NodeList tagElements = doc.getElementsByTagName(tagName);
        if (tagElements.getLength() > 0) {
            Node pS = tagElements.item(0);
            NamedNodeMap attr = pS.getAttributes();
            Node nodeAttr = attr.getNamedItem("href");
            String hrefOld = nodeAttr.getTextContent();
            return hrefOld;
        }
        return null;
    }
}

