/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.AdminEmfStore;
import org.eclipse.emf.emfstore.server.CleanMemoryTask;
import org.eclipse.emf.emfstore.server.EmfStore;
import org.eclipse.emf.emfstore.server.EmfStoreInterface;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.accesscontrol.AccessControlImpl;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.connection.ConnectionHandler;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.XmlRpcAdminConnectionHander;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.XmlRpcConnectionHandler;
import org.eclipse.emf.emfstore.server.core.AdminEmfStoreImpl;
import org.eclipse.emf.emfstore.server.core.EmfStoreImpl;
import org.eclipse.emf.emfstore.server.core.helper.HistoryCache;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.model.ModelFactory;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ServerSpace;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.server.model.accesscontrol.roles.RolesFactory;
import org.eclipse.emf.emfstore.server.startup.EmfStoreValidator;
import org.eclipse.emf.emfstore.server.startup.ExtensionManager;
import org.eclipse.emf.emfstore.server.startup.MigrationManager;
import org.eclipse.emf.emfstore.server.storage.ResourceStorage;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfStoreController
implements IApplication,
Runnable {
    private EmfStore emfStore;
    private AdminEmfStore adminEmfStore;
    private AccessControlImpl accessControl;
    private Set<ConnectionHandler<? extends EmfStoreInterface>> connectionHandlers;
    private Properties properties;
    private ServerSpace serverSpace;
    private Resource resource;
    private static EmfStoreController instance;
    private HistoryCache historyCache;
    private static final int CLEAN_MEMORY_TASK_PERIOD = 60;

    public Object start(IApplicationContext context) throws FatalEmfStoreException {
        this.run(true);
        instance = null;
        ModelUtil.logInfo((String)"Server is STOPPED.");
        return IApplication.EXIT_OK;
    }

    public void run(boolean waitForTermination) throws FatalEmfStoreException {
        if (instance != null) {
            throw new FatalEmfStoreException("Another EmfStore Controller seems to be running already!");
        }
        instance = this;
        this.serverHeader();
        this.initLogging();
        this.copyFileToWorkspace(ServerConfiguration.getConfFile(), "es.properties", "Couldn't copy es.properties file to config folder.", "Default es.properties file was copied to config folder.");
        this.properties = this.initProperties();
        new MigrationManager().migrateModel();
        this.serverSpace = this.initServerSpace();
        this.handleStartupListener();
        this.historyCache = this.initHistoryCache();
        this.accessControl = this.initAccessControl(this.serverSpace);
        this.emfStore = new EmfStoreImpl(this.serverSpace, this.accessControl);
        this.adminEmfStore = new AdminEmfStoreImpl(this.serverSpace, this.accessControl);
        this.copyFileToWorkspace(ServerConfiguration.getServerKeyStorePath(), "emfstoreServer.keystore", "Failed to copy keystore.", "Keystore was copied to server workspace.");
        this.connectionHandlers = this.initConnectionHandlers();
        if (Boolean.parseBoolean(ServerConfiguration.getProperties().getProperty("emfstore.cleanmemorytask", "true"))) {
            new Timer().schedule((TimerTask)new CleanMemoryTask(this.serverSpace.eResource().getResourceSet()), 60000L, 60000L);
        }
        this.handlePostStartupListener();
        ModelUtil.logInfo((String)"Initialitation COMPLETE.");
        ModelUtil.logInfo((String)"Server is RUNNING...");
        if (waitForTermination) {
            this.waitForTermination();
        }
    }

    private void initLogging() {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.emf.emfstore.common.model")).addLogListener(new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (status.getSeverity() == 1) {
                    System.out.println(status.getMessage());
                } else if (!status.isOK()) {
                    System.err.println(status.getMessage());
                    Throwable exception = status.getException();
                    if (exception != null) {
                        exception.printStackTrace(System.err);
                    }
                }
            }
        });
    }

    private void handleStartupListener() {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.startup.loadlistener", "true");
        if ("true".equals(property)) {
            ModelUtil.logInfo((String)"Notifying startup listener");
            ExtensionManager.notifyStartupListener((EList<ProjectHistory>)this.serverSpace.getProjects());
        }
    }

    private void handlePostStartupListener() {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.startup.post.loadlistener", "true");
        if ("true".equals(property)) {
            ModelUtil.logInfo((String)"Notifying post startup listener");
            ExtensionManager.notifyPostStartupListener(this.serverSpace, this.accessControl, this.connectionHandlers);
        }
    }

    private void copyFileToWorkspace(String target, String source, String failure, String success) {
        File keyStore = new File(target);
        if (!keyStore.exists()) {
            try {
                FileUtil.copyFile((InputStream)this.getClass().getResourceAsStream(source), (File)keyStore);
            }
            catch (IOException e) {
                ModelUtil.logWarning((String)("Copy of file from " + source + " to " + target + " failed"), (Throwable)e);
            }
        }
    }

    private HistoryCache initHistoryCache() {
        HistoryCache cache = new HistoryCache();
        cache.initCache((List<ProjectHistory>)this.serverSpace.getProjects());
        ModelUtil.logInfo((String)"History cache has been initialized.");
        return cache;
    }

    private Set<ConnectionHandler<? extends EmfStoreInterface>> initConnectionHandlers() throws FatalEmfStoreException {
        HashSet<ConnectionHandler<? extends EmfStoreInterface>> connectionHandlers = new HashSet<ConnectionHandler<? extends EmfStoreInterface>>();
        XmlRpcConnectionHandler xmlRpcConnectionHander = new XmlRpcConnectionHandler();
        xmlRpcConnectionHander.init(this.emfStore, (AuthenticationControl)this.accessControl);
        connectionHandlers.add(xmlRpcConnectionHander);
        XmlRpcAdminConnectionHander xmlRpcAdminConnectionHander = new XmlRpcAdminConnectionHander();
        xmlRpcAdminConnectionHander.init(this.adminEmfStore, (AuthenticationControl)this.accessControl);
        connectionHandlers.add(xmlRpcAdminConnectionHander);
        return connectionHandlers;
    }

    public HistoryCache getHistoryCache() {
        return this.historyCache;
    }

    private ServerSpace initServerSpace() throws FatalEmfStoreException {
        ResourceStorage storage = this.initStorage();
        URI resourceUri = storage.init(this.properties);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        resourceSet.getLoadOptions().putAll(ModelUtil.getResourceLoadOptions());
        this.resource = resourceSet.createResource(resourceUri);
        try {
            this.resource.load(ModelUtil.getResourceLoadOptions());
            if (this.properties.getProperty("emfstore.validation", "true").equals("true")) {
                ModelUtil.logInfo((String)"Validating serverspace ...");
                this.validateServerSpace(this.resource);
                ModelUtil.logInfo((String)"Validation complete.");
            }
        }
        catch (IOException e) {
            throw new FatalEmfStoreException("Couldn't load data from database.", e);
        }
        ServerSpace result = null;
        EList contents = this.resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof ServerSpace)) continue;
            result = (ServerSpace)content;
            break;
        }
        if (result != null) {
            result.setResource(this.resource);
        } else {
            ModelUtil.logInfo((String)"Creating initial server space...");
            result = ModelFactory.eINSTANCE.createServerSpace();
            result.setResource(this.resource);
            this.resource.getContents().add((Object)result);
            try {
                result.save();
            }
            catch (IOException e) {
                throw new FatalEmfStoreException("Couldn't save data in database.", e);
            }
        }
        return result;
    }

    private void validateServerSpace(Resource resource) throws FatalEmfStoreException {
        EList contents = resource.getContents();
        for (EObject object : contents) {
            if (!(object instanceof ServerSpace)) continue;
            EmfStoreValidator emfStoreValidator = new EmfStoreValidator((ServerSpace)object);
            String[] excludedProjects = ServerConfiguration.getSplittedProperty("emfstore.validation.exclude", "");
            emfStoreValidator.setExcludedProjects(Arrays.asList(excludedProjects));
            try {
                String level = ServerConfiguration.getProperties().getProperty("emfstore.validation.level", "7");
                emfStoreValidator.validate(Integer.parseInt(level));
            }
            catch (NumberFormatException e) {
                emfStoreValidator.validate(Integer.parseInt("7"));
            }
        }
    }

    public static EmfStoreController getInstance() {
        return instance;
    }

    private ResourceStorage initStorage() throws FatalEmfStoreException {
        String className = this.properties.getProperty("emfstore.persistence.resourceStorage", "org.eclipse.emf.emfstore.server.storage.XMLStorage");
        String failMessage = "Failed loading ressource storage!";
        try {
            ModelUtil.logInfo((String)("Using RessourceStorage \"" + className + "\"."));
            ResourceStorage resourceStorage = (ResourceStorage)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            return resourceStorage;
        }
        catch (IllegalArgumentException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
        catch (SecurityException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
        catch (InstantiationException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
        catch (IllegalAccessException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
        catch (InvocationTargetException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
        catch (NoSuchMethodException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
        catch (ClassNotFoundException e) {
            ModelUtil.logException((String)"Failed loading ressource storage!", (Throwable)e);
            throw new FatalEmfStoreException("Failed loading ressource storage!", e);
        }
    }

    private AccessControlImpl initAccessControl(ServerSpace serverSpace) throws FatalEmfStoreException {
        this.setSuperUser(serverSpace);
        return new AccessControlImpl(serverSpace);
    }

    private void setSuperUser(ServerSpace serverSpace) throws FatalEmfStoreException {
        String superuser = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.superuser", "super");
        for (ACUser user : serverSpace.getUsers()) {
            if (!user.getName().equals(superuser)) continue;
            return;
        }
        ACUser superUser = AccesscontrolFactory.eINSTANCE.createACUser();
        superUser.setName(superuser);
        superUser.setFirstName("super");
        superUser.setLastName("user");
        superUser.setDescription("default server admin (superuser)");
        superUser.getRoles().add((Object)RolesFactory.eINSTANCE.createServerAdmin());
        serverSpace.getUsers().add((Object)superUser);
        try {
            serverSpace.save();
        }
        catch (IOException e) {
            throw new FatalEmfStoreException("Couldn't save data in database.", e);
        }
        ModelUtil.logInfo((String)("added superuser " + superuser));
    }

    private Properties initProperties() {
        File propertyFile = new File(ServerConfiguration.getConfFile());
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propertyFile);
            properties.load(fis);
            ServerConfiguration.setProperties(properties);
            fis.close();
            ModelUtil.logInfo((String)("Property file read. (" + propertyFile.getAbsolutePath() + ")"));
        }
        catch (IOException e) {
            ModelUtil.logWarning((String)"Property initialization failed, using default properties.", (Throwable)e);
        }
        return properties;
    }

    public void stop() {
        this.wakeForTermination();
        for (ConnectionHandler<? extends EmfStoreInterface> handler : this.connectionHandlers) {
            handler.stop(false);
        }
        ModelUtil.logInfo((String)"Server was stopped.");
        instance = null;
        this.wakeForTermination();
    }

    public void shutdown(FatalEmfStoreException exception) {
        ModelUtil.logWarning((String)"Stopping all connection handlers...");
        for (ConnectionHandler<? extends EmfStoreInterface> handler : this.connectionHandlers) {
            ModelUtil.logWarning((String)("Stopping connection handler \"" + handler.getName() + "\"."));
            handler.stop(true);
            ModelUtil.logWarning((String)("Connection handler \"" + handler.getName() + "\" stopped."));
        }
        ModelUtil.logException((String)"Server was forcefully stopped.", (Throwable)exception);
        ModelUtil.logException((String)"Cause for server shutdown: ", (Throwable)exception.getCause());
        this.wakeForTermination();
    }

    private synchronized void waitForTermination() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            ModelUtil.logWarning((String)"Waiting for termination was interrupted", (Throwable)e);
        }
    }

    private synchronized void wakeForTermination() {
        this.notify();
    }

    private void serverHeader() {
        InputStream inputStream = this.getClass().getResourceAsStream("emfstore.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("*----------*");
        System.out.println("| EmfStore |");
        System.out.println("*----------*");
    }

    @Override
    public void run() {
        try {
            this.run(false);
        }
        catch (FatalEmfStoreException e) {
            e.printStackTrace();
        }
    }

    public static void runAsNewThread() throws FatalEmfStoreException {
        Thread thread = new Thread(new EmfStoreController());
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

