/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.observer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.common.observer.ObserverCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverBus {
    private static ObserverBus instance;
    private HashMap<Class<? extends IObserver>, List<IObserver>> observerMap = new HashMap();

    public static ObserverBus getInstance() {
        if (instance == null) {
            instance = new ObserverBus();
        }
        return instance;
    }

    public ObserverBus() {
        this.collectionExtensionPoints();
    }

    public <T extends IObserver> T notify(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.createProxy(clazz);
    }

    public void register(IObserver observer) {
        this.register(observer, this.getObserverInterfaces(observer));
    }

    public void register(IObserver observer, Class<? extends IObserver> ... classes) {
        Class<? extends IObserver>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IObserver> iface = classArray[n2];
            if (iface.isInstance(observer)) {
                this.addObserver(observer, iface);
            }
            ++n2;
        }
    }

    public void unregister(IObserver observer) {
        this.unregister(observer, this.getObserverInterfaces(observer));
    }

    public void unregister(IObserver observer, Class<? extends IObserver> ... classes) {
        Class<? extends IObserver>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IObserver> iface = classArray[n2];
            if (iface.isInstance(observer)) {
                this.removeObserver(observer, iface);
            }
            ++n2;
        }
    }

    private void addObserver(IObserver observer, Class<? extends IObserver> iface) {
        List<IObserver> observers = this.initObserverList(iface);
        observers.add(observer);
    }

    private void removeObserver(IObserver observer, Class<? extends IObserver> iface) {
        List<IObserver> observers = this.initObserverList(iface);
        observers.remove(observer);
    }

    private List<IObserver> initObserverList(Class<? extends IObserver> iface) {
        List<IObserver> list = this.observerMap.get(iface);
        if (list == null) {
            list = new ArrayList<IObserver>();
            this.observerMap.put(iface, list);
        }
        return list;
    }

    private List<IObserver> getObserverByClass(Class<IObserver> clazz) {
        List<IObserver> list = this.observerMap.get(clazz);
        if (list == null) {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    private <T extends IObserver> T createProxy(Class<T> clazz) {
        ProxyHandler handler = new ProxyHandler(clazz);
        return (T)((IObserver)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, ObserverCall.class}, (InvocationHandler)handler));
    }

    private Class<? extends IObserver>[] getObserverInterfaces(IObserver observer) {
        HashSet<Class<? extends IObserver>> result = new HashSet<Class<? extends IObserver>>();
        this.getClasses(observer.getClass(), result);
        return result.toArray(new Class[result.size()]);
    }

    private boolean getClasses(Class<?> clazz, HashSet<Class<? extends IObserver>> result) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (iface.equals(IObserver.class) && clazz.isInterface()) {
                result.add(clazz);
                return true;
            }
            if (this.getClasses(iface, result) && clazz.isInterface()) {
                result.add(clazz);
            }
            ++n2;
        }
        return false;
    }

    public void collectionExtensionPoints() {
        for (ExtensionElement outer : new ExtensionPoint("org.eclipse.emf.emfstore.common.observer", true).getExtensionElements()) {
            try {
                for (ExtensionElement inner : new ExtensionPoint(outer.getAttribute("extensionPointName"), true).getExtensionElements()) {
                    this.register(inner.getClass(outer.getAttribute("observerAttributeName"), IObserver.class));
                }
            }
            catch (ExtensionPointException extensionPointException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProxyHandler
    implements InvocationHandler,
    ObserverCall {
        private Class<IObserver> clazz;
        private List<ObserverCall.Result> lastResults;

        public ProxyHandler(Class<IObserver> clazz) {
            this.clazz = clazz;
            this.lastResults = new ArrayList<ObserverCall.Result>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ObserverCall.class.equals(method.getDeclaringClass())) {
                return this.accessObserverCall(method, args);
            }
            List observers = ObserverBus.this.getObserverByClass(this.clazz);
            if (observers.size() == 0) {
                this.lastResults = new ArrayList<ObserverCall.Result>();
                return ObserverCall.Result.getDefaultValue(method);
            }
            this.lastResults = this.notifiyObservers(observers, method, args);
            return this.lastResults.get(0).getResultOrDefaultValue();
        }

        private Object accessObserverCall(Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return method.invoke((Object)this, args);
        }

        private List<ObserverCall.Result> notifiyObservers(List<IObserver> observers, Method method, Object[] args) {
            ArrayList<ObserverCall.Result> results = new ArrayList<ObserverCall.Result>(observers.size());
            for (IObserver observer : observers) {
                try {
                    results.add(new ObserverCall.Result(observer, method, method.invoke((Object)observer, args)));
                }
                catch (Throwable e) {
                    results.add(new ObserverCall.Result(observer, e, method));
                }
            }
            return results;
        }

        @Override
        public List<ObserverCall.Result> getObserverCallResults() {
            return this.lastResults;
        }
    }
}

