/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.exceptions.InvalidHandleException;
import org.eclipse.emf.emfstore.client.model.impl.OperationRecorder;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.semantic.SemanticCompositeOperation;

public class CompositeOperationHandle {
    private boolean isValid;
    private CompositeOperation compositeOperation;
    private OperationRecorder operationRecorder;
    private Set<EObject> removedElements;

    public CompositeOperationHandle(OperationRecorder operationRecorder, CompositeOperation compositeOperation) {
        this.operationRecorder = operationRecorder;
        this.removedElements = new HashSet<EObject>();
        this.removedElements.addAll(operationRecorder.getRemovedElements());
        this.compositeOperation = compositeOperation;
        this.isValid = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void abort() throws InvalidHandleException {
        this.checkAndCloseHandle();
        this.operationRecorder.getRemovedElements().retainAll(this.removedElements);
        this.operationRecorder.abortCompositeOperation();
        this.dropAllReferences();
    }

    private void dropAllReferences() {
        this.compositeOperation = null;
        this.operationRecorder = null;
        this.removedElements = null;
    }

    private void checkAndCloseHandle() throws InvalidHandleException {
        if (!this.isValid) {
            throw new InvalidHandleException();
        }
        this.isValid = false;
    }

    public void end(String name, String description, ModelElementId modelElementId) throws InvalidHandleException {
        this.checkAndCloseHandle();
        this.compositeOperation.setCompositeName(name);
        this.compositeOperation.setCompositeDescription(description);
        this.compositeOperation.setClientDate(new Date());
        this.compositeOperation.setReversed(false);
        this.compositeOperation.setModelElementId(modelElementId);
        this.operationRecorder.endCompositeOperation();
        this.dropAllReferences();
    }

    public void end(SemanticCompositeOperation semanticCompositeOperation) throws InvalidHandleException {
        this.checkAndCloseHandle();
        semanticCompositeOperation.setClientDate(new Date());
        semanticCompositeOperation.setReversed(false);
        semanticCompositeOperation.getSubOperations().addAll((Collection)this.compositeOperation.getSubOperations());
        this.operationRecorder.endCompositeOperation(semanticCompositeOperation);
    }
}

