/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.changeTracking.notification;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.NotificationInfo;

final class NotificationValidator {
    private static NotificationValidator instance;

    public static NotificationValidator getInstance() {
        if (instance == null) {
            instance = new NotificationValidator();
        }
        return instance;
    }

    private NotificationValidator() {
    }

    protected void validate(NotificationInfo n) {
        if (n == null) {
            throw new IllegalArgumentException("NotificationInfo argument cannot be null");
        }
        n.setValid(true);
        n.setValidationMessage("OK");
        if (n.isTouch() || n.isTransient()) {
            return;
        }
        switch (n.getEventType()) {
            case 1: {
                this.handleSetNotification(n);
                break;
            }
            case 3: {
                this.handleAddNotification(n);
                break;
            }
            case 4: {
                this.handleRemoveNotification(n);
                break;
            }
            case 5: {
                this.handleAddManyNotification(n);
                break;
            }
            case 6: {
                this.handleRemoveManyNotification(n);
                break;
            }
            case 2: {
                this.handleUnsetNotification(n);
                break;
            }
            case 7: {
                this.handleMoveNotification(n);
                break;
            }
            default: {
                this.handleUnknownNotification(n);
            }
        }
    }

    private void handleUnknownNotification(NotificationInfo n) {
        n.setValid(false);
        n.setValidationMessage("Error: unknown notification event type. " + n.toString());
    }

    private void handleMoveNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (n.getNewValue() == null || n.getOldValue() == null) {
                n.setValid(false);
                n.setValidationMessage("Null detected in oldValue or NewValue of move notification about: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
            if (!(n.getNewValue() instanceof EObject)) {
                n.setValid(false);
                n.setValidationMessage("Non-transient non-EObject reference feature detected: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
            if (!(n.getOldValue() instanceof Integer)) {
                n.setValid(false);
                n.setValidationMessage("Error with old position in move: not an Integer");
                return;
            }
        }
    }

    private void handleUnsetNotification(NotificationInfo n) {
        n.setValid(false);
        n.setValidationMessage("Cannot handle UNSET notifications");
    }

    private void handleRemoveManyNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getOldValue() instanceof List)) {
                n.setValid(false);
                n.setValidationMessage("Non-List oldValue argument for REMOVE_MANY notification on: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage("Unkown notification state: REMOVE_MANY notification on reference feature with isMany==false");
                return;
            }
        }
    }

    private void handleAddManyNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getNewValue() instanceof List)) {
                n.setValid(false);
                n.setValidationMessage("Non-List newValue argument for ADD_MANY notification on: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage("Unkown notification state: ADD_MANY notification on reference feature with isMany==false");
                return;
            }
        }
    }

    private void handleRemoveNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getOldValue() instanceof EObject)) {
                n.setValid(false);
                n.setValidationMessage("Non-transient non-EObject reference feature detected: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage("Unkown notification state: REMOVE notification on reference feature with isMany==false");
            }
        }
    }

    private void handleAddNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            if (!(n.getNewValue() instanceof EObject)) {
                n.setValid(false);
                n.setValidationMessage("Non-transient non-EObject reference feature detected: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
            if (!n.getReference().isMany()) {
                n.setValid(false);
                n.setValidationMessage("Unkown notification state: ADD notification on reference feature with isMany==false");
            }
        }
    }

    private void handleSetNotification(NotificationInfo n) {
        if (n.isReferenceNotification()) {
            boolean oldValIsNoME;
            Object newValueObject = n.getNewValue();
            Object oldValueObject = n.getOldValue();
            boolean newValIsNoME = newValueObject != null && !(newValueObject instanceof EObject);
            boolean bl = oldValIsNoME = oldValueObject != null && !(oldValueObject instanceof EObject);
            if (newValIsNoME || oldValIsNoME) {
                n.setValid(false);
                n.setValidationMessage("Non-transient non-EObject reference feature detected: " + n.getNotifier().getClass().getCanonicalName() + "-" + n.getReference().getName());
                return;
            }
        }
    }
}

