/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.importexport.ExportImportDataUnits;
import org.eclipse.emf.emfstore.client.model.importexport.IExportImportController;

public class ImportProjectController
implements IExportImportController {
    private final String projectName;

    public ImportProjectController(String projectName) {
        this.projectName = projectName;
    }

    public String getLabel() {
        return "project";
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore project space (*" + ExportImportDataUnits.Project.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Project.getExtension(), "*.*"};
    }

    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.importProjectPath";
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        Workspace currentWorkspace = WorkspaceManager.getInstance().getCurrentWorkspace();
        ProjectSpace projectSpace = currentWorkspace.importProject(file.getAbsolutePath());
        projectSpace.setProjectName(this.projectName);
        projectSpace.eResource().save(null);
    }

    public String getFilename() {
        return null;
    }

    public boolean isExport() {
        return false;
    }
}

