/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.Attribute;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreatorImpl;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.QName;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeIterator
implements Iterator<Attribute> {
    private final Element element;
    private final ElementMetadata<?, ?> metadata;
    private Iterator<AttributeKey<?>> metadataIterator;
    private Iterator<Map.Entry<QName, Attribute>> attributeIterator;
    private Attribute nextAttribute;
    private Mode mode = Mode.DECLARED;

    AttributeIterator(Element element, ElementMetadata<?, ?> metadata, Map<QName, Attribute> attributes) {
        this.element = element;
        this.metadata = metadata;
        this.metadataIterator = metadata == null ? null : metadata.getAttributes().iterator();
        this.attributeIterator = attributes == null ? null : attributes.entrySet().iterator();
        this.nextAttribute = this.findNextAttribute();
    }

    @Override
    public boolean hasNext() {
        return this.nextAttribute != null;
    }

    @Override
    public Attribute next() {
        if (this.nextAttribute == null) {
            throw new NoSuchElementException("No remaining attributes");
        }
        Attribute retVal = this.nextAttribute;
        this.nextAttribute = this.findNextAttribute();
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal not supported on attribute iterator");
    }

    private Attribute findNextAttribute() {
        Attribute next = null;
        block4: while (next == null && this.mode != Mode.DONE) {
            switch (this.mode) {
                case DECLARED: {
                    next = this.findNextDeclaredAttribute();
                    continue block4;
                }
                case UNDECLARED: {
                    next = this.findNextUndeclaredAttribute();
                    continue block4;
                }
            }
        }
        return next;
    }

    private Attribute findNextDeclaredAttribute() {
        if (this.metadataIterator != null) {
            while (this.metadataIterator.hasNext()) {
                Object value;
                AttributeKey<?> nextKey = this.metadataIterator.next();
                if (ElementCreatorImpl.ATTRIBUTE_MARKER == nextKey) {
                    this.mode = Mode.UNDECLARED;
                    return null;
                }
                AttributeMetadata<?> attMeta = this.metadata.bindAttribute(nextKey);
                if (!attMeta.isVisible() || (value = attMeta.generateValue(this.element, this.metadata)) == null) continue;
                return new Attribute(nextKey, value);
            }
            this.metadataIterator = null;
        }
        this.mode = Mode.UNDECLARED;
        return null;
    }

    private Attribute findNextUndeclaredAttribute() {
        if (this.attributeIterator != null) {
            while (this.attributeIterator.hasNext()) {
                Map.Entry<QName, Attribute> entry = this.attributeIterator.next();
                Attribute attribute = entry.getValue();
                if (!this.isUndeclared(attribute.getAttributeKey())) continue;
                return entry.getValue();
            }
            this.attributeIterator = null;
        }
        this.mode = this.metadataIterator != null && this.metadataIterator.hasNext() ? Mode.DECLARED : Mode.DONE;
        return null;
    }

    private boolean isUndeclared(AttributeKey<?> key) {
        return this.metadata == null || !this.metadata.isDeclared(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        DECLARED,
        UNDECLARED,
        DONE;

    }
}

