/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.gdata.model.AttributeCreatorImpl;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.AttributeMetadataRegistryBuilder;
import com.google.gdata.model.AttributeTransform;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.Schema;
import com.google.gdata.model.TransformKey;
import com.google.gdata.util.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributeMetadataRegistry {
    private final Schema schema;
    private final Map<TransformKey, AttributeTransform> transforms;
    private final ConcurrentMap<TransformKey, AttributeMetadata<?>> cache = new MapMaker().makeMap();

    AttributeMetadataRegistry(Schema schema, AttributeMetadataRegistryBuilder builder) {
        this.schema = schema;
        this.transforms = this.getTransforms(builder.getCreators());
    }

    private Map<TransformKey, AttributeTransform> getTransforms(Map<TransformKey, AttributeCreatorImpl> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<TransformKey, AttributeCreatorImpl> entry : map.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().toTransform());
        }
        return builder.build();
    }

    <D> AttributeMetadata<D> bind(ElementKey<?, ?> parent, AttributeKey<D> key, MetadataContext context) {
        AttributeTransform transform;
        AttributeMetadata<D> previous;
        Preconditions.checkNotNull(parent, "parent");
        Preconditions.checkNotNull(key, "key");
        TransformKey transformKey = TransformKey.forTransform(parent, key, context);
        AttributeMetadata<D> transformed = (AttributeMetadata<D>)this.cache.get(transformKey);
        if (transformed == null && (previous = this.cache.putIfAbsent(transformKey, transformed = (transform = this.getTransform(transformKey, key)).toMetadata(this.schema, parent, key, context))) != null) {
            transformed = previous;
        }
        return transformed;
    }

    AttributeTransform getTransform(ElementKey<?, ?> parent, AttributeKey<?> key, MetadataContext context) {
        return this.getTransform(TransformKey.forTransform(parent, key, context), key);
    }

    private AttributeTransform getTransform(TransformKey transformKey, AttributeKey<?> key) {
        ArrayList matched = Lists.newArrayList();
        for (Map.Entry<TransformKey, AttributeTransform> entry : this.transforms.entrySet()) {
            if (!entry.getKey().matches(transformKey)) continue;
            matched.add(entry.getValue());
        }
        switch (matched.size()) {
            case 0: {
                return AttributeTransform.EMPTY;
            }
            case 1: {
                return (AttributeTransform)matched.get(0);
            }
        }
        return AttributeTransform.create(matched);
    }
}

