/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.util.List;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;

public class GVTTreeWalker {
    protected GraphicsNode gvtRoot;
    protected GraphicsNode treeRoot;
    protected GraphicsNode currentNode;

    public GVTTreeWalker(GraphicsNode graphicsNode) {
        this.gvtRoot = graphicsNode.getRoot();
        this.treeRoot = graphicsNode;
        this.currentNode = graphicsNode;
    }

    public GraphicsNode getRoot() {
        return this.treeRoot;
    }

    public GraphicsNode getGVTRoot() {
        return this.gvtRoot;
    }

    public void setCurrentGraphicsNode(GraphicsNode graphicsNode) {
        if (graphicsNode.getRoot() != this.gvtRoot) {
            throw new IllegalArgumentException("The node " + graphicsNode + " is not part of the document " + this.gvtRoot);
        }
        this.currentNode = graphicsNode;
    }

    public GraphicsNode getCurrentGraphicsNode() {
        return this.currentNode;
    }

    public GraphicsNode previousGraphicsNode() {
        GraphicsNode graphicsNode = this.getPreviousGraphicsNode(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode nextGraphicsNode() {
        GraphicsNode graphicsNode = this.getNextGraphicsNode(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode parentGraphicsNode() {
        if (this.currentNode == this.treeRoot) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = this.currentNode.getParent();
        if (compositeGraphicsNode != null) {
            this.currentNode = compositeGraphicsNode;
        }
        return compositeGraphicsNode;
    }

    public GraphicsNode getNextSibling() {
        GraphicsNode graphicsNode = GVTTreeWalker.getNextSibling(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode getPreviousSibling() {
        GraphicsNode graphicsNode = GVTTreeWalker.getPreviousSibling(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode firstChild() {
        GraphicsNode graphicsNode = GVTTreeWalker.getFirstChild(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    public GraphicsNode lastChild() {
        GraphicsNode graphicsNode = GVTTreeWalker.getLastChild(this.currentNode);
        if (graphicsNode != null) {
            this.currentNode = graphicsNode;
        }
        return graphicsNode;
    }

    protected GraphicsNode getNextGraphicsNode(GraphicsNode graphicsNode) {
        if (graphicsNode == null) {
            return null;
        }
        GraphicsNode graphicsNode2 = GVTTreeWalker.getFirstChild(graphicsNode);
        if (graphicsNode2 != null) {
            return graphicsNode2;
        }
        graphicsNode2 = GVTTreeWalker.getNextSibling(graphicsNode);
        if (graphicsNode2 != null) {
            return graphicsNode2;
        }
        graphicsNode2 = graphicsNode;
        while ((graphicsNode2 = graphicsNode2.getParent()) != null && graphicsNode2 != this.treeRoot) {
            GraphicsNode graphicsNode3 = GVTTreeWalker.getNextSibling(graphicsNode2);
            if (graphicsNode3 == null) continue;
            return graphicsNode3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected GraphicsNode getPreviousGraphicsNode(GraphicsNode var1_1) {
        if (var1_1 == null) {
            return null;
        }
        if (var1_1 == this.treeRoot) {
            return null;
        }
        var2_2 = GVTTreeWalker.getPreviousSibling(var1_1);
        if (var2_2 != null) ** GOTO lbl9
        return var1_1.getParent();
lbl-1000:
        // 1 sources

        {
            var2_2 = var3_3;
lbl9:
            // 2 sources

            ** while ((var3_3 = GVTTreeWalker.getLastChild((GraphicsNode)var2_2)) != null)
        }
lbl10:
        // 1 sources

        return var2_2;
    }

    protected static GraphicsNode getLastChild(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        if (list.size() >= 1) {
            return (GraphicsNode)list.get(list.size() - 1);
        }
        return null;
    }

    protected static GraphicsNode getPreviousSibling(GraphicsNode graphicsNode) {
        CompositeGraphicsNode compositeGraphicsNode = graphicsNode.getParent();
        if (compositeGraphicsNode == null) {
            return null;
        }
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        int n = list.indexOf(graphicsNode);
        if (n - 1 >= 0) {
            return (GraphicsNode)list.get(n - 1);
        }
        return null;
    }

    protected static GraphicsNode getFirstChild(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        if (list.size() >= 1) {
            return (GraphicsNode)list.get(0);
        }
        return null;
    }

    protected static GraphicsNode getNextSibling(GraphicsNode graphicsNode) {
        CompositeGraphicsNode compositeGraphicsNode = graphicsNode.getParent();
        if (compositeGraphicsNode == null) {
            return null;
        }
        List list = compositeGraphicsNode.getChildren();
        if (list == null) {
            return null;
        }
        int n = list.indexOf(graphicsNode);
        if (n + 1 < list.size()) {
            return (GraphicsNode)list.get(n + 1);
        }
        return null;
    }
}

