/*
 * Decompiled with CFR 0.152.
 */
package xpt.editor;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;
import xpt.GenAuditRoot_qvto;
import xpt.editor.DiagramEditorUtil;
import xpt.editor.ValidationMarker;
import xpt.providers.MarkerNavigationProvider;
import xpt.providers.ValidationDecoratorProvider;
import xpt.providers.ValidationProvider;

@Singleton
public class ValidateAction {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private GenAuditRoot_qvto _genAuditRoot_qvto;
    @Inject
    @Extension
    private ExternalizerUtils_qvto _externalizerUtils_qvto;
    @Inject
    private Activator xptActivator;
    @Inject
    private ValidationMarker xptValidationMarker;
    @Inject
    private Externalizer xptExternalizer;
    @Inject
    private DiagramEditorUtil xptDiagramEditorUtil;
    @Inject
    private ValidationProvider xptValidationProvider;
    @Inject
    private MarkerNavigationProvider xptMarkerNavigationProvider;
    @Inject
    private ValidationDecoratorProvider xptValidationDecoratorProvider;

    @MetaDef
    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"ValidateAction");
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenEditorView _editor = _editorGen.getEditor();
        String _packageName = _editor.getPackageName();
        _builder.append((Object)_packageName, "");
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "");
        return _builder;
    }

    public CharSequence extendsList(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"extends org.eclipse.jface.action.Action");
        return _builder;
    }

    public CharSequence ValidateAction(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        GenEditorGenerator _editorGen = it.getEditorGen();
        CharSequence _copyright = this._common.copyright(_editorGen);
        _builder.append((Object)_copyright, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _attributes = this.attributes(it);
        _builder.append((Object)_attributes, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _constructor = this.constructor(it);
        _builder.append((Object)_constructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _run = this.run(it);
        _builder.append((Object)_run, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _runValidation = this.runValidation(it);
        _builder.append((Object)_runValidation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _runNonUIValidation = this.runNonUIValidation(it);
        _builder.append((Object)_runNonUIValidation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _runValidationWithEP = this.runValidationWithEP(it);
        _builder.append((Object)_runValidationWithEP, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _runEMFValidator = this.runEMFValidator(it);
        _builder.append((Object)_runEMFValidator, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _validate = this.validate(it);
        _builder.append((Object)_validate, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _createMarkersForStatus = this.createMarkersForStatus(it);
        _builder.append((Object)_createMarkersForStatus, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _createMarkersForDiagnostic = this.createMarkersForDiagnostic(it);
        _builder.append((Object)_createMarkersForDiagnostic, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _addMarker = this.addMarker(it);
        _builder.append((Object)_addMarker, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _diagnosticToStatusSeverity = this.diagnosticToStatusSeverity(it);
        _builder.append((Object)_diagnosticToStatusSeverity, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _collectTargetElementsFromStatus = this.collectTargetElementsFromStatus(it);
        _builder.append((Object)_collectTargetElementsFromStatus, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _collectTargetElementsFromDiagnostic = this.collectTargetElementsFromDiagnostic(it);
        _builder.append((Object)_collectTargetElementsFromDiagnostic, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _additions = this.additions(it);
        _builder.append((Object)_additions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence attributes(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private org.eclipse.ui.IWorkbenchPage page;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constructor(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className, "");
        _builder.append((Object)"(org.eclipse.ui.IWorkbenchPage page) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"setText(");
        GenEditorGenerator _editorGen = it.getEditorGen();
        String _i18nKeyForValidateAction = this.i18nKeyForValidateAction(it);
        String _messageKey = this._externalizerUtils_qvto.messageKey(_i18nKeyForValidateAction);
        CharSequence _accessorCall = this.xptExternalizer.accessorCall(_editorGen, _messageKey);
        _builder.append((Object)_accessorCall, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.page = page;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence run(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public void run() {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.ui.IWorkbenchPart workbenchPart = page.getActivePart();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (workbenchPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart part =\t(org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) workbenchPart;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"new org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation(");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"new org.eclipse.jface.operation.IRunnableWithProgress() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"public void run(org.eclipse.core.runtime.IProgressMonitor monitor)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"throws InterruptedException, java.lang.reflect.InvocationTargetException {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"runValidation(part.getDiagramEditPart(), part.getDiagram());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_1.getApplication();
        boolean _equals_1 = Objects.equal((Object)_application_1, null);
        if (_equals_1) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)")");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)".run(new org.eclipse.core.runtime.NullProgressMonitor());\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        GenEditorGenerator _editorGen_2 = it.getEditorGen();
        GenPlugin _plugin = _editorGen_2.getPlugin();
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append((Object)".getInstance().logError(\"Validation action failed\", e); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runValidation(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static void runValidation(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t\t");
        _builder.append((Object)".openDiagram(view.eResource())) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.ui.IEditorPart editorPart = org.eclipse.ui.PlatformUI.getWorkbench()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)".getActiveWorkbenchWindow().getActivePage().getActiveEditor();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (editorPart instanceof org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"runValidation(((org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart) editorPart).");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"getDiagramEditPart(), view);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"runNonUIValidation(view);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} catch (Exception e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenPlugin _plugin = _editorGen.getPlugin();
        CharSequence _qualifiedClassName_1 = this.xptActivator.qualifiedClassName(_plugin);
        _builder.append((Object)_qualifiedClassName_1, "\t\t");
        _builder.append((Object)".getInstance().logError(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"\"Validation action failed\", e); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runNonUIValidation(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static void runNonUIValidation(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart =");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.OffscreenEditPartFactory.getInstance().createDiagramEditPart(");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"view.getDiagram());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"runValidation(diagramEditPart, view);");
        _builder.newLine();
        _builder.append((Object)"}\t\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runValidationWithEP(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public static void runValidation(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart, org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"final org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart fpart = diagramEditPart;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"final org.eclipse.gmf.runtime.notation.View fview = view;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.transaction.TransactionalEditingDomain txDomain = org.eclipse.emf.transaction.util.TransactionUtil.getEditingDomain(view);");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _qualifiedClassName = this.xptValidationProvider.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)".runWithConstraints(txDomain, new Runnable() {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void run() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"validate(fpart, fview);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runEMFValidator(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static org.eclipse.emf.common.util.Diagnostic runEMFValidator(");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View target) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (target.isSetElement() && target.getElement() != null) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return new org.eclipse.emf.ecore.util.Diagnostician() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getObjectLabel(org.eclipse.emf.ecore.EObject eObject) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(eObject, true);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}.validate(target.getElement());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return org.eclipse.emf.common.util.Diagnostic.OK_INSTANCE;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence validate(GenDiagram it) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static void validate(org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart,");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLine();
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.resources.IFile target = view.eResource() != null ?");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"org.eclipse.emf.workspace.util.WorkspaceSynchronizer.getFile(view.eResource()) : null;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (target != null) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _qualifiedClassName = this.xptMarkerNavigationProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName, "\t\t");
            _builder.append((Object)".deleteMarkers(target);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.gmf.runtime.notation.View target = view;");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _qualifiedClassName_1 = this.xptValidationMarker.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_1, "\t");
            _builder.append((Object)".removeAllMarkers(diagramEditPart.getViewer());");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.common.util.Diagnostic diagnostic = runEMFValidator(view);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"createMarkers(target, diagnostic, diagramEditPart);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.validation.service.IBatchValidator validator =");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"(org.eclipse.emf.validation.service.IBatchValidator)");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.validation.service.ModelValidationService.getInstance().newValidator(");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"org.eclipse.emf.validation.model.EvaluationMode.BATCH);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"validator.setIncludeLiveConstraints(true);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (view.isSetElement() && view.getElement() != null) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.core.runtime.IStatus status = validator.validate(view.getElement());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"createMarkers(target, status, diagramEditPart);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenAuditRoot _audits = _editorGen_1.getAudits();
        boolean _shouldRunValidateOnDiagram = this._genAuditRoot_qvto.shouldRunValidateOnDiagram(_audits);
        if (_shouldRunValidateOnDiagram) {
            GenEditorGenerator _editorGen_2 = it.getEditorGen();
            GenAuditRoot _audits_1 = _editorGen_2.getAudits();
            boolean _hasDiagramElementTargetRule = this._genAuditRoot_qvto.hasDiagramElementTargetRule(_audits_1);
            if (_hasDiagramElementTargetRule) {
                _builder.append((Object)"\t");
                _builder.append((Object)"validator.setTraversalStrategy(");
                CharSequence _qualifiedClassName_2 = this.xptValidationProvider.qualifiedClassName(it);
                _builder.append((Object)_qualifiedClassName_2, "\t");
                _builder.append((Object)".getNotationTraversalStrategy(validator));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.core.runtime.IStatus status = validator.validate(view);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"createMarkers(target, status, diagramEditPart);");
            _builder.newLine();
        }
        boolean _and = false;
        GenEditorGenerator _editorGen_3 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_3.getApplication();
        boolean bl = _notEquals = !Objects.equal((Object)_application_1, null);
        if (!_notEquals) {
            _and = false;
        } else {
            boolean _isValidationDecorators = it.isValidationDecorators();
            boolean bl2 = _and = _notEquals && _isValidationDecorators;
        }
        if (_and) {
            _builder.append((Object)"\t");
            CharSequence _qualifiedClassName_3 = this.xptValidationDecoratorProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_3, "\t");
            _builder.append((Object)".refreshDecorators(view);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"for (java.util.Iterator it = view.eAllContents(); it.hasNext();) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"org.eclipse.emf.ecore.EObject next = (org.eclipse.emf.ecore.EObject) it.next();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"if (next instanceof org.eclipse.gmf.runtime.notation.View) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            CharSequence _qualifiedClassName_4 = this.xptValidationDecoratorProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_4, "\t\t\t");
            _builder.append((Object)".refreshDecorators(");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"(org.eclipse.gmf.runtime.notation.View) next);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createMarkersForStatus(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static void createMarkers(");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"org.eclipse.core.resources.IFile");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
        } else {
            _builder.append((Object)"org.eclipse.gmf.runtime.notation.View");
        }
        _builder.append((Object)" target,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.core.runtime.IStatus validationStatus,");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (validationStatus.isOK()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"final org.eclipse.core.runtime.IStatus rootStatus = validationStatus;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.List allStatuses = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)".LazyElement2ViewMap element2ViewMap = new ");
        CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append((Object)".LazyElement2ViewMap(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"diagramEditPart.getDiagramView(),");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"collectTargetElements(rootStatus, new java.util.HashSet<org.eclipse.emf.ecore.EObject>(), allStatuses));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (java.util.Iterator it = allStatuses.iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.validation.model.IConstraintStatus nextStatus =");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"(org.eclipse.emf.validation.model.IConstraintStatus) it.next();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View view = ");
        CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append((Object)".findView(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"diagramEditPart, nextStatus.getTarget(), element2ViewMap);\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment(view), ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(nextStatus.getTarget(), true), ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"nextStatus.getMessage(), nextStatus.getSeverity());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createMarkersForDiagnostic(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static void createMarkers(");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"org.eclipse.core.resources.IFile");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
        } else {
            _builder.append((Object)"org.eclipse.gmf.runtime.notation.View");
        }
        _builder.append((Object)" target,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.emf.common.util.Diagnostic emfValidationStatus,");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart diagramEditPart) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (emfValidationStatus.getSeverity() == org.eclipse.emf.common.util.Diagnostic.OK) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"final org.eclipse.emf.common.util.Diagnostic rootStatus = emfValidationStatus;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.List allDiagnostics = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _qualifiedClassName = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName, "\t");
        _builder.append((Object)".LazyElement2ViewMap element2ViewMap =");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"new ");
        CharSequence _qualifiedClassName_1 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_1, "\t");
        _builder.append((Object)".LazyElement2ViewMap(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"diagramEditPart.getDiagramView(),");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"collectTargetElements(rootStatus, new java.util.HashSet<org.eclipse.emf.ecore.EObject>(), allDiagnostics));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (java.util.Iterator it = emfValidationStatus.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.common.util.Diagnostic nextDiagnostic = (org.eclipse.emf.common.util.Diagnostic) it.next();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.List data = nextDiagnostic.getData();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (data != null && !data.isEmpty() && data.get(0) instanceof org.eclipse.emf.ecore.EObject) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.ecore.EObject element = (org.eclipse.emf.ecore.EObject) data.get(0);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.notation.View view = ");
        CharSequence _qualifiedClassName_2 = this.xptDiagramEditorUtil.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName_2, "\t");
        _builder.append((Object)".findView(");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"diagramEditPart, element, element2ViewMap);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"addMarker(diagramEditPart.getViewer(), target, view.eResource().getURIFragment(view),");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(element, true),");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"nextDiagnostic.getMessage(), diagnosticToStatusSeverity(nextDiagnostic.getSeverity()));");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addMarker(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static void addMarker(org.eclipse.gef.EditPartViewer viewer,");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        GenEditorGenerator _editorGen = it.getEditorGen();
        GenApplication _application = _editorGen.getApplication();
        boolean _equals = Objects.equal((Object)_application, null);
        if (_equals) {
            _builder.append((Object)"org.eclipse.core.resources.IFile");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
        } else {
            _builder.append((Object)"org.eclipse.gmf.runtime.notation.View");
        }
        _builder.append((Object)" target,");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"String elementId, String location, String message, int statusSeverity) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (target == null) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GenEditorGenerator _editorGen_1 = it.getEditorGen();
        GenApplication _application_1 = _editorGen_1.getApplication();
        boolean _equals_1 = Objects.equal((Object)_application_1, null);
        if (_equals_1) {
            _builder.append((Object)"\t");
            CharSequence _qualifiedClassName = this.xptMarkerNavigationProvider.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName, "\t");
            _builder.append((Object)".addMarker(");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"target, elementId, location, message, statusSeverity);");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"new ");
            CharSequence _qualifiedClassName_1 = this.xptValidationMarker.qualifiedClassName(it);
            _builder.append((Object)_qualifiedClassName_1, "\t");
            _builder.append((Object)"(");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"location, message, statusSeverity).add(viewer, elementId);");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence diagnosticToStatusSeverity(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static int diagnosticToStatusSeverity(int diagnosticSeverity) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.OK) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return org.eclipse.core.runtime.IStatus.OK;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.INFO) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return org.eclipse.core.runtime.IStatus.INFO;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.WARNING) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return org.eclipse.core.runtime.IStatus.WARNING;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else if (diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.ERROR");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"|| diagnosticSeverity == org.eclipse.emf.common.util.Diagnostic.CANCEL) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return org.eclipse.core.runtime.IStatus.ERROR;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return org.eclipse.core.runtime.IStatus.INFO;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence collectTargetElementsFromStatus(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static java.util.Set<org.eclipse.emf.ecore.EObject> collectTargetElements(org.eclipse.core.runtime.IStatus status,");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.Set<org.eclipse.emf.ecore.EObject> targetElementCollector, java.util.List allConstraintStatuses) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (status instanceof org.eclipse.emf.validation.model.IConstraintStatus) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"targetElementCollector.add(((org.eclipse.emf.validation.model.IConstraintStatus) status).getTarget());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"allConstraintStatuses.add(status);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (status.isMultiStatus()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.core.runtime.IStatus[] children = status.getChildren();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (int i = 0; i < children.length; i++) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"collectTargetElements(children[i], targetElementCollector, allConstraintStatuses);\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return targetElementCollector;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence collectTargetElementsFromDiagnostic(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"private static java.util.Set<org.eclipse.emf.ecore.EObject> collectTargetElements(org.eclipse.emf.common.util.Diagnostic diagnostic,");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"java.util.Set<org.eclipse.emf.ecore.EObject> targetElementCollector, java.util.List allDiagnostics) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"java.util.List data = diagnostic.getData();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"org.eclipse.emf.ecore.EObject target = null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (data != null && !data.isEmpty() && data.get(0) instanceof org.eclipse.emf.ecore.EObject) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"target = (org.eclipse.emf.ecore.EObject) data.get(0);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"targetElementCollector.add(target);\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"allDiagnostics.add(diagnostic);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (diagnostic.getChildren() != null && !diagnostic.getChildren().isEmpty()) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (java.util.Iterator it = diagnostic.getChildren().iterator(); it.hasNext();) {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"collectTargetElements((org.eclipse.emf.common.util.Diagnostic) it.next(),");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"targetElementCollector, allDiagnostics);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return targetElementCollector;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence additions(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    @Localization
    public CharSequence i18nValues(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _i18nKeyForValidateAction = this.i18nKeyForValidateAction(it);
        String _messageKey = this._externalizerUtils_qvto.messageKey(_i18nKeyForValidateAction);
        CharSequence _messageEntry = this.xptExternalizer.messageEntry(_messageKey, "Validate");
        _builder.append((Object)_messageEntry, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public CharSequence i18nAccessors(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _i18nKeyForValidateAction = this.i18nKeyForValidateAction(it);
        String _messageKey = this._externalizerUtils_qvto.messageKey(_i18nKeyForValidateAction);
        CharSequence _accessorField = this.xptExternalizer.accessorField(_messageKey);
        _builder.append((Object)_accessorField, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Localization
    public String i18nKeyForValidateAction(GenDiagram diagram) {
        CharSequence _className = this.className(diagram);
        return _className.toString();
    }
}

