/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck.mdd;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.controllercheck.mdd.MddBinaryOperation;
import org.eclipse.escet.cif.controllercheck.mdd.MddCifVarInfoBuilder;
import org.eclipse.escet.cif.controllercheck.mdd.MddIntegerValueCollection;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.multivaluetrees.Node;
import org.eclipse.escet.common.multivaluetrees.Tree;
import org.eclipse.escet.common.multivaluetrees.VarInfo;

public class MddConvertExpression {
    public final MddCifVarInfoBuilder cifVarInfoBuilder;
    public final Tree tree;
    public final int readUseKind;
    public final int writeUseKind;
    private Map<Declaration, MddIntegerValueCollection> variableValues = Maps.map();
    private final EqualOp equalOp = new EqualOp();
    private final UnequalOp unequalOp = new UnequalOp();
    private final LessThanOp lessThanOp = new LessThanOp();
    private final LessEqualOp lessEqualOp = new LessEqualOp();
    private final GreaterThanOp greaterThanOp = new GreaterThanOp();
    private final GreaterEqualOp greaterEqualOp = new GreaterEqualOp();
    private final AdditionOp additionOp = new AdditionOp();
    private final SubtractionOp subtractionOp = new SubtractionOp();
    private final MultiplicationOp multiplicationOp = new MultiplicationOp();
    private final IntDivisionOp intDivisionOp = new IntDivisionOp();
    private final ModulusOp modulusOp = new ModulusOp();

    public MddConvertExpression(MddCifVarInfoBuilder cifVarInfoBuilder, Tree tree, int readUseKind, int writeUseKind) {
        this.cifVarInfoBuilder = cifVarInfoBuilder;
        this.tree = tree;
        this.readUseKind = readUseKind;
        this.writeUseKind = writeUseKind;
    }

    private MddIntegerValueCollection getVariable(Declaration var) {
        MddIntegerValueCollection collection = this.variableValues.get(var);
        if (collection != null) {
            return collection;
        }
        VarInfo readInfo = this.cifVarInfoBuilder.getVarInfo(var, this.readUseKind);
        collection = new MddIntegerValueCollection(readInfo.length);
        int idx = 0;
        while (idx < readInfo.length) {
            Node n = this.tree.buildEqualityIndex(readInfo, idx);
            collection.addValue(this.tree, readInfo.lower + idx, n);
            ++idx;
        }
        this.variableValues.put(var, collection);
        return collection;
    }

    public MddIntegerValueCollection convert(List<Expression> exprs) {
        Node trueVal = Tree.ONE;
        Node falseVal = Tree.ZERO;
        for (Expression expr : exprs) {
            MddIntegerValueCollection collection = this.convert(expr);
            falseVal = this.tree.disjunct(falseVal, collection.getExist(0));
            trueVal = this.tree.conjunct(trueVal, collection.getExist(1));
        }
        MddIntegerValueCollection result = new MddIntegerValueCollection(2);
        result.addValue(this.tree, 0, falseVal);
        result.addValue(this.tree, 1, trueVal);
        return result;
    }

    public MddIntegerValueCollection convert(Expression expr) {
        if (expr instanceof IntExpression) {
            IntExpression iExpr = (IntExpression)expr;
            MddIntegerValueCollection collection = new MddIntegerValueCollection(1);
            collection.addValue(this.tree, iExpr.getValue(), Tree.ONE);
            return collection;
        }
        if (expr instanceof BoolExpression) {
            BoolExpression bExpr = (BoolExpression)expr;
            MddIntegerValueCollection collection = new MddIntegerValueCollection(2);
            if (bExpr.isValue()) {
                collection.addValue(this.tree, 1, Tree.ONE);
                collection.addValue(this.tree, 0, Tree.ZERO);
            } else {
                collection.addValue(this.tree, 1, Tree.ZERO);
                collection.addValue(this.tree, 0, Tree.ONE);
            }
            return collection;
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariableExpression dve = (DiscVariableExpression)expr;
            return this.getVariable((Declaration)dve.getVariable());
        }
        if (expr instanceof InputVariableExpression) {
            InputVariableExpression ive = (InputVariableExpression)expr;
            return this.getVariable((Declaration)ive.getVariable());
        }
        if (expr instanceof UnaryExpression) {
            UnaryExpression unExpr = (UnaryExpression)expr;
            MddIntegerValueCollection subColl = this.convert(unExpr.getChild());
            switch (unExpr.getOperator()) {
                case INVERSE: {
                    Assert.check((subColl.size() == 2 ? 1 : 0) != 0);
                    MddIntegerValueCollection collection = new MddIntegerValueCollection(subColl.size());
                    for (Map.Entry<Integer, Node> entry : subColl.valueNodes.entrySet()) {
                        collection.valueNodes.put(1 - entry.getKey(), entry.getValue());
                    }
                    return collection;
                }
                case NEGATE: {
                    MddIntegerValueCollection collection = new MddIntegerValueCollection(subColl.size());
                    for (Map.Entry<Integer, Node> entry : subColl.valueNodes.entrySet()) {
                        collection.valueNodes.put(-entry.getKey().intValue(), entry.getValue());
                    }
                    return collection;
                }
                case PLUS: {
                    return subColl;
                }
            }
            throw new AssertionError((Object)Strings.fmt((String)"Unexpected unary operator '%s'.", (Object[])new Object[]{unExpr.getOperator()}));
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression binExpr = (BinaryExpression)expr;
            MddIntegerValueCollection leftColl = this.convert(binExpr.getLeft());
            MddIntegerValueCollection rightColl = this.convert(binExpr.getRight());
            switch (binExpr.getOperator()) {
                case BI_CONDITIONAL: {
                    Node trueVal = Tree.ZERO;
                    int val = 0;
                    while (val < 2) {
                        Node lnode = leftColl.getExist(val);
                        Node rnode = rightColl.getExist(val);
                        trueVal = this.tree.disjunct(trueVal, this.tree.conjunct(lnode, rnode));
                        ++val;
                    }
                    MddIntegerValueCollection collection = new MddIntegerValueCollection(2);
                    collection.addValue(this.tree, 1, trueVal);
                    collection.addValue(this.tree, 0, this.tree.invert(trueVal));
                    return collection;
                }
                case CONJUNCTION: {
                    MddIntegerValueCollection collection = new MddIntegerValueCollection(2);
                    Node lnode = leftColl.getExist(1);
                    Node rnode = rightColl.getExist(1);
                    collection.addValue(this.tree, 1, this.tree.conjunct(lnode, rnode));
                    lnode = leftColl.getExist(0);
                    rnode = rightColl.getExist(0);
                    collection.addValue(this.tree, 0, this.tree.disjunct(lnode, rnode));
                    return collection;
                }
                case DISJUNCTION: {
                    MddIntegerValueCollection collection = new MddIntegerValueCollection(2);
                    Node lnode = leftColl.getExist(1);
                    Node rnode = rightColl.getExist(1);
                    collection.addValue(this.tree, 1, this.tree.disjunct(lnode, rnode));
                    lnode = leftColl.getExist(0);
                    rnode = rightColl.getExist(0);
                    collection.addValue(this.tree, 0, this.tree.conjunct(lnode, rnode));
                    return collection;
                }
                case IMPLICATION: {
                    MddIntegerValueCollection collection = new MddIntegerValueCollection(2);
                    Node lnode = leftColl.getExist(0);
                    Node rnode = rightColl.getExist(1);
                    collection.addValue(this.tree, 1, this.tree.disjunct(lnode, rnode));
                    lnode = leftColl.getExist(1);
                    rnode = rightColl.getExist(0);
                    collection.addValue(this.tree, 0, this.tree.conjunct(lnode, rnode));
                    return collection;
                }
                case EQUAL: {
                    return this.performBoolOp(leftColl, rightColl, this.equalOp);
                }
                case UNEQUAL: {
                    return this.performBoolOp(leftColl, rightColl, this.unequalOp);
                }
                case GREATER_EQUAL: {
                    return this.performBoolOp(leftColl, rightColl, this.greaterEqualOp);
                }
                case GREATER_THAN: {
                    return this.performBoolOp(leftColl, rightColl, this.greaterThanOp);
                }
                case LESS_EQUAL: {
                    return this.performBoolOp(leftColl, rightColl, this.lessEqualOp);
                }
                case LESS_THAN: {
                    return this.performBoolOp(leftColl, rightColl, this.lessThanOp);
                }
                case ADDITION: {
                    return this.performIntOp(leftColl, rightColl, this.additionOp);
                }
                case SUBTRACTION: {
                    return this.performIntOp(leftColl, rightColl, this.subtractionOp);
                }
                case INTEGER_DIVISION: {
                    return this.performIntOp(leftColl, rightColl, this.intDivisionOp);
                }
                case MODULUS: {
                    return this.performIntOp(leftColl, rightColl, this.modulusOp);
                }
                case MULTIPLICATION: {
                    return this.performIntOp(leftColl, rightColl, this.multiplicationOp);
                }
            }
            throw new AssertionError((Object)Strings.fmt((String)"Unexpected binary operator '%s'.", (Object[])new Object[]{binExpr.getOperator()}));
        }
        if (expr instanceof IfExpression) {
            IfExpression ifExpr = (IfExpression)expr;
            MddIntegerValueCollection rslt = this.convert(ifExpr.getElse());
            int i = ifExpr.getElifs().size() - 1;
            while (i >= 0) {
                ElifExpression elifExpr = (ElifExpression)ifExpr.getElifs().get(i);
                MddIntegerValueCollection elifGuards = this.convert((List<Expression>)elifExpr.getGuards());
                MddIntegerValueCollection elifThen = this.convert(elifExpr.getThen());
                rslt = this.ifThenElse(elifGuards, elifThen, rslt);
                --i;
            }
            MddIntegerValueCollection ifGuards = this.convert((List<Expression>)ifExpr.getGuards());
            MddIntegerValueCollection ifThen = this.convert(ifExpr.getThen());
            return this.ifThenElse(ifGuards, ifThen, rslt);
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression switchExpr = (SwitchExpression)expr;
            Expression value = switchExpr.getValue();
            EList cases = switchExpr.getCases();
            MddIntegerValueCollection rslt = this.convert(((SwitchCase)Lists.last((List)cases)).getValue());
            int i = cases.size() - 2;
            while (i >= 0) {
                SwitchCase cse = (SwitchCase)cases.get(i);
                MddIntegerValueCollection caseGuard = CifTypeUtils.isAutRefExpr((Expression)value) ? this.convert(value) : this.performBoolOp(this.convert(value), this.convert(cse.getKey()), this.equalOp);
                MddIntegerValueCollection caseThen = this.convert(cse.getValue());
                rslt = this.ifThenElse(caseGuard, caseThen, rslt);
                --i;
            }
            return rslt;
        }
        throw new AssertionError((Object)Strings.fmt((String)"Unexpected expression node '%s'.", (Object[])new Object[]{expr}));
    }

    private MddIntegerValueCollection ifThenElse(MddIntegerValueCollection guardValues, MddIntegerValueCollection thenValues, MddIntegerValueCollection elseValues) {
        MddIntegerValueCollection result = new MddIntegerValueCollection(thenValues.size() + elseValues.size());
        for (Map.Entry<Integer, Node> thenEntry : thenValues.valueNodes.entrySet()) {
            result.addValue(this.tree, thenEntry.getKey(), this.tree.conjunct(guardValues.getExist(1), thenEntry.getValue()));
        }
        for (Map.Entry<Integer, Node> elseEntry : elseValues.valueNodes.entrySet()) {
            result.addValue(this.tree, elseEntry.getKey(), this.tree.conjunct(guardValues.getExist(0), elseEntry.getValue()));
        }
        return result;
    }

    private MddIntegerValueCollection performIntOp(MddIntegerValueCollection leftSide, MddIntegerValueCollection rightSide, MddBinaryOperation binOp) {
        return this.performIntOp(leftSide, rightSide, binOp, -1);
    }

    private MddIntegerValueCollection performIntOp(MddIntegerValueCollection leftSide, MddIntegerValueCollection rightSide, MddBinaryOperation binOp, int expectedCount) {
        MddIntegerValueCollection result = expectedCount <= 0 ? new MddIntegerValueCollection() : new MddIntegerValueCollection(expectedCount);
        for (Map.Entry<Integer, Node> leftEntry : leftSide.valueNodes.entrySet()) {
            for (Map.Entry<Integer, Node> rightEntry : rightSide.valueNodes.entrySet()) {
                Integer resValue = binOp.perform(leftEntry.getKey(), rightEntry.getKey());
                if (resValue == null) continue;
                Node resNode = this.tree.conjunct(leftEntry.getValue(), rightEntry.getValue());
                result.addValue(this.tree, resValue, resNode);
            }
        }
        return result;
    }

    private MddIntegerValueCollection performBoolOp(MddIntegerValueCollection leftSide, MddIntegerValueCollection rightSide, MddBinaryOperation binOp) {
        MddIntegerValueCollection result = this.performIntOp(leftSide, rightSide, binOp);
        if (!result.valueNodes.containsKey(0)) {
            result.valueNodes.put(0, Tree.ZERO);
        }
        if (!result.valueNodes.containsKey(1)) {
            result.valueNodes.put(1, Tree.ZERO);
        }
        Assert.check((result.size() == 2 ? 1 : 0) != 0);
        return result;
    }

    private Node assignCollection(Declaration destVar, MddIntegerValueCollection collection, int useKind) {
        VarInfo writeInfo = this.cifVarInfoBuilder.getVarInfo(destVar, useKind);
        Node n = Tree.ZERO;
        int idx = 0;
        while (idx < writeInfo.length) {
            Node cond = collection.get(writeInfo.lower + idx);
            if (cond != null) {
                Node writeVar = this.tree.buildEqualityIndex(writeInfo, idx);
                Node valueNode = this.tree.conjunct(cond, writeVar);
                n = this.tree.disjunct(n, valueNode);
            }
            ++idx;
        }
        return n;
    }

    public Node convertAssignment(Declaration destVar, Expression rhs) {
        MddIntegerValueCollection collection = this.convert(rhs);
        return this.assignCollection(destVar, collection, this.writeUseKind);
    }

    public Node convertToEquality(Declaration destVar, Expression rhs) {
        MddIntegerValueCollection collection = this.convert(rhs);
        return this.assignCollection(destVar, collection, this.readUseKind);
    }

    private static class AdditionOp
    implements MddBinaryOperation {
        private AdditionOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            long rslt = (long)leftValue.intValue() + (long)rightValue.intValue();
            if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
                return (int)rslt;
            }
            return null;
        }
    }

    private static class EqualOp
    implements MddBinaryOperation {
        private EqualOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            return leftValue.equals(rightValue) ? 1 : 0;
        }
    }

    private static class GreaterEqualOp
    implements MddBinaryOperation {
        private GreaterEqualOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            return leftValue >= rightValue ? 1 : 0;
        }
    }

    private static class GreaterThanOp
    implements MddBinaryOperation {
        private GreaterThanOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            return leftValue > rightValue ? 1 : 0;
        }
    }

    private static class IntDivisionOp
    implements MddBinaryOperation {
        private IntDivisionOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            if (rightValue == 0) {
                return null;
            }
            if (leftValue == Integer.MIN_VALUE && rightValue == -1) {
                return null;
            }
            return leftValue / rightValue;
        }
    }

    private static class LessEqualOp
    implements MddBinaryOperation {
        private LessEqualOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            return leftValue <= rightValue ? 1 : 0;
        }
    }

    private static class LessThanOp
    implements MddBinaryOperation {
        private LessThanOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            return leftValue < rightValue ? 1 : 0;
        }
    }

    private static class ModulusOp
    implements MddBinaryOperation {
        private ModulusOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            if (rightValue == 0) {
                return null;
            }
            return leftValue % rightValue;
        }
    }

    private static class MultiplicationOp
    implements MddBinaryOperation {
        private MultiplicationOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            long rslt = (long)leftValue.intValue() * (long)rightValue.intValue();
            if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
                return (int)rslt;
            }
            return null;
        }
    }

    private static class SubtractionOp
    implements MddBinaryOperation {
        private SubtractionOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            long rslt = (long)leftValue.intValue() - (long)rightValue.intValue();
            if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
                return (int)rslt;
            }
            return null;
        }
    }

    private static class UnequalOp
    implements MddBinaryOperation {
        private UnequalOp() {
        }

        @Override
        public Integer perform(Integer leftValue, Integer rightValue) {
            return leftValue.equals(rightValue) ? 0 : 1;
        }
    }
}

