/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.functions.AssignmentFuncStatement;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.position.metamodel.position.Position;

public class SimplifyValues
extends CifWalker
implements CifToCifTransformation {
    private Invariant dummyInv = CifConstructors.newInvariant();
    private Expression lastExpr;
    private Expression newExpr;
    private final boolean simplifyRefs;
    private final boolean optimizeLits;

    public SimplifyValues() {
        this(true, false);
    }

    public SimplifyValues(boolean simplifyRefs, boolean optimizeLits) {
        this.simplifyRefs = simplifyRefs;
        this.optimizeLits = optimizeLits;
    }

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Simplifying values of a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.lastExpr = null;
        this.newExpr = null;
        this.walkSpecification(spec);
        this.lastExpr = null;
        this.newExpr = null;
    }

    public Expression transform(Expression expr) {
        this.lastExpr = null;
        this.newExpr = null;
        if (expr.eContainer() == null) {
            this.dummyInv.setPredicate(expr);
        } else {
            this.dummyInv.setPredicate(null);
        }
        this.walkExpression(expr);
        Expression rslt = this.dummyInv.getPredicate();
        this.dummyInv.setPredicate(null);
        this.lastExpr = null;
        this.newExpr = null;
        return rslt;
    }

    protected void walkAssignment(Assignment obj) {
        this.precrawlAssignment(obj);
        Expression _addressable = obj.getAddressable();
        this.walkAddressable(_addressable);
        Position _position = obj.getPosition();
        if (_position != null) {
            this.walkPosition(_position);
        }
        Expression _value = obj.getValue();
        this.walkExpression(_value);
        this.postcrawlAssignment(obj);
    }

    protected void walkAssignmentFuncStatement(AssignmentFuncStatement obj) {
        this.precrawlAssignmentFuncStatement(obj);
        Expression _addressable = obj.getAddressable();
        this.walkAddressable(_addressable);
        Position _position = obj.getPosition();
        if (_position != null) {
            this.walkPosition(_position);
        }
        Expression _value = obj.getValue();
        this.walkExpression(_value);
        this.postcrawlAssignmentFuncStatement(obj);
    }

    /*
     * Unable to fully structure code
     */
    private void walkAddressable(Expression addr) {
        if (!(addr instanceof TupleExpression)) ** GOTO lbl9
        for (Expression elem : ((TupleExpression)addr).getFields()) {
            this.walkAddressable(elem);
        }
        return;
lbl-1000:
        // 1 sources

        {
            proj = (ProjectionExpression)addr;
            this.walkExpression(proj.getIndex());
            addr = proj.getChild();
lbl9:
            // 2 sources

            ** while (addr instanceof ProjectionExpression)
        }
lbl10:
        // 1 sources

        Assert.check((boolean)(addr instanceof DiscVariableExpression != false || addr instanceof ContVariableExpression != false || addr instanceof InputVariableExpression != false));
    }

    protected void walkSwitchCase(SwitchCase cse) {
        SwitchExpression switchExpr = (SwitchExpression)cse.eContainer();
        Expression value = switchExpr.getValue();
        if (!CifTypeUtils.isAutRefExpr((Expression)value)) {
            super.walkSwitchCase(cse);
            return;
        }
        SwitchCase obj = cse;
        this.precrawlSwitchCase(obj);
        Position _position = obj.getPosition();
        if (_position != null) {
            this.walkPosition(_position);
        }
        Expression _value = obj.getValue();
        this.walkExpression(_value);
        this.postcrawlSwitchCase(obj);
    }

    protected void postprocessExpression(Expression expr) {
        Expression rslt;
        if (expr == this.lastExpr) {
            expr = this.newExpr;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return;
        }
        if (expr instanceof TauExpression) {
            return;
        }
        if (expr instanceof EventExpression) {
            return;
        }
        boolean initial = CifValueUtils.isInitialExpr((Expression)expr);
        if (this.optimizeLits && CifValueUtils.isLiteralExpr((Expression)expr)) {
            return;
        }
        boolean singleValue = CifValueUtils.hasSingleValue((Expression)expr, (boolean)initial, (boolean)this.simplifyRefs);
        if (!singleValue) {
            return;
        }
        try {
            rslt = CifEvalUtils.evalAsExpr((Expression)expr, (boolean)initial);
        }
        catch (CifEvalException e) {
            String msg = "Failed to simplify an invalid CIF specification.";
            throw new InvalidModelException(msg, (Throwable)e);
        }
        EMFHelper.updateParentContainment((EObject)expr, (EObject)rslt);
    }

    protected void postprocessComplexComponent(ComplexComponent comp) {
        this.simplifyInvs((EList<Invariant>)comp.getInvariants());
        this.simplifyPreds((EList<Expression>)comp.getInitials(), true, true);
        this.simplifyPreds((EList<Expression>)comp.getMarkeds(), true, true);
    }

    protected void postprocessLocation(Location loc) {
        this.simplifyInvs((EList<Invariant>)loc.getInvariants());
        this.simplifyPreds((EList<Expression>)loc.getInitials(), false, true);
        this.simplifyPreds((EList<Expression>)loc.getMarkeds(), false, true);
    }

    protected void postprocessEdge(Edge edge) {
        this.simplifyPreds((EList<Expression>)edge.getGuards(), true, true);
    }

    protected void postprocessElifExpression(ElifExpression elif) {
        this.simplifyPreds((EList<Expression>)elif.getGuards(), true, false);
    }

    protected void postprocessElifUpdate(ElifUpdate elif) {
        this.simplifyPreds((EList<Expression>)elif.getGuards(), true, false);
    }

    protected void postprocessIfExpression(IfExpression ifExpr) {
        this.simplifyPreds((EList<Expression>)ifExpr.getGuards(), true, false);
    }

    protected void postprocessIfUpdate(IfUpdate ifUpd) {
        this.simplifyPreds((EList<Expression>)ifUpd.getGuards(), true, false);
    }

    private void simplifyPreds(EList<Expression> preds, boolean defaultTrue, boolean allowEmpty) {
        Iterator predIter = preds.iterator();
        boolean trueRemoved = false;
        while (predIter.hasNext()) {
            boolean initial;
            Expression expr = (Expression)predIter.next();
            if (CifValueUtils.isTriviallyFalse((Expression)expr, (boolean)(initial = CifValueUtils.isInitialExpr((Expression)expr)), (boolean)this.simplifyRefs)) {
                preds.clear();
                if (allowEmpty && !defaultTrue) {
                    return;
                }
                preds.add((Object)CifValueUtils.makeFalse());
                return;
            }
            if (!CifValueUtils.isTriviallyTrue((Expression)expr, (boolean)initial, (boolean)this.simplifyRefs)) continue;
            trueRemoved = true;
            predIter.remove();
        }
        if (trueRemoved && preds.isEmpty() && (!allowEmpty || !defaultTrue)) {
            preds.add((Object)CifValueUtils.makeTrue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void simplifyInvs(EList<Invariant> invs) {
        if (invs.isEmpty()) {
            return;
        }
        Iterator invIter = invs.iterator();
        block8: while (invIter.hasNext()) {
            Invariant inv = (Invariant)invIter.next();
            Expression pred = inv.getPredicate();
            switch (inv.getInvKind()) {
                case STATE: 
                case EVENT_NEEDS: {
                    if (!CifValueUtils.isTriviallyTrue((Expression)pred, (boolean)false, (boolean)this.simplifyRefs)) continue block8;
                    invIter.remove();
                    break;
                }
                case EVENT_DISABLES: {
                    if (!CifValueUtils.isTriviallyFalse((Expression)pred, (boolean)false, (boolean)this.simplifyRefs)) continue block8;
                    invIter.remove();
                    break;
                }
            }
        }
        Map evtToSupKindToInvs = Maps.map();
        for (Invariant inv : invs) {
            List entryInvs;
            EventExpression eventRef = (EventExpression)inv.getEvent();
            Event event = eventRef == null ? null : eventRef.getEvent();
            Map supKindToInvs = (Map)evtToSupKindToInvs.get(event);
            if (supKindToInvs == null) {
                supKindToInvs = Maps.map();
                evtToSupKindToInvs.put(event, supKindToInvs);
            }
            if ((entryInvs = (List)supKindToInvs.get(inv.getSupKind())) == null) {
                entryInvs = Lists.list();
                supKindToInvs.put(inv.getSupKind(), entryInvs);
            }
            entryInvs.add(inv);
        }
        boolean changed = false;
        for (Map supKindToInvs : evtToSupKindToInvs.values()) {
            block11: for (List supKindInvs : supKindToInvs.values()) {
                for (Invariant inv : supKindInvs) {
                    Expression pred = inv.getPredicate();
                    switch (inv.getInvKind()) {
                        case STATE: 
                        case EVENT_NEEDS: {
                            if (!CifValueUtils.isTriviallyFalse((Expression)pred, (boolean)false, (boolean)this.simplifyRefs)) break;
                            changed = true;
                            inv.setPredicate((Expression)CifValueUtils.makeFalse());
                            supKindInvs.clear();
                            supKindInvs.add(inv);
                            continue block11;
                        }
                        case EVENT_DISABLES: {
                            if (!CifValueUtils.isTriviallyTrue((Expression)pred, (boolean)false, (boolean)this.simplifyRefs)) break;
                            changed = true;
                            inv.setPredicate((Expression)CifValueUtils.makeTrue());
                            supKindInvs.clear();
                            supKindInvs.add(inv);
                            continue block11;
                        }
                    }
                }
            }
        }
        if (!changed) {
            return;
        }
        invs.clear();
        for (Map supKindToInvs : evtToSupKindToInvs.values()) {
            for (List supKindInvs : supKindToInvs.values()) {
                invs.addAll((Collection)supKindInvs);
            }
        }
    }

    protected void postprocessBinaryExpression(BinaryExpression bexpr) {
        Expression l = bexpr.getLeft();
        Expression r = bexpr.getRight();
        boolean linit = CifValueUtils.isInitialExpr((Expression)l);
        boolean rinit = CifValueUtils.isInitialExpr((Expression)r);
        boolean lt = CifValueUtils.isTriviallyTrue((Expression)l, (boolean)linit, (boolean)this.simplifyRefs);
        boolean lf = CifValueUtils.isTriviallyFalse((Expression)l, (boolean)linit, (boolean)this.simplifyRefs);
        boolean rt = CifValueUtils.isTriviallyTrue((Expression)r, (boolean)rinit, (boolean)this.simplifyRefs);
        boolean rf = CifValueUtils.isTriviallyFalse((Expression)r, (boolean)rinit, (boolean)this.simplifyRefs);
        if (!(lt || lf || rt || rf)) {
            return;
        }
        BoolExpression replacement = null;
        switch (bexpr.getOperator()) {
            case CONJUNCTION: {
                if (lf) {
                    replacement = CifValueUtils.makeFalse();
                    break;
                }
                if (rf) {
                    replacement = CifValueUtils.makeFalse();
                    break;
                }
                if (lt) {
                    replacement = r;
                    break;
                }
                if (!rt) break;
                replacement = l;
                break;
            }
            case DISJUNCTION: {
                if (lt) {
                    replacement = CifValueUtils.makeTrue();
                    break;
                }
                if (rt) {
                    replacement = CifValueUtils.makeTrue();
                    break;
                }
                if (lf) {
                    replacement = r;
                    break;
                }
                if (!rf) break;
                replacement = l;
                break;
            }
            case IMPLICATION: {
                if (rt) {
                    replacement = CifValueUtils.makeTrue();
                    break;
                }
                if (lf) {
                    replacement = CifValueUtils.makeTrue();
                    break;
                }
                if (lt) {
                    replacement = r;
                    break;
                }
                if (!rf) break;
                replacement = CifConstructors.newUnaryExpression((Expression)l, (UnaryOperator)UnaryOperator.INVERSE, null, (CifType)CifConstructors.newBoolType());
                break;
            }
            case BI_CONDITIONAL: {
                if (lt) {
                    replacement = r;
                    break;
                }
                if (rt) {
                    replacement = l;
                    break;
                }
                if (lf) {
                    replacement = CifConstructors.newUnaryExpression((Expression)r, (UnaryOperator)UnaryOperator.INVERSE, null, (CifType)CifConstructors.newBoolType());
                    break;
                }
                if (!rf) break;
                replacement = CifConstructors.newUnaryExpression((Expression)l, (UnaryOperator)UnaryOperator.INVERSE, null, (CifType)CifConstructors.newBoolType());
                break;
            }
            default: {
                return;
            }
        }
        Assert.notNull((Object)replacement);
        EMFHelper.updateParentContainment((EObject)bexpr, (EObject)replacement);
        this.lastExpr = bexpr;
        this.newExpr = replacement;
    }

    protected void postprocessUnaryExpression(UnaryExpression uexpr) {
        Expression replacement = null;
        if (uexpr.getOperator() == UnaryOperator.INVERSE) {
            UnaryExpression child;
            if (uexpr.getChild() instanceof UnaryExpression && (child = (UnaryExpression)uexpr.getChild()).getOperator() == UnaryOperator.INVERSE) {
                replacement = child.getChild();
            }
            if (uexpr.getChild() instanceof BinaryExpression) {
                child = (BinaryExpression)uexpr.getChild();
                switch (child.getOperator()) {
                    case IMPLICATION: {
                        UnaryExpression nexpr = CifConstructors.newUnaryExpression();
                        nexpr.setOperator(UnaryOperator.INVERSE);
                        nexpr.setType((CifType)CifConstructors.newBoolType());
                        nexpr.setChild(child.getRight());
                        BinaryExpression bexpr = CifConstructors.newBinaryExpression();
                        bexpr.setOperator(BinaryOperator.CONJUNCTION);
                        bexpr.setType((CifType)CifConstructors.newBoolType());
                        bexpr.setLeft(child.getLeft());
                        bexpr.setRight((Expression)nexpr);
                        replacement = bexpr;
                        break;
                    }
                    case LESS_THAN: {
                        child.setOperator(BinaryOperator.GREATER_EQUAL);
                        replacement = child;
                        break;
                    }
                    case LESS_EQUAL: {
                        child.setOperator(BinaryOperator.GREATER_THAN);
                        replacement = child;
                        break;
                    }
                    case EQUAL: {
                        child.setOperator(BinaryOperator.UNEQUAL);
                        replacement = child;
                        break;
                    }
                    case UNEQUAL: {
                        child.setOperator(BinaryOperator.EQUAL);
                        replacement = child;
                        break;
                    }
                    case GREATER_THAN: {
                        child.setOperator(BinaryOperator.LESS_EQUAL);
                        replacement = child;
                        break;
                    }
                    case GREATER_EQUAL: {
                        child.setOperator(BinaryOperator.LESS_THAN);
                        replacement = child;
                    }
                }
            }
        }
        if (replacement != null) {
            EMFHelper.updateParentContainment((EObject)uexpr, replacement);
            this.lastExpr = uexpr;
            this.newExpr = replacement;
        }
    }
}

