/******************************************************************************
 * Copyright (c) 2024 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 *
 *  SPDX-License-Identifier: MIT
 *****************************************************************************/

/* SeText language for highlight.js 11.9.0. */
(() => {
    var e = (() => {
        "use strict";
        return e => {
            return {
                name: "SeText",
                keywords: {
                    keyword: [
                        "as", "end", "eof", "hooks", "import", "keywords",
                        "main", "scanner", "shortcut", "start", "terminals",
                    ]
                },
                contains: [
                    // Comments.
                    {
                        scope: "comment",
                        begin: '//',
                        end: '$',
                    },
                    {
                        scope: "comment",
                        begin: '/\\*',
                        end: '\\*/',
                    },

                    // Descriptions.
                    {
                        scope: "title",
                        begin: '\\[',
                        end: '\\]',
                    },

                    // Regular expressions.
                    {
                        scope: "string",
                        begin: '"',
                        end: '"',
                        contains: [
                            {
                                scope: "string",
                                match: /\\[\\"]/,
                            },
                        ]
                    },

                    // Escaped keywords should be identifiers.
                    {
                        scope: "escaped-keyword",
                        match: /[$]\b[A-Za-z_][A-Za-z0-9_]*\b/,
                    }
                ]
            }
        }
    })();
    hljs.registerLanguage("setext", e)
})();
