/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDDomain;
import com.github.javabdd.BDDFactory;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.CifBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedCifBddBitVectorAndCarry;
import org.eclipse.escet.common.java.Assert;

public class UnsignedCifBddBitVector
extends CifBddBitVector<UnsignedCifBddBitVector, UnsignedCifBddBitVectorAndCarry> {
    public static final int MINIMUM_LENGTH = 1;

    private UnsignedCifBddBitVector(BDDFactory factory, int length) {
        super(factory, length);
    }

    @Override
    protected int getMinimumLength() {
        return 1;
    }

    public static int getMinimumLength(int value) {
        Assert.check((value >= 0 ? 1 : 0) != 0);
        int count = 0;
        while (value > 0) {
            ++count;
            value >>= 1;
        }
        return Math.max(1, count);
    }

    @Override
    protected UnsignedCifBddBitVector createEmpty(int length) {
        return new UnsignedCifBddBitVector(this.factory, length);
    }

    public static UnsignedCifBddBitVector create(BDDFactory factory, int length) {
        return UnsignedCifBddBitVector.create(factory, length, false);
    }

    public static UnsignedCifBddBitVector create(BDDFactory factory, int length, boolean value) {
        UnsignedCifBddBitVector vector = new UnsignedCifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = value ? factory.one() : factory.zero();
            ++i;
        }
        return vector;
    }

    public static UnsignedCifBddBitVector createFromInt(BDDFactory factory, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        int length = UnsignedCifBddBitVector.getMinimumLength(value);
        return UnsignedCifBddBitVector.createFromInt(factory, length, value);
    }

    public static UnsignedCifBddBitVector createFromInt(BDDFactory factory, int length, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        if (length < UnsignedCifBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        UnsignedCifBddBitVector vector = new UnsignedCifBddBitVector(factory, length);
        int i = 0;
        while (i < vector.bits.length) {
            vector.bits[i] = (value & 1) != 0 ? factory.one() : factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.areEqual((Object)value, (Object)0);
        return vector;
    }

    public static UnsignedCifBddBitVector createFromDomain(BDDDomain domain) {
        int varCnt = domain.varNum();
        if (varCnt == 0) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        UnsignedCifBddBitVector vector = new UnsignedCifBddBitVector(domain.getFactory(), varCnt);
        int[] vars = domain.vars();
        int i = 0;
        while (i < vars.length) {
            vector.bits[i] = vector.factory.ithVar(vars[i]);
            ++i;
        }
        return vector;
    }

    @Override
    public Integer getInt() {
        if (this.bits.length > 31) {
            throw new IllegalStateException("More than 31 bits in vector.");
        }
        Long value = this.getLong();
        return value == null ? null : Integer.valueOf((int)value.longValue());
    }

    @Override
    public Long getLong() {
        if (this.bits.length > 63) {
            throw new IllegalStateException("More than 63 bits in vector.");
        }
        long value = 0L;
        int bitIndex = this.bits.length - 1;
        while (bitIndex >= 0) {
            if (this.bits[bitIndex].isOne()) {
                value = value << 1 | 1L;
            } else if (this.bits[bitIndex].isZero()) {
                value <<= 1;
            } else {
                return null;
            }
            --bitIndex;
        }
        return value;
    }

    @Override
    public void setInt(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Value is negative.");
        }
        if (this.bits.length < UnsignedCifBddBitVector.getMinimumLength(value)) {
            throw new IllegalArgumentException("Length is insufficient.");
        }
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = (value & 1) != 0 ? this.factory.one() : this.factory.zero();
            value >>= 1;
            ++i;
        }
        Assert.areEqual((Object)value, (Object)0);
    }

    @Override
    public void setDomain(BDDDomain domain) {
        int varCnt = domain.varNum();
        if (varCnt == 0) {
            throw new IllegalArgumentException("Domain is empty.");
        }
        if (varCnt > this.bits.length) {
            throw new IllegalArgumentException("Domain doesn't fit.");
        }
        int[] vars = domain.vars();
        Assert.areEqual((Object)varCnt, (Object)vars.length);
        int i = 0;
        while (i < varCnt) {
            this.bits[i].free();
            this.bits[i] = this.factory.ithVar(vars[i]);
            ++i;
        }
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = this.factory.zero();
            ++i;
        }
    }

    @Override
    public void resize(int length) {
        if (length == this.bits.length) {
            return;
        }
        if (length < 1) {
            throw new IllegalArgumentException("Length is less than one.");
        }
        BDD[] newBits = new BDD[length];
        int numberOfCommonBits = Math.min(this.bits.length, length);
        System.arraycopy(this.bits, 0, newBits, 0, numberOfCommonBits);
        int i = numberOfCommonBits;
        while (i < length) {
            newBits[i] = this.factory.zero();
            ++i;
        }
        i = numberOfCommonBits;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.bits = newBits;
    }

    @Override
    public UnsignedCifBddBitVectorAndCarry negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsignedCifBddBitVectorAndCarry abs() {
        return new UnsignedCifBddBitVectorAndCarry((UnsignedCifBddBitVector)this.copy(), this.factory.zero());
    }

    @Override
    public UnsignedCifBddBitVectorAndCarry add(UnsignedCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        UnsignedCifBddBitVector rslt = new UnsignedCifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            carry = this.bits[i].and(other.bits[i]).orWith(carry.andWith(this.bits[i].or(other.bits[i])));
            ++i;
        }
        return new UnsignedCifBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public UnsignedCifBddBitVectorAndCarry subtract(UnsignedCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        UnsignedCifBddBitVector rslt = new UnsignedCifBddBitVector(this.factory, this.bits.length);
        BDD carry = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            rslt.bits[i] = this.bits[i].xor(other.bits[i]).xorWith(carry.id());
            BDD tmp1 = other.bits[i].or(carry);
            BDD tmp2 = this.bits[i].apply(tmp1, BDDFactory.less);
            tmp1.free();
            carry = this.bits[i].and(other.bits[i]).andWith(carry).orWith(tmp2);
            ++i;
        }
        return new UnsignedCifBddBitVectorAndCarry(rslt, carry);
    }

    @Override
    public UnsignedCifBddBitVector div(int divisor) {
        return this.divmod(divisor, true);
    }

    @Override
    public UnsignedCifBddBitVector mod(int divisor) {
        return this.divmod(divisor, false);
    }

    private UnsignedCifBddBitVector divmod(int divisorValue, boolean isDiv) {
        if (divisorValue <= 0) {
            throw new IllegalArgumentException("Divisor is not positive.");
        }
        if (this.bits.length < UnsignedCifBddBitVector.getMinimumLength(divisorValue)) {
            throw new IllegalArgumentException("Divisor doesn't fit.");
        }
        if (!isDiv && !this.bits[this.bits.length - 1].isZero()) {
            throw new IllegalStateException("Computing the remainder/'mod', and the highest bit of the dividend is not 'false'.");
        }
        UnsignedCifBddBitVector divisor = UnsignedCifBddBitVector.createFromInt(this.factory, this.bits.length, divisorValue);
        UnsignedCifBddBitVector quotient = (UnsignedCifBddBitVector)this.shiftLeft(1, this.factory.zero());
        UnsignedCifBddBitVector remainderZero = UnsignedCifBddBitVector.create(this.factory, this.bits.length);
        UnsignedCifBddBitVector remainder = (UnsignedCifBddBitVector)remainderZero.shiftLeft(1, this.bits[this.bits.length - 1]);
        remainderZero.free();
        this.divModRecursive(divisor, quotient, remainder, this.bits.length);
        divisor.free();
        if (isDiv) {
            remainder.free();
            return quotient;
        }
        quotient.free();
        UnsignedCifBddBitVector shiftedRemainder = (UnsignedCifBddBitVector)remainder.shiftRight(1, this.factory.zero());
        remainder.free();
        return shiftedRemainder;
    }

    private void divModRecursive(UnsignedCifBddBitVector divisor, UnsignedCifBddBitVector quotient, UnsignedCifBddBitVector remainder, int step) {
        int divLen = divisor.bits.length;
        BDD isSmaller = divisor.lessOrEqual(remainder);
        UnsignedCifBddBitVector newQuotient = (UnsignedCifBddBitVector)quotient.shiftLeft(1, isSmaller);
        UnsignedCifBddBitVector sub = UnsignedCifBddBitVector.create(this.factory, divLen);
        int i = 0;
        while (i < divLen) {
            sub.bits[i] = isSmaller.ite(divisor.bits[i], this.factory.zero());
            ++i;
        }
        UnsignedCifBddBitVectorAndCarry tmp = remainder.subtract(sub);
        UnsignedCifBddBitVector newRemainder = (UnsignedCifBddBitVector)((UnsignedCifBddBitVector)tmp.vector).shiftLeft(1, quotient.bits[divLen - 1]);
        if (step > 1) {
            this.divModRecursive(divisor, newQuotient, newRemainder, step - 1);
        }
        ((UnsignedCifBddBitVector)tmp.vector).free();
        tmp.carry.free();
        sub.free();
        isSmaller.free();
        quotient.replaceBy(newQuotient);
        remainder.replaceBy(newRemainder);
    }

    @Override
    public BDD lessThan(UnsignedCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD rslt = this.factory.zero();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            rslt = lt.orWith(eq.andWith(rslt));
            ++i;
        }
        return rslt;
    }

    @Override
    public BDD lessOrEqual(UnsignedCifBddBitVector other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD rslt = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD lt = this.bits[i].apply(other.bits[i], BDDFactory.less);
            BDD eq = this.bits[i].biimp(other.bits[i]);
            rslt = lt.orWith(eq.andWith(rslt));
            ++i;
        }
        return rslt;
    }
}

