/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui.commands;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.app.framework.appsview.ui.icons.AppStatusIcons;
import org.eclipse.escet.common.app.framework.management.AppStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AppStatusLegendDialog
extends Dialog {
    private final AppStatusIcons icons;

    protected AppStatusLegendDialog(Shell parentShell, AppStatusIcons icons) {
        super(parentShell);
        this.icons = icons;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout());
        Composite center = new Composite(area, 0);
        center.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GridLayout centerLayout = new GridLayout(2, false);
        centerLayout.marginWidth = 8;
        centerLayout.marginHeight = 8;
        centerLayout.horizontalSpacing = 8;
        centerLayout.verticalSpacing = 8;
        center.setLayout((Layout)centerLayout);
        AppStatus[] appStatusArray = AppStatus.values();
        int n = appStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            AppStatus status = appStatusArray[n2];
            Image icon = this.icons.getIcon(status);
            if (icon != null && !icon.isDisposed()) {
                Canvas canvas = new Canvas(center, 0x100000);
                canvas.addPaintListener(e -> e.gc.drawImage(icon, 0, 0));
                canvas.setLayoutData((Object)new GridData(icon.getBounds().width, icon.getBounds().height));
                Label label = new Label(center, 0);
                String text = status.toString().toLowerCase(Locale.US);
                text = StringUtils.capitalize((String)text);
                label.setText(text);
            }
            ++n2;
        }
        Point size = center.computeSize(-1, -1);
        parent.getShell().setMinimumSize((int)((double)size.x * 2.5), 50);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        parent.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                AppStatusLegendDialog.this.getButton(0).setFocus();
            }
        });
        parent.getShell().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.character == '\u001b') {
                    AppStatusLegendDialog.this.okPressed();
                    event.detail = 0;
                    event.doit = false;
                }
            }
        });
    }
}

