/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.metamodel.cif.functions.ExternalFunction;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class FuncNoSpecificUserDefCheck
extends CifCheck {
    private static final EnumSet<NoSpecificUserDefFunc> ALL_USER_DEF_FUNCS = EnumSet.of(NoSpecificUserDefFunc.INTERNAL, NoSpecificUserDefFunc.EXTERNAL);
    private final EnumSet<NoSpecificUserDefFunc> disalloweds;

    public FuncNoSpecificUserDefCheck(EnumSet<NoSpecificUserDefFunc> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public FuncNoSpecificUserDefCheck(NoSpecificUserDefFunc ... disalloweds) {
        this(Arrays.stream(disalloweds).collect(Collectors.toCollection(() -> EnumSet.noneOf(NoSpecificUserDefFunc.class))));
    }

    protected void preprocessInternalFunction(InternalFunction func, CifCheckViolations violations) {
        this.checkFunction((Function)func, NoSpecificUserDefFunc.INTERNAL, violations);
    }

    protected void preprocessExternalFunction(ExternalFunction func, CifCheckViolations violations) {
        this.checkFunction((Function)func, NoSpecificUserDefFunc.EXTERNAL, violations);
    }

    private void checkFunction(Function func, NoSpecificUserDefFunc funcKind, CifCheckViolations violations) {
        if (this.disalloweds.contains((Object)funcKind)) {
            if (this.disalloweds.containsAll(ALL_USER_DEF_FUNCS)) {
                violations.add((PositionObject)func, "Function is a user-defined function", new Object[0]);
            } else {
                String funcText = funcKind == NoSpecificUserDefFunc.INTERNAL ? "internal" : "external";
                violations.add((PositionObject)func, "Function is an %s user-defined function", funcText);
            }
        }
        if (this.disalloweds.contains((Object)NoSpecificUserDefFunc.NO_PARAMETER) && func.getParameters().isEmpty()) {
            violations.add((PositionObject)func, "Function is a user-defined function without parameters", new Object[0]);
        }
    }

    public static enum NoSpecificUserDefFunc {
        INTERNAL,
        EXTERNAL,
        NO_PARAMETER;

    }
}

