/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.spec;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDVarSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.spec.CifBddDomain;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CifBddSpec {
    public final CifBddSettings settings;
    public BDDFactory factory;
    public Set<Event> alphabet;
    public Set<Event> controllables;
    public Set<Event> inputVarEvents;
    public CifBddVariable[] variables;
    private String[] bddVarNames = null;
    public List<CifBddEdge> edges;
    public List<CifBddEdge> orderedEdgesBackward;
    public List<CifBddEdge> orderedEdgesForward;
    public Map<Event, List<CifBddEdge>> eventEdges;
    public List<BitSet> worksetDependenciesBackward;
    public List<BitSet> worksetDependenciesForward;
    public List<BDD> initialsVars;
    public List<BDD> initialsComps;
    public List<BDD> initialsLocs;
    public BDD initialVars;
    public BDD initialComps;
    public BDD initialLocs;
    public BDD initial;
    public BDD initialPlantInv;
    public BDD initialInv;
    public List<BDD> markedsComps;
    public List<BDD> markedsLocs;
    public BDD markedComps;
    public BDD markedLocs;
    public BDD marked;
    public BDD markedPlantInv;
    public BDD markedInv;
    public List<BDD> plantInvsComps;
    public List<BDD> plantInvsLocs;
    public BDD plantInvComps;
    public BDD plantInvLocs;
    public BDD plantInv;
    public List<BDD> reqInvsComps;
    public List<BDD> reqInvsLocs;
    public BDD reqInvComps;
    public BDD reqInvLocs;
    public BDD reqInv;
    public Map<Event, BDD> stateEvtExclsReqAuts;
    public Map<Event, BDD> stateEvtExclsReqInvs;
    public Map<Event, List<BDD>> stateEvtExclReqLists;
    public Map<Event, BDD> stateEvtExclReqs;
    public Map<Event, List<BDD>> stateEvtExclPlantLists;
    public Map<Event, BDD> stateEvtExclPlants;
    private List<CifBddDomain> domains = Lists.list();
    public BDDVarSet varSetOld;
    public BDDVarSet varSetNew;
    public List<BDDVarSet> varSetsExtra;

    public CifBddSpec(CifBddSettings settings) {
        this.settings = settings;
    }

    public int getDomainCount() {
        return this.domains.size();
    }

    public CifBddDomain createDomain(int length) {
        return this.createDomains(length)[0];
    }

    public CifBddDomain[] createDomains(int ... lengths) {
        int domainIdx;
        Assert.check((lengths.length > 0 ? 1 : 0) != 0);
        int[][] varArrays = new int[lengths.length][];
        int maxLength = 0;
        int domainIdx2 = 0;
        while (domainIdx2 < lengths.length) {
            varArrays[domainIdx2] = new int[lengths[domainIdx2]];
            maxLength = Math.max(maxLength, lengths[domainIdx2]);
            ++domainIdx2;
        }
        int nextVarIdx = this.factory.varNum();
        int bitIdx = 0;
        while (bitIdx < maxLength) {
            domainIdx = 0;
            while (domainIdx < lengths.length) {
                if (bitIdx < lengths[domainIdx]) {
                    varArrays[domainIdx][bitIdx] = nextVarIdx++;
                }
                ++domainIdx;
            }
            ++bitIdx;
        }
        this.factory.setVarNum(nextVarIdx);
        CifBddDomain[] newDomains = new CifBddDomain[lengths.length];
        domainIdx = 0;
        while (domainIdx < lengths.length) {
            CifBddDomain domain = new CifBddDomain(this.factory, this.domains.size(), varArrays[domainIdx]);
            this.domains.add(domain);
            newDomains[domainIdx] = domain;
            ++domainIdx;
        }
        return newDomains;
    }

    public int getBddVarCountPerDomain() {
        int nrOfDomains = 2 + this.settings.getBddExtraVarDomainNames().size();
        return this.factory.varNum() / nrOfDomains;
    }

    public void freeIntermediateBDDs(boolean freeReqsInvsCompsAndLocs) {
        this.plantInvsComps = BddUtils.free(this.plantInvsComps);
        this.plantInvsLocs = BddUtils.free(this.plantInvsLocs);
        this.plantInvComps = BddUtils.free(this.plantInvComps);
        this.plantInvLocs = BddUtils.free(this.plantInvLocs);
        if (freeReqsInvsCompsAndLocs) {
            this.reqInvsComps = BddUtils.free(this.reqInvsComps);
            this.reqInvsLocs = BddUtils.free(this.reqInvsLocs);
        }
        this.reqInvComps = BddUtils.free(this.reqInvComps);
        this.reqInvLocs = BddUtils.free(this.reqInvLocs);
        this.initialsVars = BddUtils.free(this.initialsVars);
        this.initialsComps = BddUtils.free(this.initialsComps);
        this.initialsLocs = BddUtils.free(this.initialsLocs);
        this.initialVars = BddUtils.free(this.initialVars);
        this.initialComps = BddUtils.free(this.initialComps);
        this.initialLocs = BddUtils.free(this.initialLocs);
        this.initialInv = BddUtils.free(this.initialInv);
        this.markedsComps = BddUtils.free(this.markedsComps);
        this.markedsLocs = BddUtils.free(this.markedsLocs);
        this.markedComps = BddUtils.free(this.markedComps);
        this.markedLocs = BddUtils.free(this.markedLocs);
        this.markedPlantInv = BddUtils.free(this.markedPlantInv);
        this.markedInv = BddUtils.free(this.markedInv);
        this.stateEvtExclPlantLists = BddUtils.free(this.stateEvtExclPlantLists, e -> (Collection)e.getValue());
        this.stateEvtExclReqLists = BddUtils.free(this.stateEvtExclReqLists, e -> (Collection)e.getValue());
    }

    public void freeAllBDDs() {
        this.freeIntermediateBDDs(true);
        this.initial = BddUtils.free(this.initial);
        this.initialPlantInv = BddUtils.free(this.initialPlantInv);
        this.marked = BddUtils.free(this.marked);
        this.plantInv = BddUtils.free(this.plantInv);
        this.reqInv = BddUtils.free(this.reqInv);
        this.stateEvtExclsReqAuts = BddUtils.free(this.stateEvtExclsReqAuts, e -> Collections.singleton((BDD)e.getValue()));
        this.stateEvtExclsReqInvs = BddUtils.free(this.stateEvtExclsReqInvs, e -> Collections.singleton((BDD)e.getValue()));
        this.stateEvtExclReqs = BddUtils.free(this.stateEvtExclReqs, e -> Collections.singleton((BDD)e.getValue()));
        this.stateEvtExclPlants = BddUtils.free(this.stateEvtExclPlants, e -> Collections.singleton((BDD)e.getValue()));
        this.varSetOld = BddUtils.free(this.varSetOld);
        this.varSetNew = BddUtils.free(this.varSetNew);
        this.varSetsExtra = BddUtils.freeVarSets(this.varSetsExtra);
        for (CifBddEdge edge : this.edges) {
            edge.freeBDDs();
        }
        CifBddVariable[] cifBddVariableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable cifBddVar = cifBddVariableArray[n2];
            cifBddVar.domain.free();
            cifBddVar.domainNew.free();
            CifBddDomain[] cifBddDomainArray = cifBddVar.domainsExtra;
            int n3 = cifBddVar.domainsExtra.length;
            int n4 = 0;
            while (n4 < n3) {
                CifBddDomain domainExtra = cifBddDomainArray[n4];
                domainExtra.free();
                ++n4;
            }
            ++n2;
        }
        this.factory.done();
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.getEdgesText());
    }

    public List<String> getEdgesText() {
        return this.getEdgesText(false);
    }

    public List<String> getEdgesText(boolean includeOnlyOrigGuard) {
        return this.edges.stream().map(e -> e.toString("Edge: ", includeOnlyOrigGuard)).toList();
    }

    public String[] getBddVarNames() {
        if (this.bddVarNames != null) {
            return this.bddVarNames;
        }
        List varsPerGroup = Lists.list();
        int curGroupIdx = 0;
        CifBddVariable[] cifBddVariableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable cifBddVar = cifBddVariableArray[n2];
            if (varsPerGroup.isEmpty()) {
                Assert.areEqual((Object)0, (Object)cifBddVar.group);
                varsPerGroup.add(Lists.list((Object)cifBddVar));
            } else if (cifBddVar.group == curGroupIdx) {
                ((List)Lists.last((List)varsPerGroup)).add(cifBddVar);
            } else {
                varsPerGroup.add(Lists.list((Object)cifBddVar));
                Assert.areEqual((Object)cifBddVar.group, (Object)(++curGroupIdx));
            }
            ++n2;
        }
        int numberOfVarSetsPerCifVar = 2 + this.varSetsExtra.size();
        List<String> extraVarSetNames = this.settings.getBddExtraVarDomainNames();
        List names = Lists.list();
        for (List varsInGroup : varsPerGroup) {
            int maxLength = varsInGroup.stream().map(v -> v.getBddVarCount()).max(Integer::compareTo).get();
            int bitIdx = 0;
            while (bitIdx < maxLength) {
                for (CifBddVariable cifBddVar : varsInGroup) {
                    if (bitIdx >= cifBddVar.getBddVarCount()) continue;
                    int varSetIdx = 0;
                    while (varSetIdx < numberOfVarSetsPerCifVar) {
                        String postfix = switch (varSetIdx) {
                            case 0 -> "";
                            case 1 -> "+";
                            default -> Strings.fmt((String)"{%s}", (Object[])new Object[]{extraVarSetNames.get(varSetIdx - 2)});
                        };
                        names.add(Strings.fmt((String)"%s#%d%s", (Object[])new Object[]{cifBddVar.name, bitIdx, postfix}));
                        ++varSetIdx;
                    }
                }
                ++bitIdx;
            }
        }
        this.bddVarNames = names.toArray(new String[names.size()]);
        return this.bddVarNames;
    }
}

