/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.automata;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.AutomatonKind;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.common.java.Assert;

public class Automaton
implements Iterable<Location> {
    public AutomatonKind kind = AutomatonKind.UNKNOWN;
    public String name = "<none>";
    public Location initial = null;
    public final Set<Event> alphabet;
    public Location locations = null;
    private Location lastLocation = null;

    public Automaton(Set<Event> alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public Iterator<Location> iterator() {
        return new LocationIterator(this.locations);
    }

    public void setInitial(Location initial) {
        Assert.check((this.initial == null || initial == null ? 1 : 0) != 0);
        this.initial = initial;
    }

    public int size() {
        int count = 0;
        Location loc = this.locations;
        while (loc != null) {
            ++count;
            loc = loc.nextLoc;
        }
        return count;
    }

    public int[] getLocEdgeCounts() {
        int locCount = 0;
        int edgeCount = 0;
        Location loc = this.locations;
        while (loc != null) {
            ++locCount;
            Edge edge = loc.outgoingEdges;
            while (edge != null) {
                ++edgeCount;
                edge = edge.nextOutgoing;
            }
            loc = loc.nextLoc;
        }
        return new int[]{locCount, edgeCount};
    }

    public void registerLocation(Location loc) {
        if (this.lastLocation == null) {
            this.locations = loc;
        } else {
            this.lastLocation.nextLoc = loc;
            loc.prevLoc = this.lastLocation;
        }
        this.lastLocation = loc;
    }

    public void removeLocation(Location loc) {
        Assert.check((this.initial != loc ? 1 : 0) != 0);
        if (this.locations == loc) {
            this.locations = loc.nextLoc;
        }
        if (this.lastLocation == loc) {
            this.lastLocation = loc.prevLoc;
        }
        loc.removeInternal();
    }

    public boolean isEmpty() {
        return this.locations == null;
    }

    public void clear() {
        this.locations = null;
        this.lastLocation = null;
        this.initial = null;
    }

    public boolean hasMarkedLoc() {
        for (Location loc : this) {
            if (!loc.marked) continue;
            return true;
        }
        return false;
    }

    public final class LocationIterator
    implements Iterator<Location> {
        private Location loc;

        public LocationIterator(Location loc) {
            this.loc = loc;
        }

        @Override
        public boolean hasNext() {
            return this.loc != null;
        }

        @Override
        public Location next() {
            Location lc = this.loc;
            this.loc = this.loc.nextLoc;
            return lc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

