/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.eTMap.ETMapFactory;
import org.eclipse.etrice.core.etmap.eTMap.Mapping;
import org.eclipse.etrice.core.etmap.eTMap.MappingModel;
import org.eclipse.etrice.core.etmap.eTMap.SubSystemMapping;
import org.eclipse.etrice.core.etphys.eTPhys.ETPhysFactory;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeClass;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalModel;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalSystem;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.etphys.eTPhys.RuntimeClass;
import org.eclipse.etrice.core.etphys.eTPhys.ThreadModel;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@FinalFieldsConstructor
public class TestInstanceCreator {
    private static final String ANNOTATION_TYPE_NAME = "TestInstance";
    @Extension
    private final RoomFactory _roomFactory = RoomFactory.eINSTANCE;
    @Extension
    private final ETMapFactory _eTMapFactory = ETMapFactory.eINSTANCE;
    @Extension
    private final ETPhysFactory _eTPhysFactory = ETPhysFactory.eINSTANCE;
    private final ILogger logger;
    private final IDiagnostician diagnostician;

    public List<Resource> createInstancesAndMapping(Collection<URI> modelsURIs, ResourceSet rs) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        ArrayList roomModels = CollectionLiterals.newArrayList();
        ArrayList physModels = CollectionLiterals.newArrayList();
        Consumer<Resource> consumer = it -> {
            Consumer<EObject> consumer = it_1 -> {
                boolean bl = false;
                if (it_1 instanceof RoomModel) {
                    bl = true;
                    boolean bl2 = modelsURIs.contains(((RoomModel)it_1).eResource().getURI());
                    if (bl2) {
                        roomModels.add((RoomModel)it_1);
                    }
                }
                if (!bl && it_1 instanceof PhysicalModel) {
                    bl = true;
                    physModels.add((PhysicalModel)it_1);
                }
            };
            it.getContents().forEach(consumer);
        };
        rs.getResources().forEach(consumer);
        Functions.Function2 function2 = (list, model) -> {
            Functions.Function1 function1 = it -> this.hasTestAnnotation((StructureClass)it);
            Iterable iterable = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)model.getRoomClasses(), SubSystemClass.class), (Functions.Function1)function1);
            Iterables.addAll((Collection)list, (Iterable)iterable);
            return list;
        };
        ArrayList allTestSubSystems = (ArrayList)IterableExtensions.fold((Iterable)roomModels, (Object)CollectionLiterals.newArrayList(), (Functions.Function2)function2);
        ArrayList allAnnotatedClasses = CollectionLiterals.newArrayList((Object[])((StructureClass[])Conversions.unwrapArray((Object)allTestSubSystems, StructureClass.class)));
        SubSystemClass subSystemClass = this._roomFactory.createSubSystemClass();
        Procedures.Procedure1 procedure1 = it -> it.setName("DerivedTestSubSystem");
        SubSystemClass derivedSubSystem = (SubSystemClass)ObjectExtensions.operator_doubleArrow((Object)subSystemClass, (Procedures.Procedure1)procedure1);
        Object object = model -> {
            EList eList = derivedSubSystem.getActorRefs();
            Functions.Function1 function1 = it -> this.hasTestAnnotation((StructureClass)it);
            Functions.Function1 function12 = ac -> {
                ActorRef actorRef = null;
                allAnnotatedClasses.add(ac);
                ActorRef actorRef2 = this._roomFactory.createActorRef();
                Procedures.Procedure1 procedure1 = it -> {
                    String string = ac.getName();
                    String string2 = "ref_" + string;
                    it.setName(string2);
                    it.setType(ac);
                };
                actorRef = (ActorRef)ObjectExtensions.operator_doubleArrow((Object)actorRef2, (Procedures.Procedure1)procedure1);
                return actorRef;
            };
            Iterable iterable = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)model.getRoomClasses(), ActorClass.class), (Functions.Function1)function1), (Functions.Function1)function12);
            Iterables.addAll((Collection)eList, (Iterable)iterable);
        };
        roomModels.forEach(object);
        boolean bl4 = derivedSubSystem.getActorRefs().isEmpty();
        int n2 = n = bl4 ? 0 : 1;
        if (n != 0) {
            allTestSubSystems.add(derivedSubSystem);
        }
        if (bl3 = allTestSubSystems.isEmpty()) {
            return CollectionLiterals.emptyList();
        }
        int n3 = allAnnotatedClasses.size();
        boolean bl5 = bl2 = n3 > 1;
        if (bl2) {
            object = roomCls -> {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("TestInstanceCreator: mapping failed, multiple test instances present");
                this.diagnostician.error(stringConcatenation.toString(), (EObject)roomCls, null);
            };
            allAnnotatedClasses.forEach(object);
            return null;
        }
        object = (list, model) -> {
            EList eList = model.getSystems();
            Iterables.addAll((Collection)list, (Iterable)eList);
            return list;
        };
        List allPhysSystems = (List)IterableExtensions.fold((Iterable)physModels, (Object)CollectionLiterals.newArrayList(), (Functions.Function2)object);
        n = allPhysSystems.size();
        boolean bl6 = bl = n == 0;
        if (bl) {
            allPhysSystems.add(this.createDefaultPhysicalSystem());
        } else {
            boolean bl7;
            int n4 = allPhysSystems.size();
            boolean bl8 = bl7 = n4 > 1;
            if (bl7) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                stringConcatenation.append("TestInstanceCreator: mapping failed, found ");
                int n5 = allPhysSystems.size();
                stringConcatenation.append((Object)n5);
                stringConcatenation.append(" physical systems");
                this.logger.logError(stringConcatenation.toString());
                return null;
            }
        }
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("TestInstanceCreator: creating instance and mapping for ");
        String string = ((StructureClass)IterableExtensions.head((Iterable)allAnnotatedClasses)).getName();
        stringConcatenation.append(string);
        stringConcatenation.append(":");
        String string2 = ((StructureClass)IterableExtensions.head((Iterable)allAnnotatedClasses)).eClass().getName();
        stringConcatenation.append(string2);
        this.logger.logInfo(stringConcatenation.toString());
        PhysicalSystem physSystem = (PhysicalSystem)IterableExtensions.head((Iterable)allPhysSystems);
        SubSystemClass testSubSystem = (SubSystemClass)IterableExtensions.head((Iterable)allTestSubSystems);
        LogicalSystem logicalSystem = this._roomFactory.createLogicalSystem();
        Procedures.Procedure1 procedure12 = it -> it.setName("DerivedTestSystem");
        LogicalSystem testSystem = (LogicalSystem)ObjectExtensions.operator_doubleArrow((Object)logicalSystem, (Procedures.Procedure1)procedure12);
        EList eList = testSystem.getSubSystems();
        SubSystemRef subSystemRef = this._roomFactory.createSubSystemRef();
        Procedures.Procedure1 procedure13 = it -> {
            String string = testSubSystem.getName();
            String string2 = "ref_" + string;
            it.setName(string2);
            it.setType(testSubSystem);
        };
        SubSystemRef subSystemRef2 = (SubSystemRef)ObjectExtensions.operator_doubleArrow((Object)subSystemRef, (Procedures.Procedure1)procedure13);
        eList.add((Object)subSystemRef2);
        RoomModel roomModel = this._roomFactory.createRoomModel();
        Procedures.Procedure1 procedure14 = it -> {
            boolean bl;
            it.setName("DerivedTestRoomModel");
            EList eList = it.getRoomClasses();
            eList.add((Object)testSystem);
            Resource resource = testSubSystem.eResource();
            boolean bl2 = bl = resource == null;
            if (bl) {
                EList eList2 = it.getRoomClasses();
                eList2.add((Object)testSubSystem);
            }
        };
        RoomModel testRoomModel = (RoomModel)ObjectExtensions.operator_doubleArrow((Object)roomModel, (Procedures.Procedure1)procedure14);
        MappingModel mappingModel = this._eTMapFactory.createMappingModel();
        Procedures.Procedure1 procedure15 = it -> {
            it.setName("DerivedTestMappingModel");
            EList eList = it.getMappings();
            Mapping mapping = this._eTMapFactory.createMapping();
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setLogicalSys(testSystem);
                it_1.setPhysicalSys(physSystem);
                EList eList = it_1.getSubsysMappings();
                Functions.Function1 function1 = subSysRef -> {
                    SubSystemMapping subSystemMapping = this._eTMapFactory.createSubSystemMapping();
                    Procedures.Procedure1 procedure1 = it_2 -> {
                        it_2.setLogicalSubSys(subSysRef);
                        it_2.setNode((NodeRef)IterableExtensions.head((Iterable)physSystem.getNodeRefs()));
                    };
                    return (SubSystemMapping)ObjectExtensions.operator_doubleArrow((Object)subSystemMapping, (Procedures.Procedure1)procedure1);
                };
                List list = ListExtensions.map((List)testSystem.getSubSystems(), (Functions.Function1)function1);
                Iterables.addAll((Collection)eList, (Iterable)list);
            };
            Mapping mapping2 = (Mapping)ObjectExtensions.operator_doubleArrow((Object)mapping, (Procedures.Procedure1)procedure1);
            eList.add((Object)mapping2);
        };
        MappingModel testMappingModel = (MappingModel)ObjectExtensions.operator_doubleArrow((Object)mappingModel, (Procedures.Procedure1)procedure15);
        Resource resource = null;
        Resource resource2 = testSubSystem.eResource();
        boolean bl9 = resource2 != null;
        resource = bl9 ? testSubSystem.eResource() : ((StructureClass)IterableExtensions.head((Iterable)allAnnotatedClasses)).eResource();
        Resource existingResource = resource;
        URI uriPath = existingResource.getURI().trimFileExtension().trimSegments(1);
        Resource etmapRes = rs.createResource(uriPath.appendSegment("DerivedTestMappingModel").appendFileExtension("etmap"));
        EList eList2 = etmapRes.getContents();
        eList2.add((Object)testMappingModel);
        Resource roomRes = rs.createResource(uriPath.appendSegment("DerivedTestRoomModel").appendFileExtension("room"));
        EList eList3 = roomRes.getContents();
        eList3.add((Object)testRoomModel);
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Resource[]{etmapRes, roomRes}));
    }

    protected boolean hasTestAnnotation(StructureClass cls) {
        Functions.Function1 function1 = it -> {
            String string = it.getType().getName();
            return Objects.equal((Object)string, (Object)ANNOTATION_TYPE_NAME);
        };
        return IterableExtensions.exists((Iterable)cls.getAnnotations(), (Functions.Function1)function1);
    }

    private PhysicalSystem createDefaultPhysicalSystem() {
        PhysicalSystem physicalSystem = null;
        RuntimeClass runtimeClass = this._eTPhysFactory.createRuntimeClass();
        Procedures.Procedure1 procedure1 = it -> {
            it.setName("DefaultRuntimeClass");
            it.setThreadModel(ThreadModel.MULTI_THREADED);
        };
        RuntimeClass runtimeClass2 = (RuntimeClass)ObjectExtensions.operator_doubleArrow((Object)runtimeClass, (Procedures.Procedure1)procedure1);
        NodeClass nodeClass = this._eTPhysFactory.createNodeClass();
        Procedures.Procedure1 procedure12 = it -> {
            it.setRuntime(runtimeClass2);
            it.setPriomin(1L);
            it.setPriomax(10L);
            EList eList = it.getThreads();
            PhysicalThread physicalThread = this._eTPhysFactory.createPhysicalThread();
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setName("DefaultPhysicalThread");
                it_1.setDefault(true);
                it_1.setExecmode(ExecMode.MIXED);
                it_1.setTime(100000000L);
                it_1.setPrio(5L);
                it_1.setStacksize(1024);
                it_1.setMsgblocksize(128);
                it_1.setMsgpoolsize(100);
            };
            PhysicalThread physicalThread2 = (PhysicalThread)ObjectExtensions.operator_doubleArrow((Object)physicalThread, (Procedures.Procedure1)procedure1);
            eList.add((Object)physicalThread2);
        };
        NodeClass nodeClass2 = (NodeClass)ObjectExtensions.operator_doubleArrow((Object)nodeClass, (Procedures.Procedure1)procedure12);
        PhysicalSystem physicalSystem2 = this._eTPhysFactory.createPhysicalSystem();
        Procedures.Procedure1 procedure13 = it -> {
            it.setName("GenericPhysicalSystem");
            EList eList = it.getNodeRefs();
            NodeRef nodeRef = this._eTPhysFactory.createNodeRef();
            Procedures.Procedure1 procedure1 = it_1 -> {
                it_1.setName("node");
                it_1.setType(nodeClass2);
            };
            NodeRef nodeRef2 = (NodeRef)ObjectExtensions.operator_doubleArrow((Object)nodeRef, (Procedures.Procedure1)procedure1);
            eList.add((Object)nodeRef2);
        };
        physicalSystem = (PhysicalSystem)ObjectExtensions.operator_doubleArrow((Object)physicalSystem2, (Procedures.Procedure1)procedure13);
        return physicalSystem;
    }

    public TestInstanceCreator(ILogger logger, IDiagnostician diagnostician) {
        this.logger = logger;
        this.diagnostician = diagnostician;
    }
}

