/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *   Vincent Lorenzo (CEA-LIST) - Bug 337326 - Show/Hide Column : Sort the columns by name
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *   Gregoire Dupe (Mia-Software) - Bug 366804 - [Restructuring] Table widget upgrade
 *   Gregoire Dupe (Mia-Software) - Bug 367613 - Table widget refactoring
 *   Gregoire Dupe (Mia-Software) - Bug 369987 - [Restructuring][Table] Switch to the new customization and facet framework
 *   Gregoire Dupe (Mia-Software) - Bug 373078 - API Cleaning
 *****************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.internal.exported;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.ValueColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.workbench.expression.TableTester;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public final class TableWidgetInternalUtils {

	private TableWidgetInternalUtils() {

	}

	/**
	 * This method returns the name for the column
	 * 
	 * @param columnDescription
	 *            a column
	 * @return the name of the column
	 */
	public static String getColumnName(final Column columnDescription) {
		String columnName;
		if (columnDescription instanceof SourceColumn) {
			columnName = Messages.NatTableWidget_queryContext;
		} else if (columnDescription instanceof FeatureColumn) {
			FeatureColumn attributeColumn = (FeatureColumn) columnDescription;
			final ETypedElement eTypedElement = attributeColumn.getFeature();
			if (eTypedElement instanceof EStructuralFeature) {
				EStructuralFeature structuralFeature = (EStructuralFeature) eTypedElement;
				if (structuralFeature.isDerived()) {
					columnName = "/" + structuralFeature.getName(); //$NON-NLS-1$
				} else {
					columnName = structuralFeature.getName();
				}
			} else {
				columnName = eTypedElement.getName();
			}

		} else if (columnDescription instanceof ValueColumn) {
			// TODO should be externalized
			columnName = "Value"; //$NON-NLS-1$
		} else {
			Logger.logWarning("Unhandled column description type", Activator.getDefault()); //$NON-NLS-1$
			columnName = ""; //$NON-NLS-1$
		}
		return columnName;
	}
	
	public static ETypedElement getPresentabilityQuery(final Table tableInstance) {
		ETypedElement presentabilityQuery = null;
		// dynamic presentability query
		presentabilityQuery = tableInstance.getCanBePresentedInTheTable();
		if (presentabilityQuery == null) {
			// static presentability query
			TableConfiguration tableConfiguration = tableInstance.getTableConfiguration();
			if (tableConfiguration != null) {
				presentabilityQuery = tableConfiguration.getCanBePresentedInTheTable();
			}
		}
		return presentabilityQuery;
	}

	/**
	 * Test if the provided {@link IWorkbenchPart} is an {@link IEditorPart} and
	 * has an adaptor for {@link INatTableWidgetProvider}
	 * 
	 * @param part
	 *            the part to test
	 * @return <code>true</code> if the {@link IEditorPart}provides an
	 *         adaptor for {@link INatTableWidgetProvider}
	 */
	public static boolean testIsTableEditor(final IWorkbenchPart part) {
		return TableTester.testIsTableEditor(part);
	}
	
}
