/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public final class TableTestUtils {
    private static final String UML_EDITOR = "org.eclipse.uml2.uml.editor.presentation.UMLEditorID";
    private static final String RESOURCES = "/resources/v0_2/";

    private TableTestUtils() {
    }

    public static void createTestProject(String projectName, String testFile) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject testProject = workspace.getRoot().getProject(projectName);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)(RESOURCES + testFile), (IProject)testProject, (String)("/" + testFile), (Bundle)bundle);
    }

    public static void openUMLEditorOnTestFile(final String projectName, final String testFile) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IFile umlFile = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(testFile);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)umlFile, (String)TableTestUtils.UML_EDITOR);
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static ITableWidget getNatTableWidgetOfActivePart() {
        final ITableWidget[] result = new ITableWidget[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.getActiveEditor();
                ITableWidgetProvider tableWidgetProvider = (ITableWidgetProvider)editor.getAdapter(ITableWidgetProvider.class);
                result[0] = tableWidgetProvider.getTableWidget();
            }
        });
        return result[0];
    }
}

