/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.TableTestUtils;
import org.eclipse.emf.facet.widgets.table.ui.TableUtils;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactoryFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.ITableEditorFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug387008Test {
    private static final int NB_TO_REMOVE = 3;
    private static final String BUG_ID = "Bug387008";

    @Test
    public void createRemoveRowByEObjectCommand() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Bug387008Test.getEPackage((ResourceSet)resourceSet);
        Table table = Bug387008Test.getTable((ResourceSet)resourceSet, (List<? extends EObject>)ePackage.getEClassifiers());
        ITableCommandFactory tableCmdFactory = Bug387008Test.initTableCmdFactory((ResourceSet)resourceSet, table);
        ArrayList<EObject> toBeRemoved = new ArrayList<EObject>();
        int i = 0;
        while (i < 3) {
            toBeRemoved.add(((Row)table.getRows().get(i)).getElement());
            ++i;
        }
        int nbRowBerforeRm = table.getRows().size();
        Command cmd = tableCmdFactory.createRemoveRowByEObjectCommand(toBeRemoved);
        Bug387008Test.assertCmdExecutable(cmd);
        cmd.execute();
        int nbRowAfterRm = table.getRows().size();
        Assert.assertEquals((String)"The number of row must have decrease.", (long)(nbRowBerforeRm - 3), (long)nbRowAfterRm);
    }

    private static void assertCmdExecutable(Command cmd) {
        Assert.assertTrue((String)"The command must be executable.", (boolean)cmd.canExecute());
    }

    private static ITableCommandFactory initTableCmdFactory(ResourceSet resourceSet, Table table) {
        EditingDomain editingDomain = Bug387008Test.initEditingDomain();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(resourceSet);
        ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(editingDomain);
        ITableCommandFactory tableCmdFactory = ITableCommandFactoryFactory.DEFAULT.createTableCommandFactory(table, editingDomain, commandFactory, facetManager);
        return tableCmdFactory;
    }

    @Test
    public void createAddRowsCommand() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Bug387008Test.getEPackage((ResourceSet)resourceSet);
        Table table = Bug387008Test.getTable((ResourceSet)resourceSet, Collections.singletonList(ePackage));
        ITableCommandFactory tableCmdFactory = Bug387008Test.initTableCmdFactory((ResourceSet)resourceSet, table);
        int nbRowBeforeAdd = table.getRows().size();
        int nbColumnBeforeAdd = table.getColumns().size();
        Command cmd1 = tableCmdFactory.createAddRowsCommand((Collection)ePackage.getEClassifiers());
        Bug387008Test.assertCmdExecutable(cmd1);
        cmd1.execute();
        int nbRowAfterAdd = table.getRows().size();
        int nbColumnAfterAdd = table.getColumns().size();
        Assert.assertEquals((String)"The number of row must have increase.", (long)(nbRowBeforeAdd + ePackage.getEClassifiers().size()), (long)nbRowAfterAdd);
        Assert.assertTrue((String)"The number of column must have increase.", (nbColumnBeforeAdd < nbColumnAfterAdd ? 1 : 0) != 0);
        Command cmd2 = tableCmdFactory.createAddRowsCommand((Collection)ePackage.getEClassifiers());
        Assert.assertNull((String)"The command must be null, because there are nothing to do", (Object)cmd2);
        int nbRowAfterAdd2 = table.getRows().size();
        int nbColumnAfterAdd2 = table.getColumns().size();
        Assert.assertEquals((String)"The number of row must not have changed.", (long)nbRowAfterAdd, (long)nbRowAfterAdd2);
        Assert.assertEquals((String)"The number of column must not have changed.", (long)nbColumnAfterAdd, (long)nbColumnAfterAdd2);
    }

    private static EditingDomain initEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        return editingDomain;
    }

    protected static Table getTable(ResourceSet resourceSet, List<? extends EObject> eObjects) {
        URI tableUri = URI.createPlatformResourceURI((String)("/" + Bug387008Test.class.getName() + "/table.xmi"), (boolean)true);
        Resource tableResouce = resourceSet.createResource(tableUri);
        Table table = TableUtils.createTableInstance(eObjects, (String)Bug387008Test.class.getSimpleName(), null, null, null);
        tableResouce.getContents().add((Object)table);
        return table;
    }

    protected static EPackage getEPackage(ResourceSet resourceSet) {
        URI modelUri = URI.createPlatformResourceURI((String)("/" + Bug387008Test.class.getName() + "/model.xmi"), (boolean)true);
        Resource modelResouce = resourceSet.createResource(modelUri);
        EPackage ePackage = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        modelResouce.getContents().add((Object)ePackage);
        return ePackage;
    }

    @Test
    public void setLoadedFacetSets() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Bug387008Test.getEPackage((ResourceSet)resourceSet);
        Table table = Bug387008Test.getTable((ResourceSet)resourceSet, (List<? extends EObject>)ePackage.getEClassifiers());
        EditingDomain editingDomain = Bug387008Test.initEditingDomain();
        ITableEditorFactory.DEFAULT.openOn(table, editingDomain);
        ITableWidget tableWidget = TableTestUtils.getNatTableWidgetOfActivePart();
        Bug387008Test.assertNoFacetShouldBeLoaded(table);
        List<FacetSet> facetSets = Bug387008Test.initFacetSets((ResourceSet)resourceSet);
        tableWidget.setLoadedFacetSets(facetSets);
        Assert.assertEquals((String)"Only the test facetSet should be loaded", (long)facetSets.size(), (long)table.getFacetSets().size());
        for (FacetSet facetSet : facetSets) {
            Assert.assertTrue((String)"Test facetSets should be loaded", (boolean)table.getFacetSets().contains((Object)facetSet));
        }
        List emptyList = Collections.emptyList();
        tableWidget.setLoadedFacetSets(emptyList);
        Bug387008Test.assertNoFacetShouldBeLoaded(table);
    }

    private static List<FacetSet> initFacetSets(ResourceSet resourceSet) {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        int i = 1;
        while (i <= 2) {
            Resource resource = Bug387008Test.getFacetSetResource(resourceSet, i);
            FacetSet facetSet = (FacetSet)resource.getContents().get(0);
            result.add(facetSet);
            ++i;
        }
        return result;
    }

    private static Resource getFacetSetResource(ResourceSet resourceSet, int index) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        URI tableUri = URI.createPlatformPluginURI((String)("/" + bundleName + "/resources/v0_2/" + BUG_ID + "/" + Bug387008Test.class.getSimpleName() + "_" + index + ".efacet"), (boolean)true);
        return resourceSet.getResource(tableUri, true);
    }

    @Test
    public void createSetFacetsCommand() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Bug387008Test.getEPackage((ResourceSet)resourceSet);
        Table table = Bug387008Test.getTable((ResourceSet)resourceSet, Collections.singletonList(ePackage));
        Bug387008Test.assertNoFacetShouldBeLoaded(table);
        ITableCommandFactory tableCmdFactory = Bug387008Test.initTableCmdFactory((ResourceSet)resourceSet, table);
        List<FacetSet> facetSets = Bug387008Test.initFacetSets((ResourceSet)resourceSet);
        Command cmd1 = tableCmdFactory.createSetFacetSetsCommand(facetSets);
        Bug387008Test.assertCmdExecutable(cmd1);
        cmd1.execute();
        Assert.assertEquals((String)"Only the test facetSet should be loaded", (long)facetSets.size(), (long)table.getFacetSets().size());
        for (FacetSet facetSet : facetSets) {
            Assert.assertTrue((String)"Test facetSets should be loaded", (boolean)table.getFacetSets().contains((Object)facetSet));
        }
        List emptyList = Collections.emptyList();
        Command cmd2 = tableCmdFactory.createSetFacetSetsCommand(emptyList);
        Bug387008Test.assertCmdExecutable(cmd2);
        cmd2.execute();
        Bug387008Test.assertNoFacetShouldBeLoaded(table);
        Command cmd3 = tableCmdFactory.createSetFacetSetsCommand(facetSets);
        Bug387008Test.assertCmdExecutable(cmd3);
        cmd3.execute();
        Assert.assertEquals((String)"Only the test facetSet should be loaded", (long)facetSets.size(), (long)table.getFacetSets().size());
        for (FacetSet facetSet : facetSets) {
            Assert.assertTrue((String)"Test facetSets should be loaded", (boolean)table.getFacetSets().contains((Object)facetSet));
        }
        Command cmd4 = tableCmdFactory.createSetFacetSetsCommand(facetSets);
        Assert.assertNull((String)"The command must be null", (Object)cmd4);
    }

    private static void assertNoFacetShouldBeLoaded(Table table) {
        Assert.assertEquals((String)"No facetSet should be loaded", (long)0L, (long)table.getFacetSets().size());
    }

    @After
    public void after() {
        TestUtils.closeAllEditors();
    }
}

