/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.swt.internal.exported.TestUtils;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IMustRemoveNonConformingElementsDialog;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.exported.TableEditorConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug391442 {
    private static final String PROJECT_NAME = Bug391442.class.getName();
    private static final String TABLE_FILENAME = String.valueOf(Bug391442.class.getSimpleName()) + ".table";

    @Test
    public void test1() throws IOException, CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            project2.delete(true, (IProgressMonitor)monitor);
            ++n2;
        }
        IProject project = workspace.getRoot().getProject(PROJECT_NAME);
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)("/resources/v0_2/" + Bug391442.class.getSimpleName() + "/" + TABLE_FILENAME), (IProject)project, (String)(String.valueOf('/') + TABLE_FILENAME), (Bundle)bundle);
        final IFile tableFile = project.getFile(TABLE_FILENAME);
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    editor[0] = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)tableFile, (String)TableEditorConstants.getEditorID());
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ITableWidgetProvider tableWProvider = (ITableWidgetProvider)editor[0].getAdapter(ITableWidgetProvider.class);
        Assert.assertNotNull((String)"The opened editor is expected to be an ITableWidgetProvider.", (Object)tableWProvider);
        ITableWidget widget = tableWProvider.getTableWidget();
        ResourceSet resourceSet = widget.getTable().eResource().getResourceSet();
        String path = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + "/resources/v0_2/" + this.getClass().getSimpleName() + "/" + this.getClass().getSimpleName() + ".efacet";
        URI uri = URI.createPlatformPluginURI((String)path, (boolean)true);
        Resource facetSetR = resourceSet.getResource(uri, true);
        FacetSet facetSet1 = (FacetSet)facetSetR.getContents().get(0);
        FacetSet facetSet2 = (FacetSet)facetSet1.getESubpackages().get(0);
        Facet facet = (Facet)facetSet2.getEClassifier(Bug391442.class.getSimpleName());
        EStructuralFeature eStructFeature = (EStructuralFeature)facet.getFacetElements().get(0);
        IAllowedContentsETypedElementSelectionDialog dialog = widget.openCanBePresentedInTheTableDialog();
        dialog.select((ETypedElement)eStructFeature);
        IMustRemoveNonConformingElementsDialog dialog2 = dialog.pressOk();
        if (dialog2 != null) {
            dialog2.pressNo();
        }
        junit.framework.Assert.assertEquals((Object)eStructFeature, (Object)widget.getCanBePresentedInTheTable());
    }

    @After
    public void after() {
        TestUtils.closeAllEditors();
    }
}

