/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread.TableInAShell;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread.Utils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Test;

public class Bug387753 {
    private Shell shell = null;

    @Test
    public void test() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        EPackage ePackage = Utils.getEPackage((ResourceSet)resourceSet, this.getClass().getSimpleName());
        TableConfiguration tableConfig = Utils.getTableConfiguration((ResourceSet)resourceSet, this.getClass().getSimpleName());
        Table table = Utils.getNewTable((ResourceSet)resourceSet, new ArrayList(), tableConfig, this.getClass().getName());
        TableInAShell tableInAShell = Utils.openTableInAShell(table);
        this.shell = tableInAShell.getShell();
        ITableWidgetInternal widget = (ITableWidgetInternal)tableInAShell.getTableWidget();
        Bug387753.assertOnlyOneColumn((ITableWidget)widget);
        EClassifier eClassifier = (EClassifier)ePackage.getEClassifiers().get(0);
        widget.addRows(new ArrayList<EClassifier>(Collections.singletonList(eClassifier)));
        Bug387753.assertOnlyOneColumn((ITableWidget)widget);
        Assert.assertEquals((String)"One row is expected", (int)1, (int)Bug387753.getNbRows((ITableWidget)widget));
        EditingDomain editingDomain = widget.getEditingDomain();
        editingDomain.getCommandStack().undo();
        Bug387753.assertOnlyOneColumn((ITableWidget)widget);
        Assert.assertEquals((String)"Zero row is expected", (int)0, (int)Bug387753.getNbRows((ITableWidget)widget));
        editingDomain.getCommandStack().redo();
        Bug387753.assertOnlyOneColumn((ITableWidget)widget);
        Assert.assertEquals((String)"One row is expected", (int)1, (int)Bug387753.getNbRows((ITableWidget)widget));
    }

    private static void assertOnlyOneColumn(ITableWidget widget) {
        Assert.assertEquals((String)"Only one column is expected", (int)1, (int)Bug387753.getNbVisibleColumns(widget));
    }

    private static int getNbRows(ITableWidget widget) {
        return ((ITableWidgetInternal)widget).getTable().getRows().size();
    }

    private static int getNbVisibleColumns(ITableWidget widget) {
        return ((ITableWidgetInternal)widget).getVisibleColumns(false).size();
    }

    @After
    public void after() {
        Utils.closeShell(this.shell);
    }
}

