/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread.Bug387008Test;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.notuithread.TableInAShell;
import org.eclipse.emf.facet.widgets.table.ui.TableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static TableInAShell openTableInAShell(final Table table) {
        final Shell[] sheelPtr = new Shell[1];
        final ITableWidget[] tableWidgetPtr = new ITableWidget[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                sheelPtr[0] = new Shell(Display.getDefault(), 65728);
                tableWidgetPtr[0] = ITableWidgetFactory.INSTANCE.createTableWidget((Composite)sheelPtr[0], null, table, null);
                ((ITableWidgetInternal)tableWidgetPtr[0]).getComposite().setLayoutData((Object)new GridData(1808));
                sheelPtr[0].setLayout((Layout)new GridLayout(1, true));
                sheelPtr[0].open();
            }
        });
        return new TableInAShell(tableWidgetPtr[0], sheelPtr[0]);
    }

    public static Table getNewTable(ResourceSet resourceSet, List<? extends EObject> eObjects, TableConfiguration tableConfig, String projectName) {
        URI tableUri = URI.createPlatformResourceURI((String)("/" + projectName + "/table.xmi"), (boolean)true);
        Resource tableResouce = resourceSet.createResource(tableUri);
        Table table = TableUtils.createTableInstance(eObjects, (String)Bug387008Test.class.getSimpleName(), (TableConfiguration)tableConfig, null, null);
        tableResouce.getContents().add((Object)table);
        return table;
    }

    public static TableConfiguration getTableConfiguration(ResourceSet resourceSet, String bugId) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        URI tableConfigUri = URI.createPlatformPluginURI((String)("/" + bundleName + "/resources/v0_2/" + bugId + "/" + bugId + ".tableconfiguration"), (boolean)true);
        return (TableConfiguration)resourceSet.getResource(tableConfigUri, true).getContents().get(0);
    }

    protected static EPackage getEPackage(ResourceSet resourceSet, String bugId) {
        URI modelUri = URI.createPlatformResourceURI((String)("/" + bugId + "/model.xmi"), (boolean)true);
        Resource modelResouce = resourceSet.createResource(modelUri);
        EPackage ePackage = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        modelResouce.getContents().add((Object)ePackage);
        return ePackage;
    }

    public static void closeShell(Shell shell) {
        if (shell != null) {
            final Shell fShell = shell;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    fShell.close();
                }
            });
        }
    }
}

