/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.swtbot;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.ScreenShotUtils;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidget;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class Bug367700 {
    private static final int LONG_TIMEOUT = 60000;
    private static final String TEST_CUSTOM = "testUIEcoreUICustom";
    private static final String RESOURCES = "/resources/v0_2/" + Bug367700.class.getSimpleName() + '/';
    private static final String PROJECT_NAME = Bug367700.class.getName();
    private static final String ECORE_TABLE_FILE_NAME = String.valueOf(Bug367700.class.getSimpleName()) + ".table";
    private static final String ECORE_FILE_NAME = String.valueOf(Bug367700.class.getSimpleName()) + ".ecore";
    private static final int INITIAL_NB_COLUMN = 33;
    private int expectedInitNbCustom;
    private List<?> custom;
    private SWTWorkbenchBot bot;
    private EditingDomain editingDomain;
    private ITableWidgetInternal tableWidget;
    private EList<Column> columns;
    private SWTBotEditor editor;

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.TIMEOUT = 30000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)(String.valueOf(RESOURCES) + ECORE_TABLE_FILE_NAME), (IProject)testProject, (String)(String.valueOf('/') + ECORE_TABLE_FILE_NAME), (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)(String.valueOf(RESOURCES) + ECORE_FILE_NAME), (IProject)testProject, (String)(String.valueOf('/') + ECORE_FILE_NAME), (Bundle)bundle);
        this.bot = new SWTWorkbenchBot();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        this.editor = this.bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        this.editor.setFocus();
        Assert.assertTrue((boolean)this.editor.isActive());
        this.tableWidget = (ITableWidgetInternal)Bug367700.getTableWidget(this.editor);
        this.columns = this.tableWidget.getTable().getColumns();
        this.editingDomain = Bug367700.getEditingDomain(this.editor);
        this.custom = this.tableWidget.getTable().getCustomizations();
        this.expectedInitNbCustom = 1;
        Assert.assertEquals((String)"We expect that only the local customization is loaded at the beginning of the test.", (long)this.expectedInitNbCustom, (long)this.custom.size());
    }

    private static ITableWidget getTableWidget(SWTBotEditor editor) {
        ITableWidgetProvider natTableWidgetPart = (ITableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(ITableWidgetProvider.class);
        return natTableWidgetPart.getTableWidget();
    }

    private static EditingDomain getEditingDomain(SWTBotEditor editor) {
        return ((IEditingDomainProvider)((IEditorReference)editor.getReference()).getPart(true)).getEditingDomain();
    }

    private void openTableFile(String fileName) {
        ScreenShotUtils.capture();
        this.bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        ScreenShotUtils.capture();
        SWTBotView view = this.bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)this.bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        item.doubleClick();
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadCustomizationDialogStep1() {
        ScreenShotUtils.capture();
        DialogStatus dialogStatus1 = this.openCustomizationDialog();
        int nbAvailableCustonBeforeLoadOne = dialogStatus1.countAvailableCustom();
        dialogStatus1.getAvailableCustomTree().select(new int[]{0});
        dialogStatus1.getBot().button(">").click();
        Assert.assertEquals((String)"We expect that the loaded custom has been removed from the available custom list.", (long)(nbAvailableCustonBeforeLoadOne - 1), (long)dialogStatus1.countAvailableCustom());
        dialogStatus1.getBot().button("OK").click();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We expect that one more custom is loaded", (long)(this.expectedInitNbCustom + 1), (long)this.custom.size());
        this.editingDomain.getCommandStack().undo();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We expect to be back to the initial state.", (long)this.expectedInitNbCustom, (long)this.custom.size());
        this.editingDomain.getCommandStack().redo();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We expect that one more custom is loaded", (long)(this.expectedInitNbCustom + 1), (long)this.custom.size());
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadCustomizationDialogStep2() {
        ScreenShotUtils.capture();
        this.testOpenLoadCustomizationDialogStep1();
        DialogStatus dialogStatus2 = this.openCustomizationDialog();
        dialogStatus2.getLoadedCustomTree().setFocus();
        dialogStatus2.getLoadedCustomTree().getAllItems()[0].select();
        dialogStatus2.getBot().button("<").click();
        SWTBot warningDialogBot = this.bot.shell("Load Customizations Warning").bot();
        warningDialogBot.button("OK").click();
        dialogStatus2.getLoadedCustomTree().select(new int[]{1});
        dialogStatus2.getBot().button("<").click();
        dialogStatus2.getBot().button("OK").click();
        Assert.assertEquals((String)"We expect to be back to the initial state", (long)this.expectedInitNbCustom, (long)this.custom.size());
        this.editingDomain.getCommandStack().undo();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We expect that one more custom is loaded", (long)(this.expectedInitNbCustom + 1), (long)this.custom.size());
        this.editingDomain.getCommandStack().redo();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We expect to be back to the initial state", (long)this.expectedInitNbCustom, (long)this.custom.size());
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadCustomizationDialogStep3() {
        ScreenShotUtils.capture();
        Assert.assertEquals((long)33L, (long)this.columns.size());
        DialogStatus dialogStatus3 = this.openCustomizationDialog();
        dialogStatus3.getAvailableCustomTree().select(new String[]{TEST_CUSTOM});
        dialogStatus3.getBot().button(">").click();
        dialogStatus3.getBot().checkBox().deselect();
        dialogStatus3.getBot().button("OK").click();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We expect that one more custom is loaded.", (long)(this.expectedInitNbCustom + 1), (long)this.custom.size());
        Assert.assertEquals((String)"The facet referred by the loaded custom should not be loaded: no more column should exist.", (long)33L, (long)this.columns.size());
        this.editingDomain.getCommandStack().undo();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"We should be back in the initial state.", (long)this.expectedInitNbCustom, (long)this.custom.size());
        Assert.assertEquals((String)"The number of column should not have change.", (long)33L, (long)this.columns.size());
    }

    @Test(timeout=30000L)
    @Ignore
    public void testOpenLoadCustomizationDialogStep4() {
        ScreenShotUtils.capture();
        DialogStatus dialogStatus4 = this.openCustomizationDialog();
        ScreenShotUtils.capture((String)"Load Customizations dialog finished loading");
        dialogStatus4.getAvailableCustomTree().select(new String[]{TEST_CUSTOM});
        dialogStatus4.getBot().button(">").click();
        ScreenShotUtils.capture((String)"Selected customization");
        dialogStatus4.getBot().checkBox().select();
        ScreenShotUtils.capture((String)"Before clicking OK");
        dialogStatus4.getBot().button("OK").click();
        dialogStatus4.waitUntilDialogClosed();
        ScreenShotUtils.capture((String)"Dialog closed");
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"One more customization should be loaded.", (long)(this.expectedInitNbCustom + 1), (long)this.custom.size());
        Assert.assertEquals((String)"The loading of the facet referred by the loaded custom, should have created a new column.", (long)34L, (long)this.columns.size());
        this.editingDomain.getCommandStack().undo();
        this.tableWidget.waitForRefreshJob();
        Assert.assertEquals((String)"The loaded custom should be removed.", (long)this.expectedInitNbCustom, (long)this.custom.size());
        Assert.assertEquals((String)"The loaded facet and the corresponding column should be removed.", (long)33L, (long)this.columns.size());
        this.editor.save();
    }

    @Test(timeout=60000L)
    @Ignore
    public void testOpenLoadCustomizationDialog() throws CoreException {
        ScreenShotUtils.capture();
        this.testOpenLoadCustomizationDialogStep2();
        this.testOpenLoadCustomizationDialogStep3();
        this.testOpenLoadCustomizationDialogStep4();
    }

    private DialogStatus openCustomizationDialog() {
        DebugUtils.debug((String)"Click on Load Customizations");
        SWTBotUtils.getToolbarButton((String)"Load Customizations", (int)0, (SWTWorkbenchBot)this.bot).click();
        DebugUtils.debug((String)"Get the dialog named: Load Customizations");
        SWTBot dialogBot1 = this.bot.shell("Load Customizations").bot();
        ScreenShotUtils.capture((String)"Opened Load Customizations dialog");
        final SWTBotTree availableCustomTree = dialogBot1.treeWithLabel("Available Customizations");
        SWTBotTree loadedCustomTree = dialogBot1.treeWithLabel("Loaded Customizations");
        this.bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                ScreenShotUtils.capture((String)"Test");
                return availableCustomTree.rowCount() != 1 || !"Loading...".equals(availableCustomTree.getAllItems()[0].getText());
            }

            public String getFailureMessage() {
                return "Waiting for customizations tree to load";
            }
        });
        ScreenShotUtils.capture((String)"Load Customizations dialog finished loading");
        DialogStatus dialogStatus = new DialogStatus(dialogBot1, availableCustomTree, loadedCustomTree, (SWTBot)this.bot);
        Assert.assertTrue((String)"There has to be a localCustomization loaded by default", (dialogStatus.countLoadedCustom() >= 1 ? 1 : 0) != 0);
        return dialogStatus;
    }

    @After
    public void afterTest() {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
    }

    private class DialogStatus {
        private final SWTBotTree availableCustomTree;
        private final SWTBotTree loadedCustomTree;
        private final SWTBot dialogBot;
        private final SWTBot parentBot;
        private final SWTBotShell dialogBotShell;

        public DialogStatus(SWTBot dialogBot, SWTBotTree availableCustomTree, SWTBotTree loadedCustomTree, SWTBot parentBot) {
            this.availableCustomTree = availableCustomTree;
            this.loadedCustomTree = loadedCustomTree;
            this.dialogBot = dialogBot;
            this.dialogBotShell = this.dialogBot.shell("Load Customizations");
            this.parentBot = parentBot;
        }

        public void waitUntilDialogClosed() {
            this.parentBot.waitUntil(Conditions.shellCloses((SWTBotShell)this.dialogBotShell));
        }

        public SWTBotTree getLoadedCustomTree() {
            return this.loadedCustomTree;
        }

        public SWTBot getBot() {
            return this.dialogBot;
        }

        public SWTBotTree getAvailableCustomTree() {
            return this.availableCustomTree;
        }

        public int countAvailableCustom() {
            return this.availableCustomTree.getAllItems().length;
        }

        public int countLoadedCustom() {
            return this.loadedCustomTree.getAllItems().length;
        }
    }
}

