/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.algorithm.comment;

import org.eclipse.emf.common.util.EList;
import org.eclipse.fmc.blockdiagram.editor.algorithm.comment.CommentAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.ResizableNode;
import org.eclipse.fmc.blockdiagram.editor.algorithm.node.RotatableNode;
import org.eclipse.fmc.blockdiagram.editor.util.StyleUtil;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class BraceAlgorithm
implements CommentAlgorithm,
RotatableNode,
ResizableNode {
    protected IGaService ga = Graphiti.getGaService();
    public static final int BRACE_MINIMUM_HEIGHT = 60;
    public static final int BRACE_DEFAULT_HEIGHT = 80;
    public static final int BRACE_DEFAULT_LINEWIDTH = 2;

    @Override
    public GraphicsAlgorithm createGraphics(Diagram diagram, GraphicsAlgorithmContainer container, int x, int y, int width, int height) {
        int[] lineXy;
        int size;
        GraphicsAlgorithm containerGa = (GraphicsAlgorithm)container;
        if (width > height) {
            size = width;
            int[] nArray = new int[14];
            nArray[3] = size / 8;
            nArray[4] = size / 2;
            nArray[5] = size / 8;
            nArray[6] = size / 2;
            nArray[7] = 9 * size / 40;
            nArray[8] = size / 2;
            nArray[9] = size / 8;
            nArray[10] = size;
            nArray[11] = size / 8;
            nArray[12] = size;
            lineXy = nArray;
            this.ga.setLocationAndSize(containerGa, x, y, size, 9 * size / 40);
        } else {
            size = height;
            int[] nArray = new int[14];
            nArray[2] = size / 8;
            nArray[4] = size / 8;
            nArray[5] = size / 2;
            nArray[6] = 9 * size / 40;
            nArray[7] = size / 2;
            nArray[8] = size / 8;
            nArray[9] = size / 2;
            nArray[10] = size / 8;
            nArray[11] = size;
            nArray[13] = size;
            lineXy = nArray;
            this.ga.setLocationAndSize(containerGa, x, y, 9 * size / 40, size);
        }
        int cornerSize = size / 10;
        int[] nArray = new int[14];
        nArray[2] = cornerSize;
        nArray[3] = cornerSize;
        nArray[4] = cornerSize;
        nArray[5] = cornerSize;
        nArray[8] = cornerSize;
        nArray[9] = cornerSize;
        nArray[10] = cornerSize;
        nArray[11] = cornerSize;
        int[] lineBeforeAfter = nArray;
        Polyline polyline = this.ga.createPolyline(container, lineXy, lineBeforeAfter);
        polyline.setStyle(StyleUtil.getStyle(diagram, "Shape"));
        polyline.setLineWidth(Integer.valueOf(2));
        return polyline;
    }

    @Override
    public int getDefaultLineWidth() {
        return 2;
    }

    @Override
    public int getMinimumHeight() {
        return 60;
    }

    @Override
    public int getMinimumWidth() {
        return 13;
    }

    @Override
    public int getDefaultHeight() {
        return 80;
    }

    @Override
    public int getDefaultWidth() {
        return 18;
    }

    @Override
    public int getAngle(GraphicsAlgorithm graphicsAlgorithm) {
        Polyline polyline = (Polyline)graphicsAlgorithm;
        EList points = polyline.getPoints();
        Point point1 = (Point)points.get(1);
        Point point2 = (Point)points.get(2);
        Point point7 = (Point)points.get(7);
        if (point2.getY() == point1.getY()) {
            return point7.getY() > point1.getY() ? 0 : 180;
        }
        return point7.getX() < point1.getX() ? 90 : 270;
    }

    @Override
    public boolean isFlipped(GraphicsAlgorithm graphicsAlgorithm) {
        Polyline polyline = (Polyline)graphicsAlgorithm;
        EList points = polyline.getPoints();
        Point point1 = (Point)points.get(1);
        Point point2 = (Point)points.get(2);
        switch (this.getAngle((GraphicsAlgorithm)polyline)) {
            case 90: {
                return point1.getY() >= point2.getY();
            }
            case 180: {
                return point1.getX() <= point2.getX();
            }
            case 270: {
                return point1.getY() <= point2.getY();
            }
        }
        return point1.getX() >= point2.getX();
    }

    @Override
    public void rotate90Right(GraphicsAlgorithm graphicsAlgorithm) {
        Polyline polyline = (Polyline)graphicsAlgorithm.getGraphicsAlgorithmChildren().get(0);
        graphicsAlgorithm.setX(graphicsAlgorithm.getX() + (graphicsAlgorithm.getWidth() - graphicsAlgorithm.getHeight()) / 2);
        graphicsAlgorithm.setY(graphicsAlgorithm.getY() - (graphicsAlgorithm.getWidth() - graphicsAlgorithm.getHeight()) / 2);
        int oldWidth = graphicsAlgorithm.getWidth();
        int oldHeight = graphicsAlgorithm.getHeight();
        for (Point point : polyline.getPoints()) {
            int oldX = point.getX();
            int oldY = point.getY();
            point.setX(oldHeight - oldY);
            point.setY(oldX);
        }
        graphicsAlgorithm.setHeight(oldWidth);
        graphicsAlgorithm.setWidth(oldHeight);
        polyline.setHeight(oldWidth);
        polyline.setWidth(oldHeight);
    }

    @Override
    public void flipHorizontally(GraphicsAlgorithm graphicsAlgorithm) {
        Polyline polyline = (Polyline)graphicsAlgorithm.getGraphicsAlgorithmChildren().get(0);
        int width = graphicsAlgorithm.getWidth();
        for (Point point : polyline.getPoints()) {
            point.setX(width - point.getX());
        }
    }

    @Override
    public void flipVertically(GraphicsAlgorithm graphicsAlgorithm) {
        Polyline polyline = (Polyline)graphicsAlgorithm.getGraphicsAlgorithmChildren().get(0);
        int height = graphicsAlgorithm.getHeight();
        for (Point point : polyline.getPoints()) {
            point.setY(height - point.getY());
        }
    }

    @Override
    public void resize(GraphicsAlgorithm algorithm, int x, int y, int width, int height) {
        Polyline polyline = (Polyline)algorithm.getGraphicsAlgorithmChildren().get(0);
        int newWidth = width;
        int newHeight = height;
        int oldWidth = algorithm.getWidth();
        int oldHeight = algorithm.getHeight();
        if (newWidth > newHeight && oldWidth > oldHeight || newWidth < newHeight && oldWidth < oldHeight) {
            int oldSize;
            int newSize;
            if (newWidth > newHeight) {
                newSize = newWidth;
                oldSize = oldWidth;
                this.ga.setLocationAndSize(algorithm, x, y, newSize, 9 * newSize / 40);
            } else {
                newSize = newHeight;
                oldSize = oldHeight;
                this.ga.setLocationAndSize(algorithm, x, y, 9 * newSize / 40, newSize);
            }
            double factor = (double)newSize / (double)oldSize;
            for (Point p : polyline.getPoints()) {
                p.setX((int)((double)p.getX() * factor));
                p.setBefore((int)((double)p.getBefore() * factor));
                p.setY((int)((double)p.getY() * factor));
                p.setAfter((int)((double)p.getAfter() * factor));
            }
        } else {
            int[] lineXy;
            int newSize;
            if (newWidth > newHeight) {
                newSize = newWidth;
                int[] nArray = new int[14];
                nArray[3] = newSize / 8;
                nArray[4] = newSize / 2;
                nArray[5] = newSize / 8;
                nArray[6] = newSize / 2;
                nArray[7] = 9 * newSize / 40;
                nArray[8] = newSize / 2;
                nArray[9] = newSize / 8;
                nArray[10] = newSize;
                nArray[11] = newSize / 8;
                nArray[12] = newSize;
                lineXy = nArray;
                this.ga.setLocationAndSize(algorithm, x, y, newSize, 9 * newSize / 40);
            } else {
                newSize = newHeight;
                int[] nArray = new int[14];
                nArray[2] = newSize / 8;
                nArray[4] = newSize / 8;
                nArray[5] = newSize / 2;
                nArray[6] = 9 * newSize / 40;
                nArray[7] = newSize / 2;
                nArray[8] = newSize / 8;
                nArray[9] = newSize / 2;
                nArray[10] = newSize / 8;
                nArray[11] = newSize;
                nArray[13] = newSize;
                lineXy = nArray;
                this.ga.setLocationAndSize(algorithm, x, y, 9 * newSize / 40, newSize);
            }
            int cornerSize = newSize / 10;
            int[] nArray = new int[14];
            nArray[2] = cornerSize;
            nArray[3] = cornerSize;
            nArray[4] = cornerSize;
            nArray[5] = cornerSize;
            nArray[8] = cornerSize;
            nArray[9] = cornerSize;
            nArray[10] = cornerSize;
            nArray[11] = cornerSize;
            int[] lineBeforeAfter = nArray;
            int i = 0;
            for (Point p : polyline.getPoints()) {
                p.setX(lineXy[i]);
                p.setBefore(lineBeforeAfter[i++]);
                p.setY(lineXy[i]);
                p.setAfter(lineBeforeAfter[i++]);
            }
        }
    }
}

